/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.Checker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.ClientSession;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.auth.idp.IdentityProvider;
import de.virtimo.bpc.api.exception.IdentityProviderException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class ClientSessionsChecker
implements Checker {
    private static final Logger LOGGER = LogManager.getLogger(ClientSessionsChecker.class);
    private ScheduledExecutorService executorService;
    private ScheduledFuture<?> checkerHandle;
    private final BundleContext bundleContext;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;

    public ClientSessionsChecker(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private CoreModule getCoreModule() throws ServiceNotFoundException, ModuleNotFoundException {
        return this.moduleManagerTracker.getService().getModuleByClass(CoreModule.class);
    }

    private long getSessionCheckIntervalInSeconds(CoreModule coreModule) {
        return coreModule.getConfiguration().getSettingValue("clientSession.checkInterval").asLong(60L);
    }

    private int getInactiveSessionTimeoutMinutes(CoreModule coreModule) {
        return coreModule.getConfiguration().getSettingValue("clientSession.inactiveSessionTimeoutMinutes").asInt(0);
    }

    @Override
    public void startChecker() {
        LOGGER.info("startChecker");
        if (this.checkerHandle != null) {
            LOGGER.info("Client sessions checker is already running");
            return;
        }
        BpcServicesTracker.stopAll(this);
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(this.bundleContext, ClientSessionManager.class);
        try {
            long sessionCheckIntervalInSeconds = this.getSessionCheckIntervalInSeconds(this.getCoreModule());
            LOGGER.info("Init client sessions checker with interval: {} seconds", (Object)sessionCheckIntervalInSeconds);
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryWithNamePrefix("bpc-core-sessionchecker"));
            this.checkerHandle = this.executorService.scheduleWithFixedDelay(this.createCheckerRunnable(), sessionCheckIntervalInSeconds, sessionCheckIntervalInSeconds, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to start the client sessions checker.", (Throwable)ex);
        }
    }

    @Override
    public void stopChecker() {
        LOGGER.info("stopChecker");
        if (this.checkerHandle != null) {
            if (this.checkerHandle.cancel(true)) {
                LOGGER.info("Running client sessions checker cancelled");
            } else {
                LOGGER.warn("Could not cancel the running client sessions checker");
            }
            this.checkerHandle = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        BpcServicesTracker.stopAll(this);
    }

    private Runnable createCheckerRunnable() {
        LOGGER.info("createCheckerRunnable");
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOGGER.info("Check all client sessions: START");
                long sessionCheckStartTime = System.currentTimeMillis();
                try {
                    ClientSessionManager clientSessionManager = ClientSessionsChecker.this.clientSessionManagerTracker.getService();
                    CoreModule coreModule = ClientSessionsChecker.this.getCoreModule();
                    IdentityProvider identityProvider = coreModule.getIdentityProvider();
                    if (identityProvider == null) {
                        LOGGER.warn("Could not check the client sessions without an identity provider!");
                        return;
                    }
                    if (clientSessionManager == null) {
                        LOGGER.warn("Could not check the client sessions without the client session manager!");
                        return;
                    }
                    long sessionCheckIntervalInSeconds = ClientSessionsChecker.this.getSessionCheckIntervalInSeconds(coreModule);
                    LOGGER.debug("sessionCheckIntervalInSeconds = {}", (Object)sessionCheckIntervalInSeconds);
                    int inactiveSessionTimeoutInMinutes = ClientSessionsChecker.this.getInactiveSessionTimeoutMinutes(coreModule);
                    LOGGER.debug("inactiveSessionTimeoutInMinutes = {}", (Object)inactiveSessionTimeoutInMinutes);
                    for (ClientSession clientSession : clientSessionManager.getAllSessions()) {
                        String sessionId = clientSession.getSessionId();
                        UserSession userSession = clientSession.getUserSession();
                        if (userSession != null) {
                            if (inactiveSessionTimeoutInMinutes > 0 && clientSession.isInactiveSinceMinutes(inactiveSessionTimeoutInMinutes)) {
                                LOGGER.warn("Inactivity check: User session without websocket sessions since {} minutes ... removing session", (Object)inactiveSessionTimeoutInMinutes);
                                UserAuditLog.warning(userSession, "logout", "Inactivity logout");
                                clientSessionManager.removeSession(sessionId, true, identityProvider);
                            }
                            UserSession us = null;
                            if (identityProvider.isOwner(userSession)) {
                                try {
                                    us = identityProvider.checkSession(userSession, sessionCheckIntervalInSeconds);
                                }
                                catch (IdentityProviderException ex) {
                                    LOGGER.warn(ex.getMessage(), (Throwable)ex);
                                }
                            }
                            if (us != null && !us.getExpirationDate().before(new Date())) continue;
                            LOGGER.warn("IdentityProvider check: No user session or expired date ... removing session");
                            clientSessionManager.removeSession(sessionId, true, identityProvider);
                            continue;
                        }
                        LOGGER.warn("There is a client session without a user session. That should not be possible and gets removed.");
                        clientSessionManager.removeSession(sessionId, true, identityProvider);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to check for expired client sessions.", (Throwable)ex);
                }
                finally {
                    LOGGER.info("Check all client sessions: STOP ({} ms)", (Object)(System.currentTimeMillis() - sessionCheckStartTime));
                }
            }
        };
    }
}

