/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.core.license.LicenseService;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class ClientSessionsMetricsCollector
extends Collector {
    private static final Logger LOGGER = LogManager.getLogger(ClientSessionsMetricsCollector.class);
    private final BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;
    private final BpcServicesTracker<LicenseService> licenseServiceTracker;

    public ClientSessionsMetricsCollector(BundleContext bundleContext) {
        this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(bundleContext, ClientSessionManager.class);
        this.licenseServiceTracker = new BpcServicesTracker<LicenseService>(bundleContext, LicenseService.class);
    }

    public void unregister() {
        LOGGER.info("unregister");
        CollectorRegistry.defaultRegistry.unregister((Collector)this);
        BpcServicesTracker.stopAll((Object)this);
    }

    public List<Collector.MetricFamilySamples> collect() {
        LOGGER.info("collect");
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        try {
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_user_sessions_total", "Number of active user sessions", (double)this.clientSessionManagerTracker.getService().getSessionCount()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_user_sessions_limit", "Concurrent user sessions limit", (double)this.licenseServiceTracker.getService().getConcurrentUserLimit().intValue()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_websocket_connections_total", "Number of open websocket connections", (double)this.clientSessionManagerTracker.getService().getOpenWebsocketConnectionsCount()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mfs;
    }
}

