/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.core.apikey.APIKeySession;
import de.virtimo.bpc.core.auth.CsrfTokenService;
import de.virtimo.bpc.util.UriQueryUtil;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class CsrfTokenServiceImpl
implements CsrfTokenService,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(CsrfTokenServiceImpl.class);
    private final BundleContext bundleContext;

    public CsrfTokenServiceImpl(BundleContext bundleContext) {
        LOGGER.info("IpPinningServiceImpl bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
    }

    @Override
    public boolean isValidRequest(HttpServletRequest httpServletRequest, UserSession userSession) {
        if (userSession instanceof APIKeySession) {
            LOGGER.debug("API key session - skip CSRF check");
            return true;
        }
        if ("GET".equalsIgnoreCase(httpServletRequest.getMethod())) {
            LOGGER.debug("GET Request - skip CSRF check");
            return true;
        }
        Map<String, List<String>> principals = userSession.getPrincipals();
        if (principals != null && principals.containsKey("X-Csrf-Token")) {
            List<String> csrfTokenListSession = principals.get("X-Csrf-Token");
            String csrfTokenRequest = httpServletRequest.getHeader("X-Csrf-Token");
            if (csrfTokenRequest == null) {
                String query = httpServletRequest.getQueryString();
                csrfTokenRequest = UriQueryUtil.getQueryParams(query).get("X-Csrf-Token");
            }
            if (csrfTokenRequest != null && csrfTokenListSession.contains(csrfTokenRequest)) {
                LOGGER.debug("CSRF Token found and matching usersession");
            } else {
                return false;
            }
        }
        return true;
    }
}

