/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ConnectionTestException;
import de.virtimo.bpc.api.ConnectionTester;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import de.virtimo.bpc.core.auth.keycloak.KeycloakIdentityProvider;
import de.virtimo.bpc.core.auth.oidc.OidcIdentityProvider;
import de.virtimo.bpc.util.MapUtil;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class IdentityProviderConnectionTester
implements ConnectionTester {
    private static final Logger LOGGER = LogManager.getLogger(IdentityProviderConnectionTester.class);
    private final BundleContext bundleContext;

    public IdentityProviderConnectionTester(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public void destroy() {
        LOGGER.info("destroy");
    }

    @Override
    public boolean canBeUsedToPerformConnectionTest(ModuleInstance moduleInstance) {
        LOGGER.info("canBeUsedToPerformConnectionTest moduleInstance=...");
        return moduleInstance != null && "backendconnection".equalsIgnoreCase(moduleInstance.getParentModule().getModuleId()) && "identity_provider".equalsIgnoreCase(moduleInstance.getInstanceType());
    }

    @Override
    public void performConnectionTest(ModuleInstance moduleInstance, Map<String, Object> testData) throws ConnectionTestException {
        block7: {
            LOGGER.info("performConnectionTest moduleInstance=..., testData=...");
            try {
                IdentityProviderConfiguration idpConfiguration = new IdentityProviderConfiguration(moduleInstance.getConfiguration());
                String idpName = idpConfiguration.getIdentityProviderName();
                if ("karaf".equalsIgnoreCase(idpName)) {
                    this.performKarafConnectionTest(idpConfiguration, testData);
                    break block7;
                }
                if ("jdbc".equalsIgnoreCase(idpName)) {
                    this.performJdbcConnectionTest(idpConfiguration, testData);
                    break block7;
                }
                if ("oidc".equalsIgnoreCase(idpName)) {
                    this.performOidcConnectionTest(idpConfiguration, testData);
                    break block7;
                }
                if ("keycloak".equalsIgnoreCase(idpName)) {
                    this.performKeycloakConnectionTest(idpConfiguration, testData);
                    break block7;
                }
                throw new ConnectionTestException("Invalid identity provider name: ${idpName}", MapUtil.mapOf("idpName", idpName));
            }
            catch (ConnectionTestException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ConnectionTestException(ex);
            }
        }
    }

    private void performKarafConnectionTest(IdentityProviderConfiguration idpConfiguration, Map<String, Object> testData) throws ConnectionTestException {
        LOGGER.info("performKarafConnectionTest idpConfiguration=..., testData=...");
    }

    private void performJdbcConnectionTest(IdentityProviderConfiguration idpConfiguration, Map<String, Object> testData) throws ConnectionTestException {
        LOGGER.info("performJdbcConnectionTest idpConfiguration=..., testData=...");
        try (BpcServicesTracker<DatabaseManager> databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(this.bundleContext, DatabaseManager.class);){
            DatabaseManager databaseManager = databaseManagerTracker.getService();
            String dataSourceName = idpConfiguration.getJdbcDatasource();
            databaseManager.performConnectionTest(dataSourceName);
        }
        catch (ConnectionTestException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConnectionTestException(ex);
        }
    }

    private void performOidcConnectionTest(IdentityProviderConfiguration idpConfiguration, Map<String, Object> testData) throws ConnectionTestException {
        LOGGER.info("performOidcConnectionTest idpConfiguration=..., testData=...");
        try {
            OidcIdentityProvider oidcIdP = new OidcIdentityProvider(this.bundleContext, idpConfiguration, idpConfiguration.getSessionExpirationInMinutes());
            oidcIdP.performConnectionTest();
        }
        catch (ConnectionTestException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConnectionTestException(ex);
        }
    }

    private void performKeycloakConnectionTest(IdentityProviderConfiguration idpConfiguration, Map<String, Object> testData) throws ConnectionTestException {
        LOGGER.info("performKeycloakConnectionTest idpConfiguration=..., testData=...");
        try {
            KeycloakIdentityProvider keycloakIdP = new KeycloakIdentityProvider(this.bundleContext, idpConfiguration, idpConfiguration.getSessionExpirationInMinutes());
            keycloakIdP.performConnectionTest();
        }
        catch (ConnectionTestException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConnectionTestException(ex);
        }
    }
}

