/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.apikey.APIKeySession;
import de.virtimo.bpc.core.auth.IpPinningService;
import de.virtimo.bpc.core.auth.UserIdentification;
import de.virtimo.bpc.core.auth.oidc.OidcJwtSession;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class IpPinningServiceImpl
implements IpPinningService,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(IpPinningServiceImpl.class);
    public static final String USER_IDENTIFICATION_OBJECT_KEY = "userIdentificationObject";
    private final BundleContext bundleContext;
    private final BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;

    public IpPinningServiceImpl(BundleContext bundleContext) {
        LOGGER.info("IpPinningServiceImpl bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(bundleContext, CoreBundleConfiguration.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public boolean isValidRequest(HttpServletRequest httpServletRequest, UserSession userSession) {
        UserIdentification userIdentificationOfUserSession;
        if (userSession instanceof APIKeySession || userSession instanceof OidcJwtSession) {
            return true;
        }
        if (!this.isIpPinningEnabled()) {
            return true;
        }
        UserIdentification userIdentificationOfServletRequest = new UserIdentification(httpServletRequest, this.getHttpHeaderNameOfIpPinningCheck());
        boolean valid = userIdentificationOfServletRequest.equals(userIdentificationOfUserSession = (UserIdentification)userSession.getSensitiveCustomData().get(USER_IDENTIFICATION_OBJECT_KEY));
        if (!valid) {
            LOGGER.warn("IP-Pinning mismatch found! User identification from user session: {} and from servlet request: {}", (Object)userIdentificationOfUserSession, (Object)userIdentificationOfServletRequest);
        }
        return valid;
    }

    @Override
    public boolean isIpPinningEnabled() {
        try {
            return this.coreBundleConfigurationTracker.getService().isIpPinningCheckEnabled();
        }
        catch (ServiceNotFoundException ex) {
            LOGGER.error("Failed to get the info if IP pinning is enabled.", (Throwable)ex);
            return false;
        }
    }

    private String getHttpHeaderNameOfIpPinningCheck() {
        try {
            return this.coreBundleConfigurationTracker.getService().getIpPinningCheckHttpHeaderName();
        }
        catch (ServiceNotFoundException ex) {
            LOGGER.error("Failed to get the http header name of the IP pinning check.", (Throwable)ex);
            return "X-Forwarded-For";
        }
    }
}

