/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.auth.idp.PasswordValidator;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import de.virtimo.bpc.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PasswordValidatorImpl
implements PasswordValidator {
    private static final Logger LOGGER = LogManager.getLogger(PasswordValidatorImpl.class);
    private final String passwordPattern;

    public PasswordValidatorImpl(String passwordPattern) {
        this.passwordPattern = passwordPattern;
    }

    public PasswordValidatorImpl(IdentityProviderConfiguration idpConfiguration) {
        this.passwordPattern = idpConfiguration == null ? null : idpConfiguration.getPasswordValidationRegExp();
    }

    @Override
    public boolean isValid(String password) {
        LOGGER.info("isValid password=...");
        if (StringUtil.isNullOrEmpty(password)) {
            return false;
        }
        if (!StringUtil.isNullOrEmpty(this.passwordPattern)) {
            LOGGER.info("Using the password pattern: {}", (Object)this.passwordPattern);
            return password.matches(this.passwordPattern);
        }
        LOGGER.info("No password pattern set.");
        return true;
    }
}

