/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.jaas;

import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Right;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.api.auth.User;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.auth.idp.IdentityProvider;
import de.virtimo.bpc.api.auth.idp.UserSessionRequest;
import de.virtimo.bpc.api.auth.jaas.BpcCallbackHandler;
import de.virtimo.bpc.api.exception.BackingEngineNotFoundException;
import de.virtimo.bpc.api.exception.IdentityProviderException;
import de.virtimo.bpc.api.identityManagement.IdentityManager;
import de.virtimo.bpc.api.identityManagement.IdentityManagerException;
import de.virtimo.bpc.api.identityManagement.IdentityManagerUnsupportedOperationException;
import de.virtimo.bpc.core.auth.UnsupportedIdentityProviderOperationsFallbackHandler;
import de.virtimo.bpc.core.auth.idp.HttpUserSessionRequest;
import de.virtimo.bpc.core.auth.idp.IdentityProviderWithUnsupportedOperationsFallbackHandler;
import de.virtimo.bpc.core.auth.jaas.BackingEngineDataConverter;
import de.virtimo.bpc.core.auth.jaas.BpcCallbackHandlerImpl;
import de.virtimo.bpc.core.auth.jaas.JaasSession;
import de.virtimo.bpc.core.auth.jaas.RightPrincipal;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.util.Generic;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.UUIDGenerator;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.BackingEngineFactory;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;
import org.apache.karaf.jaas.modules.properties.PropertiesBackingEngine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class JaasProvider
implements IdentityProvider,
IdentityManager,
IdentityProviderWithUnsupportedOperationsFallbackHandler {
    private static final Logger LOGGER = LogManager.getLogger(JaasProvider.class);
    public static final String KARAF = "karaf";
    public static final String JDBC = "jdbc";
    private final BundleContext bundleContext;
    private final Map<String, UserSession> sessionMap;
    private int sessionExpirationInMinutes;
    private final String loginContextId;
    private UnsupportedIdentityProviderOperationsFallbackHandler unsupportedIdentityProviderOperationsFallbackHandler;
    private final CoreBundleConfiguration coreBundleConfiguration;
    private static final Object BACKING_ENGINE_LOCK = new Object();

    public JaasProvider(BundleContext bundleContext, String loginContextId, int sessionExpirationInMinutes, CoreBundleConfiguration coreBundleConfiguration) {
        LOGGER.info("JaasProvider bundleContext={}, loginContextId={}, sessionExpirationInMinutes={}, coreBundleConfiguration=...", (Object)bundleContext, (Object)loginContextId, (Object)sessionExpirationInMinutes);
        this.bundleContext = bundleContext;
        this.sessionMap = new HashMap<String, UserSession>();
        this.loginContextId = loginContextId;
        this.sessionExpirationInMinutes = sessionExpirationInMinutes;
        this.coreBundleConfiguration = coreBundleConfiguration;
    }

    @Override
    public void destroy() {
        LOGGER.info("destroy");
    }

    public String getLoginContextId() {
        return this.loginContextId;
    }

    @Override
    public UnsupportedIdentityProviderOperationsFallbackHandler getUnsupportedIdentityProviderOperationsFallbackHandler() {
        return this.unsupportedIdentityProviderOperationsFallbackHandler;
    }

    @Override
    public void setUnsupportedIdentityProviderOperationsFallbackHandler(UnsupportedIdentityProviderOperationsFallbackHandler unsupportedIdentityProviderOperationsFallbackHandler) {
        this.unsupportedIdentityProviderOperationsFallbackHandler = unsupportedIdentityProviderOperationsFallbackHandler;
    }

    public void setSessionExpirationInMinutes(int sessionExpirationInMinutes) {
        this.sessionExpirationInMinutes = sessionExpirationInMinutes;
    }

    @Override
    public boolean isOwner(UserSession userSession) {
        return userSession instanceof JaasSession;
    }

    @Override
    public UserSession checkSession(UserSession userSession, long sessionCheckIntervalInSeconds) {
        LOGGER.debug("checkSession userSession=..., sessionCheckIntervalInSeconds={}", (Object)sessionCheckIntervalInSeconds);
        if (userSession == null) {
            return null;
        }
        String sessionId = userSession.getSessionId();
        return this.checkSession(sessionId);
    }

    private UserSession checkSession(String sessionId) {
        long diff;
        LOGGER.debug("checkSession");
        if (sessionId == null) {
            return null;
        }
        UserSession userSession = this.sessionMap.get(sessionId);
        if (userSession != null && (diff = userSession.getExpirationDate().getTime() - new Date().getTime()) <= 0L) {
            LOGGER.debug("session expired");
            this.sessionMap.remove(sessionId);
            userSession = null;
        }
        return userSession;
    }

    @Override
    public UserSession login(String tenant, String username, String password) throws IdentityProviderException {
        LOGGER.debug("login");
        BpcCallbackHandlerImpl cbh = new BpcCallbackHandlerImpl();
        cbh.setPassword(password.toCharArray());
        cbh.setUsername(username);
        cbh.setTenant(tenant);
        return this.login(cbh);
    }

    @Override
    public UserSession login(BpcCallbackHandler bpcCallbackHandler) throws IdentityProviderException {
        LOGGER.debug("login");
        try {
            JaasSession session;
            LoginContext lc = new LoginContext(this.loginContextId, bpcCallbackHandler);
            lc.login();
            if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
                Set<Organisation> userOrganisations = this.unsupportedIdentityProviderOperationsFallbackHandler.getUserOrganisations(bpcCallbackHandler.getUsername());
                for (Organisation organisation : userOrganisations) {
                    lc.getSubject().getPrincipals().add((Principal)new GroupPrincipal(organisation.getName()));
                }
                Set<Role> userRoles = this.unsupportedIdentityProviderOperationsFallbackHandler.getUserRoles(bpcCallbackHandler.getUsername());
                for (Role userRole : userRoles) {
                    lc.getSubject().getPrincipals().add((Principal)new RolePrincipal(userRole.getName()));
                }
                Set<Right> set = this.unsupportedIdentityProviderOperationsFallbackHandler.getUserRights(bpcCallbackHandler.getUsername());
                for (Right userRight : set) {
                    lc.getSubject().getPrincipals().add(new RightPrincipal(userRight.getName()));
                }
            }
            if ((session = new JaasSession(lc, bpcCallbackHandler, this.getBackingEngine(), this.sessionExpirationInMinutes)).hasRole("bpcNoFrontend")) {
                LOGGER.warn("Login denied because user has role bpcNoFrontend");
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_ROLE_CHECK_FAILED, "CORE_ERROR_IDENTITY_PROVIDER_LOGIN_FAILED_USER_HAS_ROLE", MapUtil.mapOf("role", "bpcNoFrontend"));
            }
            this.sessionMap.put(session.getSessionId(), session);
            return session;
        }
        catch (IdentityProviderException ex) {
            throw ex;
        }
        catch (LoginException ex) {
            LOGGER.error("Error login", (Throwable)ex);
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_LOGIN_FAILED, "CORE_ERROR_IDENTITY_PROVIDER_LOGIN_FAILED", ex);
        }
        catch (Exception ex) {
            LOGGER.error("Unexpected error login", (Throwable)ex);
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.UNEXPECTED, "CORE_ERROR_IDENTITY_PROVIDER_LOGIN_FAILED", ex);
        }
    }

    @Override
    public UserSession updateSession(UserSession oldSession, String newTenant) throws IdentityProviderException {
        LOGGER.debug("updateSession");
        if (!(oldSession instanceof JaasSession)) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_JAAS_SESSION_UPDATE_FAILED");
        }
        JaasSession oldJaasSession = (JaasSession)oldSession;
        if (oldJaasSession.getBpcCallbackHandler() == null) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_JAAS_SESSION_UPDATE_FAILED");
        }
        BpcCallbackHandler bpcCallbackHandler = oldJaasSession.getBpcCallbackHandler();
        bpcCallbackHandler.setTenant(newTenant);
        UserSession newSession = this.login(bpcCallbackHandler);
        this.sessionMap.remove(oldSession.getSessionId());
        return newSession;
    }

    @Override
    public void logout(String sessionId) {
        LOGGER.debug("logout");
        UserSession session = this.sessionMap.remove(sessionId);
        if (session != null) {
            session.destroy();
        }
    }

    @Override
    public boolean canUpdateUserPasswords() throws IdentityProviderException {
        LOGGER.info("canUpdateUserPasswords");
        BackingEngine backingEngine = this.getBackingEngine();
        if (backingEngine == null) {
            return false;
        }
        if (backingEngine instanceof PropertiesBackingEngine) {
            return true;
        }
        try {
            boolean checkPasswordMethodExists = backingEngine.getClass().getDeclaredMethod("checkPassword", String.class, String.class) != null;
            boolean updatePasswordMethodExists = backingEngine.getClass().getDeclaredMethod("updatePassword", String.class, String.class) != null;
            return checkPasswordMethodExists && updatePasswordMethodExists;
        }
        catch (NoSuchMethodException | NullPointerException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUserPassword(String userName, String oldPassword, String newPassword) throws IdentityProviderException {
        LOGGER.info("updateUserPassword userName={}, oldPassword=..., newPassword=...", (Object)userName);
        Object object = BACKING_ENGINE_LOCK;
        synchronized (object) {
            try {
                BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
                if (backingEngine instanceof PropertiesBackingEngine) {
                    PropertiesBackingEngine propertiesBackingEngine = (PropertiesBackingEngine)backingEngine;
                    if (!this.checkUserPassword(propertiesBackingEngine, userName, oldPassword, false)) {
                        throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_PASSWORD_DOES_NOT_MATCH");
                    }
                    this.updateUserPassword(propertiesBackingEngine, userName, newPassword);
                } else {
                    Method checkPasswordMethod = backingEngine.getClass().getDeclaredMethod("checkPassword", String.class, String.class);
                    if (checkPasswordMethod.invoke((Object)backingEngine, userName, oldPassword).equals(Boolean.FALSE)) {
                        throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_PASSWORD_DOES_NOT_MATCH");
                    }
                    Method updatePasswordMethod = backingEngine.getClass().getDeclaredMethod("updatePassword", String.class, String.class);
                    updatePasswordMethod.invoke((Object)backingEngine, userName, newPassword);
                }
            }
            catch (IdentityProviderException ex) {
                throw ex;
            }
            catch (UnsupportedOperationException ex) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_UNSUPPORTED_OPERATION, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_PASSWORD_UNSUPPORTED");
            }
            catch (Exception ex) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.UNEXPECTED, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_PASSWORD", ex);
            }
        }
    }

    @Override
    public UserSession requestUserSession(UserSessionRequest userSessionRequest) throws IdentityProviderException {
        LOGGER.debug("requestUserSession");
        if (!(userSessionRequest instanceof HttpUserSessionRequest)) {
            throw new IllegalArgumentException("only support HttpUserSessionRequest");
        }
        HttpUserSessionRequest httpUserSessionRequest = (HttpUserSessionRequest)userSessionRequest;
        String sessionId = httpUserSessionRequest.getCookieValue(this.coreBundleConfiguration.getCookieName());
        UserSession userSession = this.checkSession(sessionId);
        if (userSession == null) {
            String username = httpUserSessionRequest.getFormParam("username");
            String password = httpUserSessionRequest.getFormParam("password");
            if (username != null && password != null) {
                userSession = this.login(Generic.getValueOrDefault(httpUserSessionRequest.getFormParam("tenantname"), ""), username, password);
            }
        }
        return userSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BackingEngine getBackingEngineOfCurrentLoginModule() throws InvalidSyntaxException {
        LOGGER.debug("getBackingEngineOfCurrentLoginModule");
        Collection backingEngineFactoryReferences = this.bundleContext.getServiceReferences(BackingEngineFactory.class, null);
        if (backingEngineFactoryReferences == null) {
            return null;
        }
        Configuration config = AccessController.doPrivileged(new PrivilegedAction<Configuration>(){

            @Override
            public Configuration run() {
                return Configuration.getConfiguration();
            }
        });
        AppConfigurationEntry[] entries = config.getAppConfigurationEntry(this.loginContextId);
        LOGGER.debug("loginContextId: " + this.loginContextId);
        for (AppConfigurationEntry entry : entries) {
            String loginModuleClassName = (String)entry.getOptions().get("org.apache.karaf.jaas.module");
            LOGGER.info("loginModuleClassName = {}", (Object)loginModuleClassName);
            String loginModulePackageName = loginModuleClassName.substring(0, loginModuleClassName.lastIndexOf(46));
            LOGGER.info("loginModulePackageName = {}", (Object)loginModulePackageName);
            Map<String, ?> loginModuleOptions = entry.getOptions();
            LOGGER.info("loginModuleOptions = {}", loginModuleOptions);
            for (ServiceReference backingEngineFactoryReference : backingEngineFactoryReferences) {
                try {
                    BackingEngineFactory backingEngineFactory = (BackingEngineFactory)this.bundleContext.getService(backingEngineFactoryReference);
                    String backingEngineFactoryPackageName = backingEngineFactory.getClass().getPackage().getName();
                    LOGGER.info("backingEngineFactory package = {}", (Object)backingEngineFactoryPackageName);
                    if (!backingEngineFactoryPackageName.equals(loginModulePackageName)) continue;
                    LOGGER.info("backingEngineFactory = {}", (Object)backingEngineFactory);
                    BackingEngine backingEngine = backingEngineFactory.build(loginModuleOptions);
                    return backingEngine;
                }
                finally {
                    this.bundleContext.ungetService(backingEngineFactoryReference);
                }
            }
        }
        return null;
    }

    private BackingEngine getBackingEngine() throws IdentityProviderException {
        LOGGER.debug("getBackingEngine");
        try {
            return this.getBackingEngineOfCurrentLoginModule();
        }
        catch (Exception ex) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_GET_BACKING_ENGINE", ex);
        }
    }

    private BackingEngine getBackingEngineOrThrowExceptionWhenMissing() throws IdentityProviderException, BackingEngineNotFoundException {
        LOGGER.debug("getBackingEngineOrThrowExceptionWhenMissing");
        try {
            BackingEngine result = this.getBackingEngineOfCurrentLoginModule();
            if (result == null) {
                throw new BackingEngineNotFoundException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
            }
            return result;
        }
        catch (Exception ex) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_GET_BACKING_ENGINE", ex);
        }
    }

    @Override
    public User getUser(UserSession requestingUserSession, HttpServletRequest request, String userId) throws IdentityManagerException {
        LOGGER.info("getUser");
        try {
            BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
            if (backingEngine instanceof IdentityManager) {
                IdentityManager identityManager = (IdentityManager)backingEngine;
                return identityManager.getUser(requestingUserSession, request, userId);
            }
            return BackingEngineDataConverter.getUser(backingEngine, userId);
        }
        catch (IdentityManagerUnsupportedOperationException | UnsupportedOperationException ex) {
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_USER_UNSUPPORTED", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_GET_USER", ex);
        }
    }

    @Override
    public List<User> getUsers(UserSession requestingUserSession, HttpServletRequest request) throws IdentityManagerException {
        LOGGER.info("getUsers");
        try {
            BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
            if (backingEngine instanceof IdentityManager) {
                IdentityManager identityManager = (IdentityManager)backingEngine;
                return identityManager.getUsers(requestingUserSession, request);
            }
            return BackingEngineDataConverter.getUsers(backingEngine);
        }
        catch (IdentityManagerUnsupportedOperationException | UnsupportedOperationException ex) {
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_USERS_UNSUPPORTED", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_GET_USERS", ex);
        }
    }

    @Override
    public Set<Organisation> getOrganisations(UserSession requestingUserSession, HttpServletRequest request) throws IdentityManagerException {
        LOGGER.info("getOrganisations");
        try {
            BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
            if (backingEngine instanceof IdentityManager) {
                IdentityManager identityManager = (IdentityManager)backingEngine;
                return identityManager.getOrganisations(requestingUserSession, request);
            }
            return BackingEngineDataConverter.getOrganisations(backingEngine);
        }
        catch (IdentityManagerUnsupportedOperationException | UnsupportedOperationException ex) {
            if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
                return this.unsupportedIdentityProviderOperationsFallbackHandler.getOrganisations();
            }
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_ORGANISATIONS_UNSUPPORTED", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_GET_ORGANISATIONS", ex);
        }
    }

    @Override
    public Set<Role> getRoles(UserSession requestingUserSession, HttpServletRequest request) throws IdentityManagerException {
        LOGGER.info("getRoles");
        try {
            BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
            if (backingEngine instanceof IdentityManager) {
                IdentityManager identityManager = (IdentityManager)backingEngine;
                return identityManager.getRoles(requestingUserSession, request);
            }
            return BackingEngineDataConverter.getRoles(backingEngine);
        }
        catch (IdentityManagerUnsupportedOperationException | UnsupportedOperationException ex) {
            if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
                return this.unsupportedIdentityProviderOperationsFallbackHandler.getRoles();
            }
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_ROLES_UNSUPPORTED", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_GET_ROLES", ex);
        }
    }

    @Override
    public Set<Right> getRights(UserSession requestingUserSession, HttpServletRequest request) throws IdentityManagerException {
        LOGGER.info("getRights");
        try {
            BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
            if (backingEngine instanceof IdentityManager) {
                IdentityManager identityManager = (IdentityManager)backingEngine;
                return identityManager.getRights(requestingUserSession, request);
            }
            throw new UnsupportedOperationException("Get rights is not supported by this identity provider.");
        }
        catch (IdentityManagerUnsupportedOperationException | UnsupportedOperationException ex) {
            if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
                return this.unsupportedIdentityProviderOperationsFallbackHandler.getRights();
            }
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_RIGHTS_UNSUPPORTED", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_GET_RIGHTS", ex);
        }
    }

    @Override
    public Set<Organisation> getUserOrganisations(UserSession requestingUserSession, HttpServletRequest request, String userId) throws IdentityManagerException {
        LOGGER.info("getUserOrganisations requestingUserSession={}, request={}, userId={}", (Object)requestingUserSession, (Object)request, (Object)userId);
        try {
            BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
            if (backingEngine instanceof IdentityManager) {
                IdentityManager identityManager = (IdentityManager)backingEngine;
                return identityManager.getUserOrganisations(requestingUserSession, request, userId);
            }
            return BackingEngineDataConverter.getUserOrganisations(backingEngine, userId, true);
        }
        catch (IdentityManagerUnsupportedOperationException | UnsupportedOperationException ex) {
            if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
                return this.unsupportedIdentityProviderOperationsFallbackHandler.getUserOrganisations(userId);
            }
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_USER_ORGANISATIONS_UNSUPPORTED", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_GET_USER_ORGANISATIONS", ex);
        }
    }

    @Override
    public Set<Role> getUserRoles(UserSession requestingUserSession, HttpServletRequest request, String userId) throws IdentityManagerException {
        LOGGER.info("getUserRoles requestingUserSession={}, request={}, userId={}", (Object)requestingUserSession, (Object)request, (Object)userId);
        try {
            BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
            if (backingEngine instanceof IdentityManager) {
                IdentityManager identityManager = (IdentityManager)backingEngine;
                return identityManager.getUserRoles(requestingUserSession, request, userId);
            }
            return BackingEngineDataConverter.getUserRoles(backingEngine, userId, true);
        }
        catch (IdentityManagerUnsupportedOperationException | UnsupportedOperationException ex) {
            if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
                return this.unsupportedIdentityProviderOperationsFallbackHandler.getUserRoles(userId);
            }
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_USER_ROLES_UNSUPPORTED", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_GET_USER_ROLES", MapUtil.mapOf("user", userId), (Throwable)ex);
        }
    }

    @Override
    public Set<Right> getUserRights(UserSession requestingUserSession, HttpServletRequest request, String userId) throws IdentityManagerException {
        LOGGER.info("getUserRights requestingUserSession={}, request={}, userId={}", (Object)requestingUserSession, (Object)request, (Object)userId);
        try {
            BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
            if (backingEngine instanceof IdentityManager) {
                IdentityManager identityManager = (IdentityManager)backingEngine;
                return identityManager.getUserRights(requestingUserSession, request, userId);
            }
            throw new UnsupportedOperationException("Get user rights is not supported by this identity provider.");
        }
        catch (IdentityManagerUnsupportedOperationException | UnsupportedOperationException ex) {
            if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
                return this.unsupportedIdentityProviderOperationsFallbackHandler.getUserRights(userId);
            }
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_USER_RIGHTS_UNSUPPORTED", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_GET_USER_RIGHTS", MapUtil.mapOf("user", userId), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUser(UserSession requestingUserSession, HttpServletRequest request, String userId, String userPassword) throws IdentityManagerException {
        LOGGER.info("addUser requestingUserSession={}, request={}, userId={}, userPassword={}", (Object)requestingUserSession, (Object)request, (Object)userId, (Object)userPassword);
        Object object = BACKING_ENGINE_LOCK;
        synchronized (object) {
            try {
                BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
                if (backingEngine instanceof IdentityManager) {
                    IdentityManager identityManager = (IdentityManager)backingEngine;
                    identityManager.addUser(requestingUserSession, request, userId, userPassword);
                } else {
                    backingEngine.addUser(userId, userPassword);
                }
            }
            catch (IdentityManagerUnsupportedOperationException | UnsupportedOperationException ex) {
                throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_USER_UNSUPPORTED", (Throwable)ex);
            }
            catch (Exception ex) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_ADD_USER", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUser(UserSession requestingUserSession, HttpServletRequest request, User user, String userPassword) throws IdentityManagerException {
        LOGGER.info("addUser requestingUserSession={}, request={}, user={}, userPassword=...", (Object)requestingUserSession, (Object)request, (Object)user);
        Object object = BACKING_ENGINE_LOCK;
        synchronized (object) {
            try {
                BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
                if (backingEngine instanceof IdentityManager) {
                    IdentityManager identityManager = (IdentityManager)backingEngine;
                    identityManager.addUser(requestingUserSession, request, user, userPassword);
                } else {
                    backingEngine.addUser(user.getId(), userPassword);
                }
            }
            catch (IdentityManagerUnsupportedOperationException | UnsupportedOperationException ex) {
                throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_USER_UNSUPPORTED", (Throwable)ex);
            }
            catch (Exception ex) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_ADD_USER", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOrganisation(UserSession requestingUserSession, HttpServletRequest request, String userId, String orgName) throws IdentityManagerException {
        LOGGER.info("addOrganisation requestingUserSession={}, request={}, userId={}, orgName={}", (Object)requestingUserSession, (Object)request, (Object)userId, (Object)orgName);
        Object object = BACKING_ENGINE_LOCK;
        synchronized (object) {
            try {
                BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
                if (backingEngine instanceof IdentityManager) {
                    IdentityManager identityManager = (IdentityManager)backingEngine;
                    identityManager.addOrganisation(requestingUserSession, request, userId, orgName);
                } else {
                    backingEngine.addGroup(userId, orgName);
                }
            }
            catch (IdentityManagerUnsupportedOperationException | UnsupportedOperationException ex) {
                if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
                    try {
                        this.unsupportedIdentityProviderOperationsFallbackHandler.addOrganisation(userId, orgName);
                    }
                    catch (Exception e) {
                        throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_ADD_USER_TO_ORGANISATION", e);
                    }
                }
                throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_USER_TO_ORGANISATION_UNSUPPORTED", (Throwable)ex);
            }
            catch (Exception ex) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_ADD_USER_TO_ORGANISATION", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRight(UserSession requestingUserSession, HttpServletRequest request, String userId, String rightName) throws IdentityManagerException {
        LOGGER.info("addRight requestingUserSession={}, request={}, userId={}, rightName={}", (Object)requestingUserSession, (Object)request, (Object)userId, (Object)rightName);
        Object object = BACKING_ENGINE_LOCK;
        synchronized (object) {
            try {
                BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
                if (!(backingEngine instanceof IdentityManager)) {
                    throw new UnsupportedOperationException("Add right to user is not supported by this identity provider.");
                }
                IdentityManager identityManager = (IdentityManager)backingEngine;
                identityManager.addRight(requestingUserSession, request, userId, rightName);
            }
            catch (IdentityManagerUnsupportedOperationException | UnsupportedOperationException ex) {
                if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
                    try {
                        this.unsupportedIdentityProviderOperationsFallbackHandler.addRight(userId, rightName);
                    }
                    catch (Exception e) {
                        throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_ADD_RIGHT_TO_USER", e);
                    }
                }
                throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_RIGHT_TO_USER_UNSUPPORTED", (Throwable)ex);
            }
            catch (Exception ex) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_ADD_RIGHT_TO_USER", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRole(UserSession requestingUserSession, HttpServletRequest request, String userId, String roleName) throws IdentityManagerException {
        LOGGER.info("addRole requestingUserSession={}, request={}, userId={}, roleName={}", (Object)requestingUserSession, (Object)request, (Object)userId, (Object)roleName);
        Object object = BACKING_ENGINE_LOCK;
        synchronized (object) {
            try {
                BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
                if (backingEngine instanceof IdentityManager) {
                    IdentityManager identityManager = (IdentityManager)backingEngine;
                    identityManager.addRole(requestingUserSession, request, userId, roleName);
                } else {
                    backingEngine.addRole(userId, roleName);
                }
            }
            catch (IdentityManagerUnsupportedOperationException | UnsupportedOperationException ex) {
                if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
                    try {
                        this.unsupportedIdentityProviderOperationsFallbackHandler.addRole(userId, roleName);
                    }
                    catch (Exception e) {
                        throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_ADD_ROLE_TO_USER", e);
                    }
                }
                throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_ROLE_TO_USER_UNSUPPORTED", (Throwable)ex);
            }
            catch (Exception ex) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_ADD_ROLE_TO_USER", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOrganisationRole(UserSession requestingUserSession, HttpServletRequest request, String orgName, String roleName) throws IdentityManagerException {
        LOGGER.info("addOrganisationRole requestingUserSession={}, request={}, orgName={}, roleName={}", (Object)requestingUserSession, (Object)request, (Object)orgName, (Object)roleName);
        Object object = BACKING_ENGINE_LOCK;
        synchronized (object) {
            try {
                BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
                if (backingEngine instanceof IdentityManager) {
                    IdentityManager identityManager = (IdentityManager)backingEngine;
                    identityManager.addOrganisationRole(requestingUserSession, request, orgName, roleName);
                } else {
                    backingEngine.addGroupRole(orgName, roleName);
                }
            }
            catch (IdentityManagerUnsupportedOperationException | UnsupportedOperationException ex) {
                throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_ROLE_TO_ORGANISATION_UNSUPPORTED", (Throwable)ex);
            }
            catch (Exception ex) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_ADD_ROLE_TO_ORGANISATION", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteUser(UserSession requestingUserSession, HttpServletRequest request, String userId) throws IdentityManagerException {
        LOGGER.info("deleteUser requestingUserSession={}, request={}, userId={}", (Object)requestingUserSession, (Object)request, (Object)userId);
        Object object = BACKING_ENGINE_LOCK;
        synchronized (object) {
            try {
                BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
                if (backingEngine instanceof IdentityManager) {
                    IdentityManager identityManager = (IdentityManager)backingEngine;
                    identityManager.deleteUser(requestingUserSession, request, userId);
                } else {
                    backingEngine.deleteUser(userId);
                }
            }
            catch (IdentityManagerUnsupportedOperationException | UnsupportedOperationException ex) {
                throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_USER_UNSUPPORTED", (Throwable)ex);
            }
            catch (Exception ex) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_DELETE_USER", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteOrganisation(UserSession requestingUserSession, HttpServletRequest request, String userId, String orgName) throws IdentityManagerException {
        LOGGER.info("deleteOrganisation requestingUserSession={}, request={}, userId={}, orgName={}", (Object)requestingUserSession, (Object)request, (Object)userId, (Object)orgName);
        Object object = BACKING_ENGINE_LOCK;
        synchronized (object) {
            try {
                BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
                if (backingEngine instanceof IdentityManager) {
                    IdentityManager identityManager = (IdentityManager)backingEngine;
                    identityManager.deleteOrganisation(requestingUserSession, request, userId, orgName);
                } else {
                    backingEngine.deleteGroup(userId, orgName);
                }
            }
            catch (IdentityManagerUnsupportedOperationException | UnsupportedOperationException ex) {
                if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
                    try {
                        this.unsupportedIdentityProviderOperationsFallbackHandler.deleteOrganisation(userId, orgName);
                    }
                    catch (Exception e) {
                        throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_DELETE_USER_FROM_ORGANISATION", e);
                    }
                }
                throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_USER_FROM_ORGANISATION_UNSUPPORTED", (Throwable)ex);
            }
            catch (Exception ex) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_DELETE_USER_FROM_ORGANISATION", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRole(UserSession requestingUserSession, HttpServletRequest request, String userId, String roleName) throws IdentityManagerException {
        LOGGER.info("deleteRole requestingUserSession={}, request={}, userId={}, roleName={}", (Object)requestingUserSession, (Object)request, (Object)userId, (Object)roleName);
        Object object = BACKING_ENGINE_LOCK;
        synchronized (object) {
            try {
                BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
                if (backingEngine instanceof IdentityManager) {
                    IdentityManager identityManager = (IdentityManager)backingEngine;
                    identityManager.deleteRole(requestingUserSession, request, userId, roleName);
                } else {
                    backingEngine.deleteRole(userId, roleName);
                }
            }
            catch (IdentityManagerUnsupportedOperationException | UnsupportedOperationException ex) {
                if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
                    try {
                        this.unsupportedIdentityProviderOperationsFallbackHandler.deleteRole(userId, roleName);
                    }
                    catch (Exception e) {
                        throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_DELETE_ROLE_FROM_USER", e);
                    }
                }
                throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_ROLE_FROM_USER_UNSUPPORTED", (Throwable)ex);
            }
            catch (Exception ex) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_DELETE_ROLE_FROM_USER", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteOrganisationRole(UserSession requestingUserSession, HttpServletRequest request, String orgName, String roleName) throws IdentityManagerException {
        LOGGER.info("deleteOrganisationRole requestingUserSession={}, request={}, orgName={}, roleName={}", (Object)requestingUserSession, (Object)request, (Object)orgName, (Object)roleName);
        Object object = BACKING_ENGINE_LOCK;
        synchronized (object) {
            try {
                BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
                if (backingEngine instanceof IdentityManager) {
                    IdentityManager identityManager = (IdentityManager)backingEngine;
                    identityManager.deleteOrganisationRole(requestingUserSession, request, orgName, roleName);
                } else {
                    backingEngine.deleteGroupRole(orgName, roleName);
                }
            }
            catch (IdentityManagerUnsupportedOperationException | UnsupportedOperationException ex) {
                throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_ROLE_FROM_ORGANISATION_UNSUPPORTED", (Throwable)ex);
            }
            catch (Exception ex) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_DELETE_ROLE_FROM_ORGANISATION", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRight(UserSession requestingUserSession, HttpServletRequest request, String userId, String rightName) throws IdentityManagerException {
        LOGGER.info("deleteRight requestingUserSession={}, request={}, userId={}, rightName={}", (Object)requestingUserSession, (Object)request, (Object)userId, (Object)rightName);
        Object object = BACKING_ENGINE_LOCK;
        synchronized (object) {
            try {
                BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
                if (!(backingEngine instanceof IdentityManager)) {
                    throw new UnsupportedOperationException("Deleting a user right is not supported by this identity provider.");
                }
                IdentityManager identityManager = (IdentityManager)backingEngine;
                identityManager.deleteRight(requestingUserSession, request, userId, rightName);
            }
            catch (IdentityManagerUnsupportedOperationException | UnsupportedOperationException ex) {
                if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
                    try {
                        this.unsupportedIdentityProviderOperationsFallbackHandler.deleteRight(userId, rightName);
                    }
                    catch (Exception e) {
                        throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_DELETE_RIGHT_FROM_USER", e);
                    }
                }
                throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_RIGHT_FROM_USER_UNSUPPORTED", (Throwable)ex);
            }
            catch (Exception ex) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_DELETE_RIGHT_FROM_USER", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUser(UserSession requestingUserSession, HttpServletRequest request, User user) throws IdentityManagerException {
        LOGGER.info("updateUser requestingUserSession={}, request={}, user={}", (Object)requestingUserSession, (Object)request, (Object)user);
        Object object = BACKING_ENGINE_LOCK;
        synchronized (object) {
            try {
                BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
                if (!(backingEngine instanceof IdentityManager)) {
                    throw new UnsupportedOperationException("Updating a user is not supported by this identity provider.");
                }
                IdentityManager identityManager = (IdentityManager)backingEngine;
                identityManager.updateUser(requestingUserSession, request, user);
            }
            catch (IdentityManagerUnsupportedOperationException | UnsupportedOperationException ex) {
                throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_UNSUPPORTED", (Throwable)ex);
            }
            catch (Exception ex) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUserPassword(UserSession requestingUserSession, HttpServletRequest request, String userId, String userPassword) throws IdentityManagerException {
        LOGGER.info("updateUserPassword requestingUserSession={}, request={}, userId={}, userPassword=...", (Object)requestingUserSession, (Object)request, (Object)userId);
        Object object = BACKING_ENGINE_LOCK;
        synchronized (object) {
            block8: {
                try {
                    BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
                    if (backingEngine instanceof IdentityManager) {
                        IdentityManager identityManager = (IdentityManager)backingEngine;
                        identityManager.updateUserPassword(requestingUserSession, request, userId, userPassword);
                        break block8;
                    }
                    if (backingEngine instanceof PropertiesBackingEngine) {
                        PropertiesBackingEngine propertiesBackingEngine = (PropertiesBackingEngine)backingEngine;
                        this.updateUserPassword(propertiesBackingEngine, userId, userPassword);
                        break block8;
                    }
                    throw new UnsupportedOperationException("Updating a user password is not supported by this identity provider.");
                }
                catch (IdentityManagerUnsupportedOperationException | UnsupportedOperationException ex) {
                    throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_PASSWORD_UNSUPPORTED", (Throwable)ex);
                }
                catch (Exception ex) {
                    throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_PASSWORD", ex);
                }
            }
        }
    }

    private void updateUserPassword(PropertiesBackingEngine propertiesBackingEngine, String userName, String password) {
        LOGGER.info("updateUserPassword propertiesBackingEngine=..., userName={}, password=...", (Object)userName);
        propertiesBackingEngine.addUser(userName, password);
    }

    @Override
    public boolean checkUserPassword(UserSession requestingUserSession, HttpServletRequest request, String userId, String userPassword) throws IdentityManagerException {
        LOGGER.info("checkUserPassword requestingUserSession={}, request={}, userId={}, userPassword=...", (Object)requestingUserSession, (Object)request, (Object)userId);
        try {
            BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
            if (backingEngine instanceof IdentityManager) {
                IdentityManager identityManager = (IdentityManager)backingEngine;
                return identityManager.checkUserPassword(requestingUserSession, request, userId, userPassword);
            }
            if (backingEngine instanceof PropertiesBackingEngine) {
                PropertiesBackingEngine propertiesBackingEngine = (PropertiesBackingEngine)backingEngine;
                return this.checkUserPassword(propertiesBackingEngine, userId, userPassword, false);
            }
            throw new UnsupportedOperationException("Checking the user password is not supported by this identity provider.");
        }
        catch (IdentityManagerUnsupportedOperationException | UnsupportedOperationException ex) {
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_CHECK_USER_PASSWORD_UNSUPPORTED", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_CHECK_USER_PASSWORD", ex);
        }
    }

    private boolean checkUserPassword(PropertiesBackingEngine propertiesBackingEngine, String userName, String passwordToCheck, boolean additionalPlainTextCheck) throws NoSuchFieldException, IllegalAccessException {
        LOGGER.info("checkUserPassword propertiesBackingEngine=..., userName={}, passwordToCheck=..., additionalPlainTextCheck={}", (Object)userName, (Object)additionalPlainTextCheck);
        Field privateEncryptionSupportField = PropertiesBackingEngine.class.getDeclaredField("encryptionSupport");
        privateEncryptionSupportField.setAccessible(true);
        EncryptionSupport encryptionSupport = (EncryptionSupport)privateEncryptionSupportField.get(propertiesBackingEngine);
        Field privatePropertiesField = PropertiesBackingEngine.class.getDeclaredField("users");
        privatePropertiesField.setAccessible(true);
        Object usersObject = privatePropertiesField.get(propertiesBackingEngine);
        String userInfos = (String)((Map)usersObject).get(userName);
        if (userInfos != null) {
            String[] infos = userInfos.split(",");
            String encCurrentPassword = infos[0];
            if (additionalPlainTextCheck && encCurrentPassword != null && encCurrentPassword.equals(passwordToCheck)) {
                return true;
            }
            return encryptionSupport.checkPassword(passwordToCheck, encCurrentPassword);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceDefaultPasswordsOfShippedUsers(String defaultPassword, List<String> shippedUsers) {
        LOGGER.info("replaceDefaultPasswordsOfShippedUsers defaultPassword={}, shippedUsers={}", (Object)defaultPassword, shippedUsers);
        Object object = BACKING_ENGINE_LOCK;
        synchronized (object) {
            try {
                BackingEngine backingEngine = this.getBackingEngineOrThrowExceptionWhenMissing();
                if (backingEngine instanceof PropertiesBackingEngine) {
                    PropertiesBackingEngine propertiesBackingEngine = (PropertiesBackingEngine)backingEngine;
                    for (String shippedUser : shippedUsers) {
                        if (!this.checkUserPassword(propertiesBackingEngine, shippedUser, defaultPassword, true)) continue;
                        this.updateUserPassword(propertiesBackingEngine, shippedUser, UUIDGenerator.randomUUID());
                    }
                }
            }
            catch (BackingEngineNotFoundException | IdentityProviderException ex) {
                LOGGER.info("Failed to get the backing engine of the JAAS provider.");
            }
            catch (IllegalAccessException | NoSuchFieldException ex) {
                LOGGER.warn("Hey BPC devs, it seems that a Karaf implementation has been changed and your code must be updated.", (Throwable)ex);
            }
        }
    }
}

