/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.oidc;

import com.nimbusds.jwt.JWTClaimsSet;
import de.virtimo.bpc.core.auth.AbstractUserSession;
import de.virtimo.bpc.core.auth.OrganisationFactory;
import de.virtimo.bpc.core.auth.RightFactory;
import de.virtimo.bpc.core.auth.RolesFactory;
import de.virtimo.bpc.core.auth.oidc.OidcIdentityProvider;
import java.text.ParseException;
import java.util.Date;
import java.util.Set;

public class OidcJwtSession
extends AbstractUserSession {
    private final String sessionId;
    private final String firstName;
    private final String lastName;
    private final String email;
    private final String loginName;
    private final Date expirationDate;

    public OidcJwtSession(JWTClaimsSet claims, String claimNameRoles, String claimNameOrganisations, String claimNameRights) {
        this.sessionId = this.tryGetClaimAsString(claims, "sid");
        this.firstName = this.tryGetClaimAsString(claims, "given_name");
        this.lastName = this.tryGetClaimAsString(claims, "family_name");
        this.email = this.tryGetClaimAsString(claims, "email");
        this.loginName = this.tryGetClaimAsString(claims, "preferred_username");
        this.expirationDate = claims.getExpirationTime();
        Set<String> claimRoles = OidcIdentityProvider.extractFromClaim(claimNameRoles, null, Set.of(claims));
        this.roles.add(RolesFactory.getBpcUserRole());
        this.roles.addAll(RolesFactory.getRoles(claimRoles));
        Set<String> claimOrganisations = OidcIdentityProvider.extractFromClaim(claimNameOrganisations, null, Set.of(claims));
        this.organisations.addAll(OrganisationFactory.getOrganisations(claimOrganisations));
        Set<String> claimRights = OidcIdentityProvider.extractFromClaim(claimNameRights, null, Set.of(claims));
        this.rights.addAll(RightFactory.getRights(claimRights));
    }

    private String tryGetClaimAsString(JWTClaimsSet claims, String claimName) {
        try {
            return claims.getClaimAsString(claimName);
        }
        catch (ParseException e) {
            return "";
        }
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getLoginName() {
        return this.loginName;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public Date getExpirationDate() {
        return this.expirationDate;
    }
}

