/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.oidc;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.JWKSourceBuilder;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import com.nimbusds.jwt.proc.JWTProcessor;
import com.nimbusds.oauth2.sdk.TokenIntrospectionSuccessResponse;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.exception.IdentityProviderException;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import de.virtimo.bpc.core.auth.oidc.OidcJwtSession;
import de.virtimo.bpc.core.auth.oidc.OidcProviderMetadata;
import de.virtimo.bpc.core.auth.oidc.OidcTokenIntrospectionClient;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.util.StringUtil;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OidcJwtVerifier {
    private static final Logger LOGGER = LogManager.getLogger(OidcJwtVerifier.class);
    private final Map<String, JWTProcessor<SecurityContext>> jwtProcessors;
    private final Map<String, OidcTokenIntrospectionClient> introspectionClients;
    private final String DISCOVERY_CONFIG_SUFFIX = "/.well-known/openid-configuration";
    private final String AUTHENTICATION_BEARER_PREFIX = "Bearer ";
    private final String claimNameRoles;
    private final String claimNameOrganisations;
    private final String claimNameRights;
    private final boolean verifyTokenAtIdp;

    public OidcJwtVerifier(IdentityProviderConfiguration providerConfiguration, OidcProviderMetadata providerMetadata, String claimNameRoles, String claimNameOrganisations, String claimNameRights, boolean verifyTokenAtIdp) throws Exception {
        this.claimNameRoles = claimNameRoles;
        this.claimNameOrganisations = claimNameOrganisations;
        this.claimNameRights = claimNameRights;
        this.verifyTokenAtIdp = verifyTokenAtIdp;
        List<URI> discoveryURIs = providerMetadata.getAllOidcDiscoveryURIs();
        this.jwtProcessors = new HashMap<String, JWTProcessor<SecurityContext>>();
        this.introspectionClients = new HashMap<String, OidcTokenIntrospectionClient>();
        for (URI discoveryURI : discoveryURIs) {
            String discoveryURIstr = discoveryURI.toString();
            if (!discoveryURIstr.endsWith("/.well-known/openid-configuration")) {
                throw new Exception("Bad Discovery URI");
            }
            String issuerName = discoveryURIstr.substring(0, discoveryURIstr.length() - "/.well-known/openid-configuration".length());
            Issuer issuer = Issuer.parse((String)issuerName);
            OIDCProviderMetadata oidcMetadata = OIDCProviderMetadata.resolve((Issuer)issuer);
            URI jwksUri = oidcMetadata.getJWKSetURI();
            if (jwksUri == null) {
                throw new IllegalStateException("OIDC provider does not expose a JWKS URI");
            }
            JWKSource jwkSource = JWKSourceBuilder.create((URL)jwksUri.toURL()).build();
            JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(JWSAlgorithm.RS256, jwkSource);
            DefaultJWTProcessor processor = new DefaultJWTProcessor();
            processor.setJWSKeySelector((JWSKeySelector)keySelector);
            processor.setJWTClaimsSetVerifier((JWTClaimsSetVerifier)new DefaultJWTClaimsVerifier(new JWTClaimsSet.Builder().issuer(issuerName).build(), Set.of("sub", "exp", "iat")));
            this.jwtProcessors.put(issuerName, (JWTProcessor<SecurityContext>)processor);
            if (!verifyTokenAtIdp) continue;
            OidcTokenIntrospectionClient introspectionClient = new OidcTokenIntrospectionClient(providerConfiguration, oidcMetadata);
            this.introspectionClients.put(issuerName, introspectionClient);
        }
    }

    public OidcJwtSession createSessionFromBearerToken(String jwt) throws IdentityProviderException {
        String issuer;
        SignedJWT signedJWT;
        LOGGER.info("createSessionFromBearerToken jwt=...");
        if (StringUtil.isNullOrEmpty(jwt)) {
            return null;
        }
        if (jwt.startsWith("Bearer ")) {
            jwt = jwt.substring("Bearer ".length());
        }
        try {
            signedJWT = SignedJWT.parse((String)jwt);
            issuer = signedJWT.getJWTClaimsSet().getIssuer();
        }
        catch (ParseException e) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_FORBIDDEN, "Failed to parse JWT", e);
        }
        JWTProcessor<SecurityContext> jwtProcessor = this.jwtProcessors.get(issuer);
        if (jwtProcessor == null) {
            LOGGER.warn("No JWT processor for issuer={} found. Returning no session.", (Object)issuer);
            return null;
        }
        try {
            OidcTokenIntrospectionClient introspectionClient;
            TokenIntrospectionSuccessResponse introspectionResult;
            JWTClaimsSet claims = jwtProcessor.process(signedJWT, null);
            if (!(!this.verifyTokenAtIdp || (introspectionResult = (introspectionClient = this.introspectionClients.get(issuer)).introspect(jwt)) != null && introspectionResult.isActive() && introspectionResult.indicatesSuccess())) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_FORBIDDEN, "Token introspection indicates invalid token.");
            }
            return new OidcJwtSession(claims, this.claimNameRoles, this.claimNameOrganisations, this.claimNameRights);
        }
        catch (Exception e) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_FORBIDDEN, "Failed to process/validate JWT.", e);
        }
    }
}

