/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.oidc;

import com.nimbusds.oauth2.sdk.TokenIntrospectionRequest;
import com.nimbusds.oauth2.sdk.TokenIntrospectionResponse;
import com.nimbusds.oauth2.sdk.TokenIntrospectionSuccessResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.Token;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import java.net.URI;

public class OidcTokenIntrospectionClient {
    private final URI introspectionEndpoint;
    private final ClientAuthentication clientAuthentication;

    public OidcTokenIntrospectionClient(IdentityProviderConfiguration providerConfiguration, OIDCProviderMetadata oidcMetadata) {
        this.introspectionEndpoint = oidcMetadata.getIntrospectionEndpointURI();
        this.clientAuthentication = new ClientSecretBasic(new ClientID(providerConfiguration.getOidcClientId()), new Secret(providerConfiguration.getOidcClientSecret()));
    }

    public TokenIntrospectionSuccessResponse introspect(String token) throws Exception {
        TokenIntrospectionRequest request = new TokenIntrospectionRequest(this.introspectionEndpoint, this.clientAuthentication, (Token)new BearerAccessToken(token));
        HTTPResponse response = request.toHTTPRequest().send();
        TokenIntrospectionResponse introspection = TokenIntrospectionResponse.parse((HTTPResponse)response);
        if (!introspection.indicatesSuccess()) {
            return null;
        }
        return introspection.toSuccessResponse();
    }
}

