/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.backup;

import de.virtimo.bpc.api.backup.BackupSnapshotInfo;
import de.virtimo.bpc.api.backup.SnapshotName;
import de.virtimo.bpc.api.backup.exception.BackupIndexNotFoundException;
import de.virtimo.bpc.api.backup.exception.BackupNotFoundException;
import de.virtimo.bpc.api.backup.exception.BackupRepositoryNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.backup.BackupSnapshotInfoImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.admin.cluster.repositories.cleanup.CleanupRepositoryRequest;
import org.opensearch.action.admin.cluster.repositories.cleanup.CleanupRepositoryResponse;
import org.opensearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.opensearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.opensearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.opensearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.opensearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.opensearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.opensearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.opensearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.opensearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.opensearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.repositories.RepositoryCleanupResult;
import org.opensearch.snapshots.SnapshotInfo;
import org.opensearch.snapshots.SnapshotMissingException;

public class Snapshotter {
    private static final Logger LOGGER = LogManager.getLogger(Snapshotter.class);
    private final OpenSearchService oss;

    public Snapshotter(OpenSearchService oss) {
        this.oss = oss;
    }

    private void throwConvertedOpenSearchException(OpenSearchException ex, String repositoryName) throws BackupRepositoryNotFoundException, OpenSearchRelatedException {
        if (ex instanceof OpenSearchStatusException) {
            if (RestStatus.NOT_FOUND.getStatus() == ex.status().getStatus() && ex.getMessage().contains("repository_missing_exception")) {
                Throwable cause = ex.getCause();
                if (cause instanceof OpenSearchException) {
                    throw new BackupRepositoryNotFoundException(repositoryName, (OpenSearchException)cause);
                }
                throw new BackupRepositoryNotFoundException(repositoryName, ex);
            }
            throw new OpenSearchRelatedException(ex);
        }
        throw new OpenSearchRelatedException(ex);
    }

    public boolean existsBackupRepository(String repositoryName) throws OpenSearchRelatedException {
        LOGGER.info("existsBackupRepository: repositoryName={}", (Object)repositoryName);
        try {
            GetRepositoriesRequest req = new GetRepositoriesRequest();
            GetRepositoriesResponse resp = this.oss.getClient().snapshot().getRepository(req, RequestOptions.DEFAULT);
            for (RepositoryMetadata repository : resp.repositories()) {
                if (!repository.name().equalsIgnoreCase(repositoryName)) continue;
                LOGGER.info("existsBackupRepository: YES");
                return true;
            }
            LOGGER.info("existsBackupRepository: NO");
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        return false;
    }

    public void createBackupRepository(String repositoryName, Map<String, Object> repositoryDefinition) throws OpenSearchRelatedException {
        LOGGER.info("createBackupRepository repositoryName={}, repositoryDefinition={}", (Object)repositoryName, repositoryDefinition);
        PutRepositoryRequest req = new PutRepositoryRequest(repositoryName).source(repositoryDefinition);
        this.createBackupRepository(req);
    }

    public void createFilesystemBackupRepository(String repositoryName, String backupFolderName) throws OpenSearchRelatedException {
        LOGGER.info("createFilesystemBackupRepository repositoryName={}, backupFolderName={}", (Object)repositoryName, (Object)backupFolderName);
        PutRepositoryRequest req = new PutRepositoryRequest(repositoryName).type("fs").settings(Settings.builder().put("location", backupFolderName).put("compress", true).build());
        this.createBackupRepository(req);
    }

    private void createBackupRepository(PutRepositoryRequest req) throws OpenSearchRelatedException {
        LOGGER.info("createBackupRepository req={}", (Object)req);
        try {
            this.oss.getClient().snapshot().createRepository(req, RequestOptions.DEFAULT);
        }
        catch (OpenSearchStatusException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof OpenSearchException) {
                throw new OpenSearchRelatedException((OpenSearchException)cause);
            }
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    public List<BackupSnapshotInfo> getAllSnapshots(String repositoryName) throws BackupRepositoryNotFoundException, OpenSearchRelatedException {
        LOGGER.info("getAllSnapshots repositoryName={}", (Object)repositoryName);
        try {
            GetSnapshotsRequest req = new GetSnapshotsRequest(repositoryName).verbose(false);
            GetSnapshotsResponse resp = this.oss.getClient().snapshot().get(req, RequestOptions.DEFAULT);
            List<SnapshotInfo> snapshotInfos = resp.getSnapshots();
            if (snapshotInfos != null) {
                ArrayList<BackupSnapshotInfo> result = new ArrayList<BackupSnapshotInfo>();
                for (SnapshotInfo snapshotInfo : snapshotInfos) {
                    try {
                        BackupSnapshotInfoImpl backupSnapshotInfo = new BackupSnapshotInfoImpl(snapshotInfo);
                        result.add(backupSnapshotInfo);
                    }
                    catch (IllegalArgumentException ex) {
                        LOGGER.warn("Please be sure that only BPC related snapshots exist in the backup repository: {}", (Object)repositoryName, (Object)ex);
                    }
                }
                return result;
            }
        }
        catch (OpenSearchException ex) {
            this.throwConvertedOpenSearchException(ex, repositoryName);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        return null;
    }

    public List<BackupSnapshotInfo> getAllSnapshotsWithPrefix(String repositoryName, String snapshotNamePrefix) throws BackupRepositoryNotFoundException, OpenSearchRelatedException {
        LOGGER.info("getAllSnapshotsWithPrefix repositoryName={}, snapshotNamePrefix={}", (Object)repositoryName, (Object)snapshotNamePrefix);
        List<BackupSnapshotInfo> allSnapshots = this.getAllSnapshots(repositoryName);
        ArrayList<BackupSnapshotInfo> result = new ArrayList<BackupSnapshotInfo>();
        for (BackupSnapshotInfo snapshot : allSnapshots) {
            if (!snapshot.getSnapshotName().hasPrefix(snapshotNamePrefix)) continue;
            result.add(snapshot);
        }
        return result;
    }

    public BackupSnapshotInfo getSnapshot(String repositoryName, SnapshotName snapshotName) throws BackupRepositoryNotFoundException, OpenSearchRelatedException {
        BackupSnapshotInfoImpl result;
        block7: {
            LOGGER.info("getSnapshot repositoryName={}, snapshotName={}", (Object)repositoryName, (Object)snapshotName);
            result = null;
            try {
                GetSnapshotsRequest req = new GetSnapshotsRequest(repositoryName).verbose(false).snapshots(new String[]{snapshotName.asString()});
                GetSnapshotsResponse resp = this.oss.getClient().snapshot().get(req, RequestOptions.DEFAULT);
                List<SnapshotInfo> snapshotInfos = resp.getSnapshots();
                if (snapshotInfos != null && snapshotInfos.size() == 1) {
                    try {
                        result = new BackupSnapshotInfoImpl(snapshotInfos.get(0));
                    }
                    catch (IllegalArgumentException ex) {
                        LOGGER.warn("Please be sure that only BPC related snapshots exist in the backup repository: {}", (Object)repositoryName, (Object)ex);
                    }
                }
            }
            catch (IOException ex) {
                throw new OpenSearchRelatedException(ex);
            }
            catch (SnapshotMissingException ex) {
            }
            catch (OpenSearchException ex) {
                if (RestStatus.NOT_FOUND.getStatus() == ex.status().getStatus() && ex.getMessage().contains("snapshot_missing_exception")) break block7;
                this.throwConvertedOpenSearchException(ex, repositoryName);
            }
        }
        return result;
    }

    public long getTimestampOfLatestSnapshot(List<BackupSnapshotInfo> snapshots) {
        LOGGER.info("getTimestampOfLatestSnapshot snapshots=...");
        long result = 0L;
        for (BackupSnapshotInfo snapshot : snapshots) {
            if (snapshot.getStartTimeInMillis() <= result) continue;
            result = snapshot.getStartTimeInMillis();
        }
        return result;
    }

    @NotNull
    public List<BackupSnapshotInfo> deleteOldSnapshots(@NotNull String repositoryName, List<BackupSnapshotInfo> snapshots, long keepBackupsDurationInSeconds) throws BackupRepositoryNotFoundException, OpenSearchRelatedException {
        LOGGER.info("deleteOldSnapshots repositoryName={}, snapshots=..., keepBackupsDurationInSeconds={}", (Object)repositoryName, (Object)keepBackupsDurationInSeconds);
        ArrayList<BackupSnapshotInfo> result = new ArrayList<BackupSnapshotInfo>();
        if (snapshots != null) {
            for (BackupSnapshotInfo snapshot : snapshots) {
                if (snapshot.getStartTimeInMillis() >= System.currentTimeMillis() - keepBackupsDurationInSeconds * 1000L) continue;
                try {
                    this.deleteSnapshot(repositoryName, snapshot.getSnapshotName());
                    result.add(snapshot);
                }
                catch (BackupNotFoundException backupNotFoundException) {}
            }
        }
        return result;
    }

    public void deleteSnapshot(@NotNull String repositoryName, SnapshotName snapshotName) throws BackupRepositoryNotFoundException, BackupNotFoundException, OpenSearchRelatedException {
        LOGGER.info("deleteSnapshot repositoryName={}, snapshotName={}", (Object)repositoryName, (Object)snapshotName);
        try {
            DeleteSnapshotRequest req = new DeleteSnapshotRequest(repositoryName, snapshotName.asString());
            this.oss.getClient().snapshot().delete(req, RequestOptions.DEFAULT);
        }
        catch (OpenSearchException ex) {
            if (RestStatus.NOT_FOUND.getStatus() == ex.status().getStatus() && ex.getMessage().contains("snapshot_missing_exception")) {
                throw new BackupNotFoundException(repositoryName, snapshotName.asString());
            }
            this.throwConvertedOpenSearchException(ex, repositoryName);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    public BackupSnapshotInfo createSnapshot(String repositoryName, SnapshotName snapshotName, Set<String> indices) throws BackupRepositoryNotFoundException, OpenSearchRelatedException {
        LOGGER.info("createSnapshot repositoryName={}, snapshotName={}, indices={}", (Object)repositoryName, (Object)snapshotName, indices);
        try {
            HashSet<String> existingIndices = new HashSet<String>();
            for (String index : indices) {
                if (this.oss.existsIndex(index)) {
                    existingIndices.add(index);
                    continue;
                }
                LOGGER.info("The index '{}' to backup does not exist. It will not be in the OpenSearch snapshot '{}'.", (Object)index, (Object)snapshotName);
            }
            if (!existingIndices.isEmpty()) {
                CreateSnapshotRequest req = new CreateSnapshotRequest(repositoryName, snapshotName.asString()).waitForCompletion(true).indices(existingIndices.toArray(new String[0]));
                CreateSnapshotResponse resp = this.oss.getClient().snapshot().create(req, RequestOptions.DEFAULT);
                LOGGER.info("Snapshot created: {}", (Object)resp.status());
                SnapshotInfo snapshotInfo = resp.getSnapshotInfo();
                return snapshotInfo == null ? null : new BackupSnapshotInfoImpl(snapshotInfo);
            }
            LOGGER.warn("Failed to create the snapshot '{}'. None of the indices to backup exists: {}", (Object)snapshotName, indices);
        }
        catch (OpenSearchException ex) {
            this.throwConvertedOpenSearchException(ex, repositoryName);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        return null;
    }

    public void restoreSnapshotIndices(String repositoryName, SnapshotName snapshotName, String renamePattern, String renameReplacement, boolean includeAlias) throws BackupRepositoryNotFoundException, BackupNotFoundException, OpenSearchRelatedException {
        LOGGER.info("restoreSnapshotIndices repositoryName={}, snapshotName={}, renamePattern={}, renameReplacement={}, includeAlias={}", (Object)repositoryName, (Object)snapshotName, (Object)renamePattern, (Object)renameReplacement, (Object)includeAlias);
        try {
            RestoreSnapshotRequest req = new RestoreSnapshotRequest(repositoryName, snapshotName.asString()).renamePattern(renamePattern).renameReplacement(renameReplacement).includeAliases(includeAlias).waitForCompletion(true);
            RestoreSnapshotResponse resp = this.oss.getClient().snapshot().restore(req, RequestOptions.DEFAULT);
            LOGGER.info("Snapshot restored: {}", (Object)resp.status());
        }
        catch (OpenSearchException ex) {
            if (RestStatus.INTERNAL_SERVER_ERROR.getStatus() == ex.status().getStatus() && ex.getMessage().contains("snapshot does not exist")) {
                throw new BackupNotFoundException(repositoryName, snapshotName.asString());
            }
            this.throwConvertedOpenSearchException(ex, repositoryName);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    public void restoreSingleSnapshotIndex(String repositoryName, SnapshotName snapshotName, String snapshotIndexName, String newIndexName, boolean includeAlias) throws BackupRepositoryNotFoundException, BackupNotFoundException, BackupIndexNotFoundException, OpenSearchRelatedException {
        LOGGER.info("restoreSingleSnapshotIndex repositoryName={}, snapshotName={}, snapshotIndexName={}, newIndexName={}, includeAlias={}", (Object)repositoryName, (Object)snapshotName, (Object)snapshotIndexName, (Object)newIndexName, (Object)includeAlias);
        try {
            RestoreSnapshotRequest req = new RestoreSnapshotRequest(repositoryName, snapshotName.asString()).indices(snapshotIndexName).renamePattern(snapshotIndexName).renameReplacement(newIndexName).includeAliases(includeAlias).waitForCompletion(true);
            RestoreSnapshotResponse resp = this.oss.getClient().snapshot().restore(req, RequestOptions.DEFAULT);
            LOGGER.info("Snapshot restored: {}", (Object)resp.status());
        }
        catch (OpenSearchException ex) {
            if (RestStatus.INTERNAL_SERVER_ERROR.getStatus() == ex.status().getStatus() && ex.getMessage().contains("snapshot does not exist")) {
                throw new BackupNotFoundException(repositoryName, snapshotName.asString());
            }
            if (RestStatus.NOT_FOUND.getStatus() == ex.status().getStatus() && ex.getMessage().contains("index_not_found_exception")) {
                throw new BackupIndexNotFoundException(repositoryName, snapshotName.asString(), snapshotIndexName);
            }
            this.throwConvertedOpenSearchException(ex, repositoryName);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    public void restoreAllSnapshotIndices(String repositoryName, SnapshotName snapshotName, boolean includeAlias) throws BackupRepositoryNotFoundException, BackupNotFoundException, OpenSearchRelatedException {
        LOGGER.info("restoreAllSnapshotIndices repositoryName={}, snapshotName={}, includeAlias={}", (Object)repositoryName, (Object)snapshotName, (Object)includeAlias);
        try {
            RestoreSnapshotRequest req = new RestoreSnapshotRequest(repositoryName, snapshotName.asString()).includeAliases(includeAlias).waitForCompletion(true);
            RestoreSnapshotResponse resp = this.oss.getClient().snapshot().restore(req, RequestOptions.DEFAULT);
            LOGGER.info("Snapshot restored: {}", (Object)resp.status());
        }
        catch (OpenSearchException ex) {
            if (RestStatus.INTERNAL_SERVER_ERROR.getStatus() == ex.status().getStatus() && ex.getMessage().contains("snapshot does not exist")) {
                throw new BackupNotFoundException(repositoryName, snapshotName.asString());
            }
            this.throwConvertedOpenSearchException(ex, repositoryName);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    public RepositoryCleanupResult cleanupRepository(@NotNull String repositoryName) throws BackupRepositoryNotFoundException, OpenSearchRelatedException {
        LOGGER.info("cleanupRepository repositoryName={}", (Object)repositoryName);
        RepositoryCleanupResult cleanupResult = null;
        try {
            CleanupRepositoryRequest req = new CleanupRepositoryRequest(repositoryName);
            CleanupRepositoryResponse resp = this.oss.getClient().snapshot().cleanupRepository(req, RequestOptions.DEFAULT);
            cleanupResult = resp.result();
        }
        catch (OpenSearchException ex) {
            this.throwConvertedOpenSearchException(ex, repositoryName);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        return cleanupResult;
    }
}

