/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.backup;

import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.backup.SnapshotIndexModelVersionManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class TemporaryIndices
implements Iterable<String> {
    private static final Logger LOGGER = LogManager.getLogger(SnapshotIndexModelVersionManager.class);
    private final OpenSearchService oss;
    private final Map<String, String> tmpIndexNames;
    private final String prefix;
    private static long prefixCounter = 0L;
    private String existingIndexName;

    TemporaryIndices(OpenSearchService oss, List<String> indices) {
        this.oss = oss;
        this.prefix = "tmp_backup_restore_index_" + TemporaryIndices.getNextPrefixCounter() + "_";
        this.tmpIndexNames = this.createTmpIndexNames(indices);
    }

    private static synchronized long getNextPrefixCounter() {
        if (prefixCounter == Long.MAX_VALUE) {
            prefixCounter = 0L;
        }
        return ++prefixCounter;
    }

    String getPrefix() {
        return this.prefix;
    }

    private String createTmpIndexName(String indexName) {
        return this.prefix + indexName;
    }

    private Map<String, String> createTmpIndexNames(List<String> indices) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (indices != null) {
            for (String index : indices) {
                result.put(index, this.createTmpIndexName(index));
            }
        }
        return result;
    }

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return this.tmpIndexNames.values().iterator();
    }

    int size() {
        return this.tmpIndexNames.size();
    }

    String getTmpIndexName(String indexName) {
        return this.tmpIndexNames.get(indexName);
    }

    String getIndexName(String temporaryIndexName) {
        for (Map.Entry<String, String> indexAndTmpIndexNames : this.tmpIndexNames.entrySet()) {
            String indexName = indexAndTmpIndexNames.getKey();
            String tmpIndexName = indexAndTmpIndexNames.getValue();
            if (!tmpIndexName.equals(temporaryIndexName)) continue;
            return indexName;
        }
        return null;
    }

    boolean existsAtLeastOneOfThem() throws OpenSearchRelatedException {
        LOGGER.info("existsAtLeastOneOfThem");
        for (String tmpIndexName : this.tmpIndexNames.values()) {
            if (!this.oss.existsIndex(tmpIndexName)) continue;
            this.existingIndexName = tmpIndexName;
            return true;
        }
        return false;
    }

    String getNameOfExistingTmpIndex() {
        return this.existingIndexName;
    }

    void deleteAll() {
        LOGGER.info("deleteAll");
        for (String tmpIndexName : this.tmpIndexNames.values()) {
            try {
                this.oss.deleteIndex(tmpIndexName);
            }
            catch (Throwable ex) {
                LOGGER.error("Failed to delete the temporary index: " + tmpIndexName, ex);
            }
        }
    }
}

