/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.bom;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.exception.BomException;
import de.virtimo.bpc.api.service.BomCollectorService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.utils.BpcBundleUtil;
import de.virtimo.bpc.module.JsonDefaultsUtil;
import de.virtimo.bpc.util.ObjectMapperPool;
import de.virtimo.bpc.util.StringUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class BomCollectorServiceImpl
implements BomCollectorService,
BpcService,
BundleListener {
    private static final Logger LOGGER = LogManager.getLogger(BomCollectorServiceImpl.class);
    private static final Object BOMS_LOCK = new Object();
    private final BundleContext bundleContext;
    private Map<String, Map<String, Object>> boms;

    public BomCollectorServiceImpl(BundleContext bundleContext) {
        LOGGER.info("BomCollectorServiceImpl bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
        this.boms = null;
        this.bundleContext.addBundleListener((BundleListener)this);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.debug("shutdownService");
        if (this.bundleContext != null) {
            this.bundleContext.removeBundleListener((BundleListener)this);
        }
        BpcServicesTracker.stopAll(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        LOGGER.info("bundleChanged event={}", (Object)event);
        Object object = BOMS_LOCK;
        synchronized (object) {
            if (this.boms == null) {
                LOGGER.info("Nothing to do until the BOMs are loaded once");
            } else {
                switch (event.getType()) {
                    case 2: {
                        this._loadBomFromBundle(event.getBundle());
                        break;
                    }
                    case 4: {
                        this._removeBom(event.getBundle());
                    }
                }
            }
        }
    }

    private void _loadBomsFromAllBundles() {
        LOGGER.info("_loadBomsFromAllBundles");
        if (this.boms == null) {
            this.boms = new HashMap<String, Map<String, Object>>();
        }
        for (Bundle bundle : this.bundleContext.getBundles()) {
            this._loadBomFromBundle(bundle);
        }
    }

    private void _loadBomFromBundle(Bundle bundle) {
        LOGGER.info("_loadBomFromBundle bundle={}", (Object)bundle);
        if (bundle == null) {
            return;
        }
        String symbolicBundleName = bundle.getSymbolicName();
        if (StringUtil.isNullOrEmpty(symbolicBundleName)) {
            LOGGER.info("The bundle '{}' does not provide a symbolic name.", (Object)bundle);
            return;
        }
        if (!BpcBundleUtil.isBpcBundle(bundle)) {
            LOGGER.info("The bundle '{}' is not a BPC bundle and can be safely ignored.", (Object)symbolicBundleName);
            return;
        }
        URL bomFileUrl = BpcBundleUtil.getFileInBundleAtSpecificFolder(bundle, "/META-INF", "bom.json");
        if (bomFileUrl == null) {
            LOGGER.info("The bundle '{}' does not have an embedded 'bom.json' file.", (Object)symbolicBundleName);
        } else {
            String filePath = bomFileUrl.getFile();
            Map<String, Object> bomMap = JsonDefaultsUtil.loadJsonFileAsMap(bundle, filePath);
            if (bomMap != null) {
                this.boms.put(symbolicBundleName.toLowerCase(), bomMap);
            }
        }
    }

    private void _removeBom(Bundle bundle) {
        LOGGER.info("_removeBom bundle={}", (Object)bundle);
        if (this.boms == null || bundle == null) {
            return;
        }
        String symbolicBundleName = bundle.getSymbolicName();
        if (StringUtil.isNullOrEmpty(symbolicBundleName)) {
            return;
        }
        this.boms.remove(symbolicBundleName.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceReload() {
        LOGGER.info("forceReload");
        Object object = BOMS_LOCK;
        synchronized (object) {
            this.boms = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Map<String, Object>> getAllBoms() {
        LOGGER.info("getAllBoms");
        Object object = BOMS_LOCK;
        synchronized (object) {
            if (this.boms == null) {
                this._loadBomsFromAllBundles();
            }
            return this.boms;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getSymbolicNamesOfBundles() {
        LOGGER.info("getSymbolicNamesOfBundles");
        Object object = BOMS_LOCK;
        synchronized (object) {
            if (this.boms == null) {
                this._loadBomsFromAllBundles();
            }
            return this.boms.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getBom(String symbolicNameOfBundle) throws BomException {
        LOGGER.info("getBom symbolicNameOfBundle={}", (Object)symbolicNameOfBundle);
        if (StringUtil.isNullOrEmpty(symbolicNameOfBundle)) {
            throw new BomException((ErrorCode)CoreErrorCode.BOM_MISSING_INPUT, "Symbolic name of bundle not provided.");
        }
        Object object = BOMS_LOCK;
        synchronized (object) {
            Map<String, Object> bom;
            if (this.boms == null) {
                this._loadBomsFromAllBundles();
            }
            if ((bom = this.boms.get(symbolicNameOfBundle.toLowerCase())) == null) {
                throw new BomException((ErrorCode)CoreErrorCode.BOM_NOT_FOUND, "No BOM found for the bundle with the symbolic name: ${symbolicBundleName}", Map.of("symbolicBundleName", symbolicNameOfBundle.toLowerCase()));
            }
            return bom;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamingOutput downloadBom(String symbolicNameOfBundle) throws BomException {
        LOGGER.info("downloadBom symbolicNameOfBundle={}", (Object)symbolicNameOfBundle);
        if (StringUtil.isNullOrEmpty(symbolicNameOfBundle)) {
            throw new BomException((ErrorCode)CoreErrorCode.BOM_MISSING_INPUT, "Symbolic name of bundle not provided.");
        }
        Object object = BOMS_LOCK;
        synchronized (object) {
            Map<String, Object> bom;
            if (this.boms == null) {
                this._loadBomsFromAllBundles();
            }
            if ((bom = this.boms.get(symbolicNameOfBundle.toLowerCase())) == null) {
                throw new BomException((ErrorCode)CoreErrorCode.BOM_NOT_FOUND, "No BOM found for the bundle with the symbolic name: ${symbolicBundleName}", Map.of("symbolicBundleName", symbolicNameOfBundle.toLowerCase()));
            }
            return new StreamingOutput(){

                public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                    try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));){
                        ObjectMapper objectMapper = ObjectMapperPool.createCustomizedObjectMapper();
                        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
                        String json = objectMapper.writeValueAsString((Object)bom);
                        writer.write(json);
                    }
                }
            };
        }
    }
}

