/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.bom;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.service.BomCollectorService;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="bom")
@Tag(name="BOM API", description="The Bill-of-Materials (BOM) is an aggregation of all software dependencies the BPC modules/bundles have.\nThese endpoints allow to list, retrieve, download and force-reload all available BOMs.\n\nTo get listed the modules/bundles must place their BOM to the file `/META-INF/bom.json`.\n")
public class BomEndpoints {
    private static final Logger LOGGER = LogManager.getLogger(BomEndpoints.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<BomCollectorService> bomCollectorServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public BomEndpoints(BundleContext bundleContext) {
        LOGGER.info("BomEndpoints bundleContext=...");
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.bomCollectorServiceTracker = new BpcServicesTracker<BomCollectorService>(this.bundleContext, BomCollectorService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @DELETE
    @Path(value="/")
    @BpcRoleOrRightRequired(role="BOMS_ADMIN", right="BOMS_RELOAD", message="You are not allowed to force a BOMs re-load.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Forces a re-load of the BOMs.", description="Forces a re-load of the BOMs.")
    public Response forceBomsReload(@Context HttpHeaders hh) {
        LOGGER.info("forceBomsReload");
        try {
            this.bomCollectorServiceTracker.getService().forceReload();
            return Response.ok().build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/all")
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Get the BOMs of all BPC bundles.", description="Get the BOMs of all BPC bundles.")
    @ReturnDescription(value="The requested BOMs. Example response:\n\n[source,json]\n----\n{\n   \"SYMBOLIC_NAME_BUNDLE_1\": BOM_FILE_CONTENT_1,\n   \"SYMBOLIC_NAME_BUNDLE_2\": BOM_FILE_CONTENT_2,\n   \"SYMBOLIC_NAME_BUNDLE_n\": BOM_FILE_CONTENT_n\n}\n----\n\n- `SYMBOLIC_NAME_BUNDLE_1` etc. is the symbolic name of the BPC bundle\n- `BOM_FILE_CONTENT_1` etc. is the content of the `/META-INF/bom.json` file\n")
    public Response getAll(@Context HttpHeaders hh) {
        LOGGER.info("getAll");
        try {
            return Response.ok(this.bomCollectorServiceTracker.getService().getAllBoms(), (String)"application/json").build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/bundles")
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Get just the symbolic names of BPC bundles with BOMs.", description="Get just the symbolic names of BPC bundles with BOMs.")
    @ReturnDescription(value="The requested list. Example response:\n\n[source,json]\n----\n[\n   \"SYMBOLIC_NAME_BUNDLE_1\",\n   \"SYMBOLIC_NAME_BUNDLE_2\",\n   \"SYMBOLIC_NAME_BUNDLE_n\"\n]\n----\n")
    public Response getSymbolicNamesOfBundlesWithBoms(@Context HttpHeaders hh) {
        LOGGER.info("getSymbolicNamesOfBundlesWithBoms");
        try {
            return Response.ok(this.bomCollectorServiceTracker.getService().getSymbolicNamesOfBundles()).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/bundle/{symbolicNameOfBundle}")
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Requested BOM not found")})
    @OperationDescription(summary="Get the BOM of a specific BPC bundle by its symbolic name.", description="Get the BOM of a specific BPC bundle by its symbolic name.")
    @ReturnDescription(value="The content of the `/META-INF/bom.json` file")
    public Response getBom(@Parameter(description="the symbolic name of the bundle to get the BOM for") @PathParam(value="symbolicNameOfBundle") String symbolicNameOfBundle, @Context HttpHeaders hh) {
        LOGGER.info("getBom symbolicNameOfBundle={}", (Object)symbolicNameOfBundle);
        try {
            return Response.ok(this.bomCollectorServiceTracker.getService().getBom(symbolicNameOfBundle)).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/bundle/download/{symbolicNameOfBundle}")
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Requested BOM not found")})
    @OperationDescription(summary="Download the BOM of a specific BPC bundle by its symbolic name.", description="Download the BOM of a specific BPC bundle by its symbolic name.")
    @ReturnDescription(value="The content of the `/META-INF/bom.json` file")
    public Response downloadBom(@Parameter(description="the symbolic name of the bundle to download the BOM for") @PathParam(value="symbolicNameOfBundle") String symbolicNameOfBundle, @Context HttpHeaders hh) {
        LOGGER.info("downloadBom symbolicNameOfBundle={}", (Object)symbolicNameOfBundle);
        try {
            StreamingOutput stream = this.bomCollectorServiceTracker.getService().downloadBom(symbolicNameOfBundle);
            return Response.ok((Object)stream, (String)"application/json").header("Content-Disposition", (Object)("attachment; filename=\"" + symbolicNameOfBundle + ".json\"")).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

