/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.datalock;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.exception.OpenSearchIndexNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.datalock.DataLockItemNotFoundException;
import de.virtimo.bpc.core.datalock.DataLockService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.osgi.framework.BundleContext;

public class DataLockServiceImpl
implements DataLockService,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(DataLockServiceImpl.class);
    private static final String INDEX_NAME = "bpc-datalock";
    private final BundleContext bundleContext;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;

    public DataLockServiceImpl(BundleContext bundleContext) {
        LOGGER.info("DataLockServiceImpl bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public SearchResponse getAllItems(Integer start, Integer limit) throws ServiceNotFoundException, OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("getAllItems start={}, limit={}", (Object)start, (Object)limit);
        SearchRequest searchRequest = new SearchRequest().indices(INDEX_NAME).source(new SearchSourceBuilder().from(start).size(limit));
        return this.openSearchServiceTracker.getService().search(searchRequest, RequestOptions.DEFAULT);
    }

    @Override
    public GetResponse getItem(String itemId) throws ServiceNotFoundException, OpenSearchRelatedException, OpenSearchIndexNotFoundException, DataLockItemNotFoundException {
        LOGGER.info("getItem itemId={}", (Object)itemId);
        GetRequest getRequest = ((GetRequest)new GetRequest().index(INDEX_NAME)).id(itemId);
        GetResponse response = this.openSearchServiceTracker.getService().get(getRequest, RequestOptions.DEFAULT);
        if (!response.isExists()) {
            throw new DataLockItemNotFoundException(itemId, INDEX_NAME);
        }
        return response;
    }

    @Override
    public void createItem(String itemId, String jsonData) throws ServiceNotFoundException, OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("createItem itemId={}, jsonData={}", (Object)itemId, (Object)jsonData);
        IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest().index(INDEX_NAME)).id(itemId).source(jsonData, (MediaType)XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.openSearchServiceTracker.getService().index(indexRequest, RequestOptions.DEFAULT);
    }

    @Override
    public void updateItem(String itemId, String jsonData) throws ServiceNotFoundException, OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("updateItem itemId={}, jsonData={}", (Object)itemId, (Object)jsonData);
        IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest().index(INDEX_NAME)).id(itemId).source(jsonData, (MediaType)XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.openSearchServiceTracker.getService().index(indexRequest, RequestOptions.DEFAULT);
    }

    @Override
    public void deleteItem(String itemId) throws ServiceNotFoundException, OpenSearchRelatedException, OpenSearchIndexNotFoundException, DataLockItemNotFoundException {
        LOGGER.info("deleteItem itemId={}", (Object)itemId);
        DeleteRequest deleteRequest = ((DeleteRequest)new DeleteRequest().index(INDEX_NAME)).id(itemId);
        DeleteResponse deleteResponse = this.openSearchServiceTracker.getService().delete(deleteRequest, RequestOptions.DEFAULT);
        if (deleteResponse.status() == RestStatus.NOT_FOUND) {
            throw new DataLockItemNotFoundException(itemId, INDEX_NAME);
        }
    }
}

