/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.datalock.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.datalock.DataLockService;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.search.SearchResponse;
import org.osgi.framework.BundleContext;

@Path(value="datalock")
@Tag(name="Data Lock API", description="The data lock endpoints are tightly tied to OpenSearch (responses).\nPlease try to use the storage endpoints instead.\n")
public class DatalockEndpoints {
    private static final Logger LOGGER = LogManager.getLogger(DatalockEndpoints.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<DataLockService> dataLockServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public DatalockEndpoints(BundleContext bundleContext) {
        LOGGER.info("DatalockEndpoints bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.dataLockServiceTracker = new BpcServicesTracker<DataLockService>(this.bundleContext, DataLockService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Get data lock items from the OpenSearch index `bpc-datalock`.", description="Get data lock items from the OpenSearch index `bpc-datalock`.")
    @ReturnDescription(value="The requested items as JSON (1:1 OpenSearch response)")
    public Response getAllItems(@Parameter(description="first record to be read") @QueryParam(value="start") @DefaultValue(value="0") Integer start, @Parameter(description="number of records to read") @QueryParam(value="limit") @DefaultValue(value="1000") Integer limit) {
        LOGGER.info("getAllItems start={}, limit={}", (Object)start, (Object)limit);
        try {
            DataLockService dataLockService = this.dataLockServiceTracker.getService();
            SearchResponse searchResponse = dataLockService.getAllItems(start, limit);
            String jsonString = searchResponse.toString();
            return Response.ok((Object)jsonString, (String)"application/json").build();
        }
        catch (Exception e) {
            LOGGER.error("get all items failed", (Throwable)e);
            return ErrorResponse.forException(e).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/{itemId}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Get a specific data lock item from the OpenSearch index `bpc-datalock`.", description="Get a specific data lock item from the OpenSearch index `bpc-datalock`.")
    @ReturnDescription(value="The requested item as JSON (1:1 OpenSearch response)")
    public Response getItem(@Parameter(description="the ID of the item") @PathParam(value="itemId") String itemId) {
        LOGGER.info("getItem itemId={}", (Object)itemId);
        try {
            DataLockService dataLockService = this.dataLockServiceTracker.getService();
            GetResponse response = dataLockService.getItem(itemId);
            String jsonString = response.getSourceAsString();
            return Response.ok((Object)jsonString, (String)"application/json").build();
        }
        catch (Exception e) {
            LOGGER.error("get item failed", (Throwable)e);
            return ErrorResponse.forException(e).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @POST
    @Path(value="/{itemId}")
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Sets the provided data for a specific item. The body data is written to the OpenSearch index `bpc-datalock`.", description="Sets the provided data for a specific item. The body data is written to the OpenSearch index `bpc-datalock`.")
    public Response createItem(@Parameter(description="the ID of the item to set the data for") @PathParam(value="itemId") String itemId, String jsonData) {
        LOGGER.info("createItem itemId={}", (Object)itemId);
        try {
            DataLockService dataLockService = this.dataLockServiceTracker.getService();
            dataLockService.createItem(itemId, jsonData);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("create item failed", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @PUT
    @Path(value="/{itemId}")
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Updates an item with the provided data in the body. The item gets updated in the OpenSearch index `bpc-datalock`.", description="Updates an item with the provided data in the body. The item gets updated in the OpenSearch index `bpc-datalock`.")
    public Response updateItem(@Parameter(description="the ID of the item to update") @PathParam(value="itemId") String itemId, String jsonData) {
        LOGGER.info("updateItem itemId={}", (Object)itemId);
        try {
            DataLockService dataLockService = this.dataLockServiceTracker.getService();
            dataLockService.updateItem(itemId, jsonData);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("update item failed", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/{itemId}")
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Deletes a specific item from the OpenSearch index `bpc-datalock`.", description="Deletes a specific item from the OpenSearch index `bpc-datalock`.")
    public Response deleteItem(@Parameter(description="the ID of the item to delete") @PathParam(value="itemId") String itemId) {
        LOGGER.info("deleteItem itemId={}", (Object)itemId);
        try {
            DataLockService dataLockService = this.dataLockServiceTracker.getService();
            dataLockService.deleteItem(itemId);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("delete item failed", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

