/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.db;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingValidator;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.db.PaxJdbcConfigurationUpdatedInfo;
import de.virtimo.bpc.api.db.exception.DataSourceException;
import de.virtimo.bpc.api.db.exception.DataSourceNotFoundException;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.FrontendWarningException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.backendconnections.BackendConnectionsModule;
import de.virtimo.bpc.core.db.DataSourcePropertiesHelper;
import de.virtimo.bpc.core.db.DataSourceSettings;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.service.jdbc.DataSourceFactory;

public class DataSourcesSettingValidator
implements SettingValidator {
    private static final Logger LOGGER = LogManager.getLogger(DataSourcesSettingValidator.class);
    private final BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private final BpcServicesTracker<DatabaseManager> databaseManagerTracker;

    public DataSourcesSettingValidator(BundleContext bundleContext) {
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
        this.databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(bundleContext, DatabaseManager.class);
    }

    @Override
    public void destroy() {
        LOGGER.info("destroy");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public boolean canValidate(String moduleId, String moduleInstanceId, String instanceType) {
        return "backendconnection".equalsIgnoreCase(moduleId) && "data_source".equalsIgnoreCase(instanceType);
    }

    @Override
    public boolean canValidate(Setting setting) {
        if ("data_source".equalsIgnoreCase(setting.getInstanceType())) {
            List<String> settingsToValidate = Arrays.asList("driverName", "configuration");
            return settingsToValidate.contains(setting.getName());
        }
        return false;
    }

    @Override
    public List<FrontendWarningException> validate(Setting setting) throws ValidationException {
        LOGGER.info("validate setting={}", (Object)setting);
        try {
            DatabaseManager databaseManager = this.databaseManagerTracker.getService();
            if (setting.getName().equalsIgnoreCase("driverName")) {
                String driverName = (String)setting.getValue();
                if (StringUtil.isNullOrEmpty(driverName)) {
                    throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "${field}: The OSGi JDBC driver name is missing", MapUtil.mapOf("field", "driverName"));
                }
                List<String> registeredDataSourceFactoryNames = databaseManager.getAllDataSourceFactoryNames();
                if (!registeredDataSourceFactoryNames.contains(driverName)) {
                    throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "${field}: The OSGi JDBC driver name '${fieldValue}' does not exist", MapUtil.mapOf("field", "driverName", "fieldValue", driverName));
                }
            }
            if (setting.getName().equalsIgnoreCase("configuration")) {
                Map dataSourceConfiguration;
                try {
                    dataSourceConfiguration = (Map)setting.getValue();
                }
                catch (Exception ex) {
                    throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "${field}: Must be surrounded by curly brackets", MapUtil.mapOf("field", "configuration"));
                }
                String poolName = (String)dataSourceConfiguration.get("pool");
                if (StringUtil.isNullOrEmpty(poolName)) {
                    throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "${field}: Name of the pool implementation to use (${subField}) is missing", MapUtil.mapOf("field", "configuration", "subField", "pool"));
                }
            }
            return null;
        }
        catch (ValidationException ex) {
            throw ex;
        }
        catch (SystemException ex) {
            throw new ValidationException(ex.getErrorCode(), ex.getMessage(), ex);
        }
    }

    @Override
    public List<FrontendWarningException> validate(String moduleId, String moduleInstanceId, String instanceType, Map<String, Setting> settings) throws ValidationException {
        LOGGER.info("validate moduleId={}, moduleInstanceId={}, instanceType={}, settings:...", (Object)moduleId, (Object)moduleInstanceId, (Object)instanceType);
        try {
            Connection databaseConnection;
            DataSource dataSource;
            PaxJdbcConfigurationUpdatedInfo processedDataSourceNames;
            DatabaseManager databaseManager = this.databaseManagerTracker.getService();
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            BackendConnectionsModule backendConnectionsModule = moduleManager.getModuleByClass(BackendConnectionsModule.class);
            String dataSourceName = moduleInstanceId;
            Map<String, Object> paxJdbcDataSourceConfig = DataSourceSettings.asPaxJdbcDataSourceConfiguration(dataSourceName, settings);
            this.createConnection(dataSourceName, paxJdbcDataSourceConfig);
            try {
                String dataSourceName2 = moduleInstanceId;
                List<Map<String, Object>> paxJdbcDataSourceConfigurations = DataSourceSettings.getAllPaxJdbcDataSourceConfigurationsExceptFromModuleInstanceId(backendConnectionsModule, moduleInstanceId);
                DataSourceSettings.addAsPaxJdbcDataSourceConfiguration(paxJdbcDataSourceConfigurations, dataSourceName2, settings);
                processedDataSourceNames = databaseManager.createOrUpdateDataSourcesByUsingPaxJdbcConfigurations(paxJdbcDataSourceConfigurations);
            }
            catch (Exception ex) {
                throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_EXCEPTION, "Failed to create/update the data source configurations.", MapUtil.mapOf("field", "configuration"), (Throwable)ex);
            }
            Thread.sleep(2000L);
            for (String dataSourceName3 : processedDataSourceNames.getNewDataSources()) {
                try {
                    dataSource = databaseManager.getDataSource(dataSourceName3);
                    databaseConnection = dataSource.getConnection();
                    try {
                        if (databaseConnection != null && databaseConnection.isValid(15)) continue;
                        throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_INVALID_CONNECTION, "Database connection does not exist or is invalid: ${dataSourceName}", MapUtil.mapOf("field", "configuration", "dataSourceName", dataSourceName3));
                    }
                    finally {
                        if (databaseConnection == null) continue;
                        databaseConnection.close();
                    }
                }
                catch (Exception ex) {
                    try {
                        databaseManager.deleteDataSourceConfiguration(dataSourceName3);
                    }
                    catch (Exception e) {
                        LOGGER.error("Could not delete the data source configuration: " + dataSourceName3, (Throwable)e);
                    }
                    if (ex instanceof ValidationException) {
                        throw ex;
                    }
                    if (ex instanceof DataSourceNotFoundException) {
                        throw new ValidationException((ErrorCode)BpcErrorCode.DATABASE_DATASOURCE_NOT_FOUND, ex.getMessage(), ex);
                    }
                    throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_INVALID_CONNECTION, "Could not get the database connection of the new data source '${dataSourceName}': ${error}", MapUtil.mapOf("field", "configuration", "dataSourceName", dataSourceName3, "error", ex.getLocalizedMessage()), (Throwable)ex);
                }
            }
            for (String dataSourceName3 : processedDataSourceNames.getUpdatedDataSources()) {
                try {
                    dataSource = databaseManager.getDataSource(dataSourceName3);
                    databaseConnection = dataSource.getConnection();
                    try {
                        if (databaseConnection != null && databaseConnection.isValid(15)) continue;
                        throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_INVALID_CONNECTION, "Database connection does not exist or is invalid: ${dataSourceName}", MapUtil.mapOf("field", "configuration", "dataSourceName", dataSourceName3));
                    }
                    finally {
                        if (databaseConnection == null) continue;
                        databaseConnection.close();
                    }
                }
                catch (ValidationException ex) {
                    throw ex;
                }
                catch (DataSourceNotFoundException ex) {
                    throw new ValidationException(ex.getErrorCode(), ex.getMessage(), ex);
                }
                catch (Exception ex) {
                    throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_INVALID_CONNECTION, "Could not get the database connection of the updated data source '${dataSourceName}': ${error}", MapUtil.mapOf("field", "configuration", "dataSourceName", dataSourceName3, "error", ex.getLocalizedMessage()), (Throwable)ex);
                }
            }
            return null;
        }
        catch (ValidationException ex) {
            throw ex;
        }
        catch (SystemException ex) {
            throw new ValidationException(ex.getErrorCode(), ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw new ValidationException((ErrorCode)CoreErrorCode.UNEXPECTED, ex.getMessage(), ex);
        }
    }

    private void createConnection(String dataSourceName, Map<String, Object> paxJdbcDataSourceConfig) throws ValidationException {
        LOGGER.info("createConnection dataSourceName={}, paxJdbcDataSourceConfig=...", (Object)dataSourceName);
        try {
            DatabaseManager databaseManager = this.databaseManagerTracker.getService();
            DataSourceFactory dataSourceFactory = databaseManager.getDataSourceFactory(paxJdbcDataSourceConfig);
            LOGGER.info("dataSourceFactory = {}", (Object)dataSourceFactory);
            Properties dataSourceProperties = DataSourcePropertiesHelper.removeDataSourceFactoryRelatedProperties(paxJdbcDataSourceConfig);
            DataSource dataSource = dataSourceFactory.createDataSource(dataSourceProperties);
            LOGGER.info("dataSource = {}", (Object)dataSource);
            try (Connection databaseConnection = dataSource.getConnection();){
                if (databaseConnection == null || !databaseConnection.isValid(15)) {
                    LOGGER.info("databaseConnection = {}", (Object)databaseConnection);
                    throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_INVALID_CONNECTION, "Database connection is invalid: ${dataSourceName}", MapUtil.mapOf("field", "configuration", "dataSourceName", dataSourceName));
                }
            }
        }
        catch (ServiceNotFoundException ex) {
            throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_EXCEPTION, "Failed to validate the data source configuration due to the error: ${error}", MapUtil.mapOf("field", "configuration", "error", ex.getMessage()));
        }
        catch (DataSourceException | SQLException ex) {
            throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_EXCEPTION, (Throwable)ex);
        }
    }
}

