/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.deployment;

import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.deployment.DeploymentInitiator;
import de.virtimo.bpc.util.MapUtil;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;

public class DeploymentInitiatorImpl
implements DeploymentInitiator {
    private static final String X_HEADER_INITIATED_BY_USER = "X-InitiatedByUser";
    private static final String X_HEADER_INITIATED_FROM_SERVER_NAME = "X-InitiatedFromServerName";
    private static final String X_HEADER_INITIATED_FROM_SERVER_UUID = "X-InitiatedFromServerUUID";
    private final String userName;
    private final String serverName;
    private final String serverUUID;

    public DeploymentInitiatorImpl(HttpHeaders httpHeaders) {
        this.userName = httpHeaders.getHeaderString(X_HEADER_INITIATED_BY_USER);
        this.serverName = httpHeaders.getHeaderString(X_HEADER_INITIATED_FROM_SERVER_NAME);
        this.serverUUID = httpHeaders.getHeaderString(X_HEADER_INITIATED_FROM_SERVER_UUID);
    }

    public DeploymentInitiatorImpl(String userName, String serverName, String serverUUID) {
        this.userName = userName;
        this.serverName = serverName;
        this.serverUUID = serverUUID;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public String getServerUUID() {
        return this.serverUUID;
    }

    public static Map<String, Object> httpHeaders(UserSession userSession, CoreBundleConfiguration coreBundleConfiguration) {
        return MapUtil.mapOf(X_HEADER_INITIATED_BY_USER, userSession == null ? "Unknown" : userSession.getLoginName(), X_HEADER_INITIATED_FROM_SERVER_NAME, coreBundleConfiguration.getBpcName(), X_HEADER_INITIATED_FROM_SERVER_UUID, coreBundleConfiguration.getServerUUID());
    }

    public static boolean isRequestFromDeploymentInitiator(HttpHeaders httpHeaders) {
        if (httpHeaders != null) {
            String initiatedByUser = httpHeaders.getHeaderString(X_HEADER_INITIATED_BY_USER);
            String initiatedFromServerName = httpHeaders.getHeaderString(X_HEADER_INITIATED_FROM_SERVER_NAME);
            String initiatedFromServerUUID = httpHeaders.getHeaderString(X_HEADER_INITIATED_FROM_SERVER_UUID);
            return initiatedByUser != null && initiatedFromServerName != null && initiatedFromServerUUID != null;
        }
        return false;
    }

    public String toString() {
        return "DeploymentInitiator{userName='" + this.userName + "', serverName='" + this.serverName + "', serverUUID='" + this.serverUUID + "'}";
    }
}

