/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.deployment;

import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.core.SettingFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DeploymentSettingsDiffer {
    private static final Logger LOGGER = LogManager.getLogger(DeploymentSettingsDiffer.class);
    private final List<Map<String, Object>> sourceSettingsMaps;
    private final List<Map<String, Object>> targetSettingsMaps;

    public DeploymentSettingsDiffer(List<Map<String, Object>> sourceSettingsMap, List<Map<String, Object>> targetSettingsMap) {
        this.sourceSettingsMaps = sourceSettingsMap;
        this.targetSettingsMaps = targetSettingsMap;
    }

    public Map<String, Object> getSettingsDiff() {
        LOGGER.info("getSettingsDiff");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("missingSettingsOnTarget", this.evalMissingSettings(this.sourceSettingsMaps, this.targetSettingsMaps));
        result.put("missingSettingsOnSource", this.evalMissingSettings(this.targetSettingsMaps, this.sourceSettingsMaps));
        result.put("modifiedSettings", this.evalModifiedSettings(this.sourceSettingsMaps, this.targetSettingsMaps));
        return result;
    }

    public boolean areSettingsEqual() {
        if (this.sourceSettingsMaps == null && this.targetSettingsMaps == null) {
            return true;
        }
        if (this.sourceSettingsMaps == null || this.targetSettingsMaps == null) {
            return false;
        }
        if (this.sourceSettingsMaps.size() != this.targetSettingsMaps.size()) {
            return false;
        }
        Map<String, Setting> sourceSettings = this.convertMapBasedSettingsToSettingInstances(this.sourceSettingsMaps);
        Map<String, Setting> targetSettings = this.convertMapBasedSettingsToSettingInstances(this.targetSettingsMaps);
        if (!sourceSettings.keySet().equals(targetSettings.keySet())) {
            return false;
        }
        for (String settingName : sourceSettings.keySet()) {
            Setting targetSetting;
            Setting sourceSetting = sourceSettings.get(settingName);
            if (sourceSetting.equals(targetSetting = targetSettings.get(settingName))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private Map<String, Setting> convertMapBasedSettingsToSettingInstances(List<Map<String, Object>> mapSettings) {
        HashMap<String, Setting> result = new HashMap<String, Setting>();
        for (Map<String, Object> mapSetting : mapSettings) {
            Setting setting = SettingFactory.parseMapSetting(mapSetting);
            if (setting == null) continue;
            setting.getCustomFields().clear();
            result.put(setting.getName(), setting);
        }
        return result;
    }

    @NotNull
    private Set<String> evalMissingSettings(List<Map<String, Object>> sourceSettingsMaps, List<Map<String, Object>> targetSettingsMaps) {
        HashSet<String> result = new HashSet<String>();
        for (Map<String, Object> sourceSettingsMap : sourceSettingsMaps) {
            String settingsName = (String)sourceSettingsMap.get("name");
            if (this.getSettingsMapByName(settingsName, targetSettingsMaps) != null) continue;
            result.add(settingsName);
        }
        return result;
    }

    private Map<String, Object> getSettingsMapByName(String settingsName, List<Map<String, Object>> settingsMaps) {
        if (settingsName != null && settingsMaps != null) {
            for (Map<String, Object> settingsMap : settingsMaps) {
                if (!settingsMap.get("name").equals(settingsName)) continue;
                return settingsMap;
            }
        }
        return null;
    }

    @NotNull
    private Set<String> evalModifiedSettings(List<Map<String, Object>> sourceSettingsMaps, List<Map<String, Object>> targetSettingsMaps) {
        HashSet<String> result = new HashSet<String>();
        if (sourceSettingsMaps == null || targetSettingsMaps == null) {
            return result;
        }
        Map<String, Setting> sourceSettings = this.convertMapBasedSettingsToSettingInstances(sourceSettingsMaps);
        Map<String, Setting> targetSettings = this.convertMapBasedSettingsToSettingInstances(targetSettingsMaps);
        for (String settingName : sourceSettings.keySet()) {
            Setting sourceSetting = sourceSettings.get(settingName);
            Setting targetSetting = targetSettings.get(settingName);
            if (sourceSetting == null || targetSetting == null || sourceSetting.equals(targetSetting)) continue;
            result.add(settingName);
        }
        return result;
    }
}

