/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.deployment.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.deployment.DeploymentManager;
import de.virtimo.bpc.api.deployment.DeploymentSide;
import de.virtimo.bpc.api.deployment.exception.DeploymentException;
import de.virtimo.bpc.api.deployment.exception.DeploymentSystemException;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchIndexNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.multipart.MimeMultipartData;
import de.virtimo.bpc.api.multipart.UploadedBundleFile;
import de.virtimo.bpc.api.multipart.UploadedFile;
import de.virtimo.bpc.api.opensearch.IndexInfo;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.SettingFactory;
import de.virtimo.bpc.core.deployment.DeploymentBundlesDiffer;
import de.virtimo.bpc.core.deployment.DeploymentDiffer;
import de.virtimo.bpc.core.deployment.DeploymentIndicesDiffer;
import de.virtimo.bpc.core.deployment.DeploymentInitiatorImpl;
import de.virtimo.bpc.core.deployment.DeploymentSettingsDiffer;
import de.virtimo.bpc.core.deployment.GZipContentUtil;
import de.virtimo.bpc.core.deployment.resource.DeploymentDataImpl;
import de.virtimo.bpc.core.deployment.resource.DeploymentIndexData;
import de.virtimo.bpc.core.deployment.resource.DeploymentIndexInfo;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.license.XmlFileLicense;
import de.virtimo.bpc.core.multipart.UploadedBundleFileImpl;
import de.virtimo.bpc.core.multipart.UploadedFileImpl;
import de.virtimo.bpc.core.opensearch.migration.BpcIndicesMigrator;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.ListUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

@Path(value="deployment")
@Tag(name="Deployment API", description="The deployment functionality allows to transfer configurations of one BPC instance to another.\n")
public class DeploymentEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(DeploymentEndpoint.class);
    public static String JSON_TARGET_ID = "@@@JSON@@@";
    private final BundleContext bundleContext;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<DeploymentManager> deploymentManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker;

    public DeploymentEndpoint(BundleContext bundleContext) {
        LOGGER.info("DeploymentEndpoint bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.deploymentManagerTracker = new BpcServicesTracker<DeploymentManager>(this.bundleContext, DeploymentManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(this.bundleContext, OpenSearchService.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @GET
    @Path(value="/systems")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_GET_SYSTEMS", message="Not allowed to use deployment")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Get a list of all deployment systems (= backend connections of type 'deployment_system').", description="Get a list of all deployment systems (= backend connections of type 'deployment_system').")
    @ReturnDescription(value="The requested data as JSON")
    public Response getDeploymentSystems(@Context HttpHeaders hh) {
        LOGGER.info("getDeploymentSystems");
        try {
            return Response.ok(Map.of("entries", this.deploymentManagerTracker.getService().getDeploymentSystemsInfo())).build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while getting the deployment systems.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private Map<String, Object> createEmptyStatusOfDeploymentSystemForJsonExport() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("allBpcModules", new ArrayList());
        return result;
    }

    private Map<String, Object> createEmptyModulesConfigForJsonExport(Map<String, Object> otherTargetConfig) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (otherTargetConfig == null) {
            result.put("modules", new ArrayList());
        } else {
            List modules = JsonUtil.getInstance().convertJsonStringToPojo(JsonUtil.getInstance().convertPojoToJsonString(otherTargetConfig.get("modules")), List.class);
            for (Map module : modules) {
                List defaultModuleSettings = (List)module.get("defaultConfiguration");
                module.remove("instances");
                module.remove("defaultConfiguration");
                module.remove("instancesDefaultConfiguration");
                module.remove("settings");
                ArrayList<Map<String, Object>> newSettings = new ArrayList<Map<String, Object>>();
                if (defaultModuleSettings != null) {
                    for (Map defaultModuleSettingAsMap : defaultModuleSettings) {
                        Setting defaultModuleSetting = SettingFactory.parseMapSetting(defaultModuleSettingAsMap);
                        defaultModuleSetting.setInstanceId("noinstance");
                        String newModuleSettingAsString = JsonUtil.getInstance().convertPojoToJsonString(defaultModuleSetting);
                        Map<String, Object> newModuleSettingAsMap = JsonUtil.getInstance().jsonStringAsMap(newModuleSettingAsString);
                        newSettings.add(newModuleSettingAsMap);
                    }
                }
                module.put("settings", newSettings);
            }
            result.put("modules", modules);
        }
        return result;
    }

    private Map<String, Object> getMigratedSourceModulesConfigFromDeploymentSystem(DeploymentManager deploymentManager, UserSession userSession, String deploymentSystemId, DeploymentSide deploymentSide, Map<String, Object> modulesConfigToMigrate) throws ModuleNotFoundException, ModuleInstanceNotFoundException, ServiceNotFoundException, DeploymentSystemException, IOException, OpenSearchRelatedException {
        LOGGER.info("getMigratedSourceModulesConfigFromDeploymentSystem deploymentManager=..., userSession=..., deploymentSystemId={}, deploymentSide={}, modulesConfigToMigrate=...", (Object)deploymentSystemId, (Object)deploymentSide);
        Map<String, Object> migratedModulesConfig = deploymentManager.getMigrateModulesConfigFromDeploymentSystem(userSession, deploymentSystemId, deploymentSide, modulesConfigToMigrate);
        return migratedModulesConfig;
    }

    private Map<String, Object> getModulesConfig(DeploymentManager deploymentManager, UserSession userSession, String deploymentSystemId, DeploymentSide deploymentSide, Map<String, Object> deploymentSystemStatus) throws ModuleNotFoundException, ModuleInstanceNotFoundException, DeploymentSystemException, ServiceNotFoundException, IOException {
        LOGGER.info("getModulesConfig deploymentManager=..., userSession=..., deploymentSystemId={}, deploymentSide={}, deploymentSystemStatus={}", (Object)deploymentSystemId, (Object)deploymentSide, deploymentSystemStatus);
        HashMap loadedTargetModules = new HashMap();
        for (Object loadedModuleObject : (List)deploymentSystemStatus.get("loadedModules")) {
            Map loadedModuleEntry = (Map)loadedModuleObject;
            loadedTargetModules.put((String)loadedModuleEntry.get("id"), loadedModuleEntry.get("version"));
        }
        Map<String, Object> targetModulesConfig = deploymentManager.getModuleConfigurationsOfDeploymentSystem(userSession, deploymentSystemId, deploymentSide);
        targetModulesConfig.put("maintenanceModeEnabled", targetModulesConfig.getOrDefault("maintenanceModeEnabled", deploymentSystemStatus.get("maintenanceModeEnabled")));
        targetModulesConfig.put("loadedModules", loadedTargetModules);
        return targetModulesConfig;
    }

    private Map<String, Object> getModulesConfigFromBackup(DeploymentManager deploymentManager, UserSession userSession, String deploymentSystemId, DeploymentSide deploymentSide, Map<String, Object> deploymentSystemStatus, String snapshotName) throws ModuleNotFoundException, ModuleInstanceNotFoundException, DeploymentSystemException, ServiceNotFoundException, IOException {
        LOGGER.info("getModulesConfigFromBackup deploymentManager=..., userSession=..., deploymentSystemId={}, deploymentSide={}, deploymentSystemStatus={}, snapshotName={}", (Object)deploymentSystemId, (Object)deploymentSide, deploymentSystemStatus, (Object)snapshotName);
        HashMap loadedTargetModules = new HashMap();
        for (Object loadedModuleObject : (List)deploymentSystemStatus.get("loadedModules")) {
            Map loadedModuleEntry = (Map)loadedModuleObject;
            loadedTargetModules.put((String)loadedModuleEntry.get("id"), loadedModuleEntry.get("version"));
        }
        Map<String, Object> targetModulesConfig = deploymentManager.getModuleConfigurationsOfDeploymentSystemFromBackup(userSession, deploymentSystemId, deploymentSide, snapshotName);
        targetModulesConfig.put("maintenanceModeEnabled", targetModulesConfig.getOrDefault("maintenanceModeEnabled", deploymentSystemStatus.get("maintenanceModeEnabled")));
        targetModulesConfig.put("loadedModules", loadedTargetModules);
        return targetModulesConfig;
    }

    public static int getModelVersion(Map<String, Object> targetModulesConfig) {
        int modelVersion = -1;
        try {
            Object modelVersionObject;
            Object metadataObject;
            if (targetModulesConfig != null && (metadataObject = targetModulesConfig.get("metadata")) instanceof Map && (modelVersionObject = ((Map)metadataObject).get("modelVersion")) instanceof Number) {
                modelVersion = ((Number)modelVersionObject).intValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modelVersion;
    }

    private boolean checkModelVersionsForMigration(int sourceModelVersion, int targetModelVersion) throws DeploymentSystemException {
        if (sourceModelVersion == -1) {
            throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_MODEL_VERSION_ERROR, DeploymentSide.Source, "CORE_ERROR_DEPLOYMENT_MISSING_MODEL_VERSION");
        }
        if (targetModelVersion == -1) {
            throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_MODEL_VERSION_ERROR, DeploymentSide.Target, "CORE_ERROR_DEPLOYMENT_MISSING_MODEL_VERSION");
        }
        if (sourceModelVersion > targetModelVersion) {
            throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_MODEL_VERSION_ERROR, DeploymentSide.Unknown, "CORE_ERROR_DEPLOYMENT_MODEL_VERSIONS_DIFFER", MapUtil.mapOf("sourceModelVersion", sourceModelVersion, "targetModelVersion", targetModelVersion));
        }
        if (sourceModelVersion < BpcIndicesMigrator.getLowestSupportedModelVersionOfBpcConfigurationIndex()) {
            throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_MODEL_VERSION_ERROR, DeploymentSide.Source, "CORE_ERROR_DEPLOYMENT_MODEL_VERSION_NOT_SUPPORTED", MapUtil.mapOf("sourceModelVersion", sourceModelVersion, "lowestSupportedModelVersion", BpcIndicesMigrator.getLowestSupportedModelVersionOfBpcConfigurationIndex()));
        }
        return sourceModelVersion < targetModelVersion;
    }

    @GET
    @Path(value="/diff")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_GET_DIFF", message="Not allowed to use deployment")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Get the diff of a source deployment system or snapshot and a target deployment system.", description="Get the diff of a source deployment system or snapshot and a target deployment system.")
    @ReturnDescription(value="The requested data as JSON.")
    public Response getDeploymentData(@Parameter(description="the backend connection ID of the source deployment system. Not necessary when `snapshot` is used.") @QueryParam(value="source") String sourceDeploymentSystemId, @Parameter(description="the backend connection ID of the target deployment system") @QueryParam(value="target") String targetDeploymentSystemId, @Parameter(description="name of an OpenSearch snapshot that should be used instead of a source deployment system. Not necessary when `source` is used.") @QueryParam(value="snapshot") String sourceSnapshotName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("getDeploymentData sourceDeploymentSystemId={}, targetDeploymentSystemId={}, sourceSnapshotName={}", (Object)sourceDeploymentSystemId, (Object)targetDeploymentSystemId, (Object)sourceSnapshotName);
        try {
            Map<String, Object> targetModulesConfig;
            Map<String, Object> sourceModulesConfig;
            Map<String, Object> targetStatus;
            Map<String, Object> sourceStatus;
            if (StringUtil.isNullOrEmpty(sourceDeploymentSystemId)) {
                throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, DeploymentSide.Unknown, "Query parameter 'source' must be set.");
            }
            if (StringUtil.isNullOrEmpty(targetDeploymentSystemId)) {
                throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, DeploymentSide.Unknown, "Query parameter 'target' must be set.");
            }
            if (StringUtil.isNullOrEmpty(sourceSnapshotName) && sourceDeploymentSystemId.equals(targetDeploymentSystemId)) {
                throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, DeploymentSide.Unknown, "Query parameters 'source' and 'target' must be different.");
            }
            DeploymentManager deploymentManager = this.deploymentManagerTracker.getService();
            if (!StringUtil.isNullOrEmpty(sourceSnapshotName) && !targetDeploymentSystemId.equals(JSON_TARGET_ID)) {
                sourceStatus = deploymentManager.getStatusOfDeploymentSystem(userSession, sourceDeploymentSystemId, DeploymentSide.Source);
                targetStatus = deploymentManager.getStatusOfDeploymentSystem(userSession, targetDeploymentSystemId, DeploymentSide.Target);
                sourceModulesConfig = this.getModulesConfigFromBackup(deploymentManager, userSession, sourceDeploymentSystemId, DeploymentSide.Source, sourceStatus, sourceSnapshotName);
                targetModulesConfig = this.getModulesConfig(deploymentManager, userSession, targetDeploymentSystemId, DeploymentSide.Target, targetStatus);
                sourceConfigMigrationNecessary = this.checkModelVersionsForMigration(DeploymentEndpoint.getModelVersion(sourceModulesConfig), DeploymentEndpoint.getModelVersion(targetModulesConfig));
                if (sourceConfigMigrationNecessary) {
                    sourceModulesConfig = this.getMigratedSourceModulesConfigFromDeploymentSystem(deploymentManager, userSession, targetDeploymentSystemId, DeploymentSide.Target, sourceModulesConfig);
                }
            } else if (!StringUtil.isNullOrEmpty(sourceSnapshotName) && targetDeploymentSystemId.equals(JSON_TARGET_ID)) {
                sourceStatus = deploymentManager.getStatusOfDeploymentSystem(userSession, sourceDeploymentSystemId, DeploymentSide.Source);
                sourceModulesConfig = this.getModulesConfigFromBackup(deploymentManager, userSession, sourceDeploymentSystemId, DeploymentSide.Source, sourceStatus, sourceSnapshotName);
                sourceConfigMigrationNecessary = this.checkModelVersionsForMigration(DeploymentEndpoint.getModelVersion(sourceModulesConfig), this.moduleManagerTracker.getService().getModelVersionOfBpcConfigurationIndex());
                if (sourceConfigMigrationNecessary) {
                    sourceModulesConfig = this.getMigratedSourceModulesConfigFromDeploymentSystem(deploymentManager, userSession, sourceDeploymentSystemId, DeploymentSide.Source, sourceModulesConfig);
                }
                targetStatus = this.createEmptyStatusOfDeploymentSystemForJsonExport();
                targetModulesConfig = this.createEmptyModulesConfigForJsonExport(sourceModulesConfig);
            } else if (sourceDeploymentSystemId.equals(JSON_TARGET_ID)) {
                sourceStatus = this.createEmptyStatusOfDeploymentSystemForJsonExport();
                targetStatus = deploymentManager.getStatusOfDeploymentSystem(userSession, targetDeploymentSystemId, DeploymentSide.Target);
                targetModulesConfig = this.getModulesConfig(deploymentManager, userSession, targetDeploymentSystemId, DeploymentSide.Target, targetStatus);
                sourceModulesConfig = this.createEmptyModulesConfigForJsonExport(targetModulesConfig);
            } else if (targetDeploymentSystemId.equals(JSON_TARGET_ID)) {
                sourceStatus = deploymentManager.getStatusOfDeploymentSystem(userSession, sourceDeploymentSystemId, DeploymentSide.Source);
                targetStatus = this.createEmptyStatusOfDeploymentSystemForJsonExport();
                sourceModulesConfig = this.getModulesConfig(deploymentManager, userSession, sourceDeploymentSystemId, DeploymentSide.Source, sourceStatus);
                targetModulesConfig = this.createEmptyModulesConfigForJsonExport(sourceModulesConfig);
            } else {
                sourceStatus = deploymentManager.getStatusOfDeploymentSystem(userSession, sourceDeploymentSystemId, DeploymentSide.Source);
                targetStatus = deploymentManager.getStatusOfDeploymentSystem(userSession, targetDeploymentSystemId, DeploymentSide.Target);
                sourceModulesConfig = this.getModulesConfig(deploymentManager, userSession, sourceDeploymentSystemId, DeploymentSide.Source, sourceStatus);
                targetModulesConfig = this.getModulesConfig(deploymentManager, userSession, targetDeploymentSystemId, DeploymentSide.Target, targetStatus);
                sourceConfigMigrationNecessary = this.checkModelVersionsForMigration(DeploymentEndpoint.getModelVersion(sourceModulesConfig), DeploymentEndpoint.getModelVersion(targetModulesConfig));
                if (sourceConfigMigrationNecessary) {
                    sourceModulesConfig = this.getMigratedSourceModulesConfigFromDeploymentSystem(deploymentManager, userSession, targetDeploymentSystemId, DeploymentSide.Target, sourceModulesConfig);
                }
            }
            deploymentManager.enrichModuleConfigurationsWithDeploymentConstraints(sourceModulesConfig);
            DeploymentDiffer differ = new DeploymentDiffer((List)sourceModulesConfig.get("modules"), (List)targetModulesConfig.get("modules"));
            Map<String, Object> bundles = null;
            if (!sourceDeploymentSystemId.equals(JSON_TARGET_ID) && !targetDeploymentSystemId.equals(JSON_TARGET_ID) && StringUtil.isNullOrEmpty(sourceSnapshotName)) {
                DeploymentBundlesDiffer bundlesDiffer = new DeploymentBundlesDiffer(sourceStatus, targetStatus);
                bundles = MapUtil.mapOf("source", bundlesDiffer.getSourceBundles(), "target", bundlesDiffer.getTargetBundles(), "diff", bundlesDiffer.getBundlesDiff());
            }
            Map<String, Object> indices = null;
            if (!sourceDeploymentSystemId.equals(JSON_TARGET_ID) && !targetDeploymentSystemId.equals(JSON_TARGET_ID) && StringUtil.isNullOrEmpty(sourceSnapshotName)) {
                try {
                    Map<String, IndexInfo> sourceIndices = deploymentManager.getOpenSearchIndexInfos(userSession, sourceDeploymentSystemId, DeploymentSide.Source);
                    Map<String, IndexInfo> targetIndices = deploymentManager.getOpenSearchIndexInfos(userSession, targetDeploymentSystemId, DeploymentSide.Target);
                    DeploymentIndicesDiffer indicesDiffer = new DeploymentIndicesDiffer(sourceIndices, targetIndices);
                    indices = MapUtil.mapOf("source", indicesDiffer.getSourceIndices().values(), "target", indicesDiffer.getTargetIndices().values(), "diff", indicesDiffer.getIndicesDiff());
                }
                catch (Exception ex) {
                    LOGGER.warn("Failed to get the OpenSearch indices from the involved deployment systems. Maybe one of them is older and does not support it. Deployment of indices gets disabled.", (Throwable)ex);
                }
            }
            HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
            result.put("source", sourceModulesConfig);
            result.put("target", targetModulesConfig);
            result.put("diff", differ.getModulesDiff());
            if (bundles != null) {
                result.put("bundles", bundles);
            }
            if (indices != null) {
                result.put("indices", indices);
            }
            return Response.ok(result).build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get the module configurations.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/diff/settings")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_GET_SETTINGS_DIFF", message="Not allowed to use deployment")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Get the diff of deployment source and target settings provided in the body content.", description="Get the diff of deployment source and target settings provided in the body content.\n\nBody:\n[source,json]\n----\n{\n   \"source\": [ BPC settings, ... ],\n   \"target\": [ BPC settings, ... ]\n}\n----\n")
    @ReturnDescription(value="The diff as JSON")
    public Response getSettingsDiff(Map<String, Object> sourceAndTargetSettings, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("getSettingsDiff");
        try {
            List sourceSettings = (List)sourceAndTargetSettings.get("source");
            List targetSettings = (List)sourceAndTargetSettings.get("target");
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("source", sourceSettings);
            result.put("target", targetSettings);
            DeploymentSettingsDiffer differ = new DeploymentSettingsDiffer(sourceSettings, targetSettings);
            if (!differ.areSettingsEqual()) {
                result.put("diff", differ.getSettingsDiff());
            } else {
                result.put("diff", new HashMap());
            }
            return Response.ok(result).build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while creating the settings diff.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/deploy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_EXECUTE", message="Not allowed to use deployment")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Deploys the body content to the target system.", description="Deploys the body content to the target system.")
    @ReturnDescription(value="The deployment processing instructions as JSON file to download when the `deploymentTargetId` is set to `@@@JSON@@@`, otherwise the deployment response.")
    public Response deploy(@Parameter(description="the backend connection ID of the deployment source system") @QueryParam(value="deploymentSourceId") String sourceDeploymentSystemId, @Parameter(description="the backend connection ID of the deployment target system") @QueryParam(value="deploymentTargetId") String targetDeploymentSystemId, @Parameter(description="`true` in case the maintenance mode should be enabled on the target system, `false` if not") @QueryParam(value="enableMaintenanceMode") @DefaultValue(value="false") boolean enableMaintenanceMode, @Parameter(description="`true` in case the standard settings validation should be performed on the target system, `false` if it should be skipped") @QueryParam(value="validate") @DefaultValue(value="true") boolean validate, DeploymentDataImpl deploymentData, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("deploy sourceDeploymentSystemId={}, targetDeploymentSystemId={}, enabledMaintenanceMode={}, validate={}", (Object)sourceDeploymentSystemId, (Object)targetDeploymentSystemId, (Object)enableMaintenanceMode, (Object)validate);
        try {
            if (JSON_TARGET_ID.equals(targetDeploymentSystemId)) {
                return Response.ok((Object)deploymentData, (javax.ws.rs.core.MediaType)javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE).header("Content-Disposition", (Object)"attachment; filename=bpcDeployment.json").build();
            }
            Map<String, Object> targetResponse = this.deploymentManagerTracker.getService().deploy(userSession, sourceDeploymentSystemId, targetDeploymentSystemId, deploymentData, enableMaintenanceMode, validate);
            return Response.ok(targetResponse).build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception during deployment.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/import")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_EXECUTE", message="Not allowed to use deployment")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Import done")})
    @OperationDescription(summary="Processes the deployment instructions provided by the body content.", description="Processes the deployment instructions provided by the body content.")
    public Response importDeployment(@Parameter(description="`true` in case the maintenance mode should be enabled, `false` if not") @QueryParam(value="enableMaintenanceMode") @DefaultValue(value="false") boolean enableMaintenanceMode, @Parameter(description="`true` in case the standard settings validation should be performed, `false` if it should be skipped") @QueryParam(value="validate") @DefaultValue(value="true") boolean validate, DeploymentDataImpl deploymentData, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("importDeployment enableMaintenanceMode={}, validate={}", (Object)enableMaintenanceMode, (Object)validate);
        try {
            this.deploymentManagerTracker.getService().importDeployment(userSession, new DeploymentInitiatorImpl(hh), deploymentData, enableMaintenanceMode, validate);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while importing a deployment.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/bundles/download")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_EXECUTE", message="Not allowed to use deployment")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Download specific bundles (JAR/WAR files).", description="To download specific bundles (JAR/WAR files) by their IDs as mime multipart data.\n\nBody:\n[source,json]\n----\n[ IdOfBundle1, IdOfBundle2, ... ]\n----\n")
    @ReturnDescription(value="The bundles as mime multipart data")
    public Response downloadBundles(List<Number> bundleIDs, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("downloadBundles bundleIDs={}", bundleIDs);
        try {
            ArrayList<Long> convertedBundleIDs = new ArrayList<Long>();
            for (Number bundleID : bundleIDs) {
                long bundleId = bundleID.longValue();
                if (convertedBundleIDs.contains(bundleId)) continue;
                convertedBundleIDs.add(bundleId);
            }
            MimeMultipartData bundlesAsMultipartData = this.deploymentManagerTracker.getService().getBundlesAsMultipartData(convertedBundleIDs);
            return Response.ok((Object)bundlesAsMultipartData).build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while importing a deployment.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/bundles/download/{bundleId}")
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_EXECUTE", message="Not allowed to use deployment")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Bundle was not found"), @ApiResponse(responseCode="500", description="Bundle is not downloadable")})
    @OperationDescription(summary="To download a specific bundle (JAR/WAR files) by its ID.", description="To download a specific bundle (JAR/WAR files) by its ID.")
    @ReturnDescription(value="The bundle as data stream")
    public Response downloadBundle(@Parameter(description="the ID of the bundle to download") @PathParam(value="bundleId") String bundleId, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("downloadBundle bundleId={}", (Object)bundleId);
        try {
            Bundle bundle = null;
            try {
                bundle = this.bundleContext.getBundle(Long.parseLong(bundleId));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bundle != null) {
                String bundleFileLocation = bundle.getLocation();
                if (bundleFileLocation.startsWith("file:")) {
                    URI bundleFileURI = new URI(bundleFileLocation);
                    String bundleFileName = Paths.get(bundleFileURI).getFileName().toString();
                    final File bundleFile = new File(bundleFileURI);
                    String bundleFileContentType = Files.probeContentType(bundleFile.toPath());
                    if (bundleFileContentType == null) {
                        bundleFileContentType = "application/java-archive";
                    }
                    StreamingOutput bundleFileOutputStream = new StreamingOutput(){

                        public void write(OutputStream output) throws IOException, WebApplicationException {
                            try (FileInputStream input = new FileInputStream(bundleFile);){
                                IOUtils.copy((InputStream)input, (OutputStream)output);
                                output.flush();
                            }
                            catch (Exception ex) {
                                throw new WebApplicationException("Bundle download/streaming failed.", (Throwable)ex);
                            }
                        }
                    };
                    return Response.ok((Object)bundleFileOutputStream, (String)bundleFileContentType).header("Content-Disposition", (Object)("attachment; filename=\"" + bundleFileName + "\"")).build();
                }
                throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_BUNDLE_NOT_DOWNLOADABLE, "The bundle with the ID '{bundleId}' cannot be downloaded, it uses an unknown location prefix (expecting 'file:'): {bundleFileLocation}", Map.of("bundleId", bundleId, "bundleFileLocation", bundleFileLocation));
            }
            throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_BUNDLE_NOT_FOUND, "The bundle with the ID '{bundleId}' does not exist.", Map.of("bundleId", bundleId));
        }
        catch (Exception ex) {
            LOGGER.error("Exception while downloading bundle content.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/bundles/import")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_EXECUTE", message="Not allowed to use deployment")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Bundles import done")})
    @OperationDescription(summary="Imports uploaded bundles.", description="Imports the bundles provided by multipart form data.\n\n.curl example\n[source]\n----\ncurl -X POST \\\n      -H 'X-APIKey: aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee' \\\n      -H 'X-InitiatedByUser: inubit' \\\n      -H 'X-InitiatedFromServerName: localhost' \\\n      -H 'X-InitiatedFromServerUUID: inubit-installer' \\\n      -F file=@test.jar \\\n      -F file=@test.war \\\n      'http://localhost:8181/cxf/bpc-deployment/deployment/bundles/import'\n----\n")
    public Response importBundles(List<Attachment> attachments, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("importBundles attachments={}", attachments);
        try {
            this.deploymentManagerTracker.getService().importBundles(userSession, new DeploymentInitiatorImpl(hh), this.asListOfUploadedBundleFiles(attachments));
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while importing bundle files.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private List<UploadedBundleFile> asListOfUploadedBundleFiles(List<Attachment> attachments) throws IOException {
        if (attachments == null) {
            return null;
        }
        ArrayList<UploadedBundleFile> uploadedBundleFiles = new ArrayList<UploadedBundleFile>();
        for (Attachment attachment : attachments) {
            uploadedBundleFiles.add(new UploadedBundleFileImpl(attachment));
        }
        return uploadedBundleFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/bundles/import/extjs")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_EXECUTE", message="Not allowed to use deployment")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Upload not possible")})
    @OperationDescription(summary="Special endpoint to import a single bundle from ExtJS by using multipart form data.", description="Special endpoint to import a single bundle from ExtJS by using multipart form data.")
    @ReturnDescription(value="ExtJS conform status info with the filename")
    public Response importBundlesOrLicenseFileFromExtJs(List<Attachment> attachments, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("importBundlesOrLicenseFileFromExtJs attachments={}", attachments);
        UploadedFile uploadedFile = null;
        String expectedUploadFieldName = "module_bundle";
        try {
            if (attachments == null || attachments.size() != 1) {
                throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_FILE_NOT_UPLOADABLE, "Module bundle or 'license.xml.bpc'/'license.xml.virtimo' upload with no or multiple attachments is not possible.");
            }
            uploadedFile = new UploadedFileImpl(attachments.get(0));
            LOGGER.info("Uploaded attachment name:{}, filename:{}, content-type:{}", (Object)uploadedFile.getAttachmentName(), (Object)uploadedFile.getFileName(), (Object)uploadedFile.getContentType());
            if (!expectedUploadFieldName.equals(uploadedFile.getAttachmentName())) {
                throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_FILE_NOT_UPLOADABLE, "Invalid file upload. Attachment name is '" + uploadedFile.getAttachmentName() + "' and not '" + expectedUploadFieldName + "'.");
            }
            if (XmlFileLicense.isWellKnownLicenseFilename(uploadedFile.getFileName())) {
                this.deploymentManagerTracker.getService().importXmlFileLicense(userSession, new DeploymentInitiatorImpl(hh), uploadedFile);
            } else if (SetUtil.setOf("jar", "war", "kar").contains(uploadedFile.getFileExtension().toLowerCase())) {
                this.deploymentManagerTracker.getService().importBundles(userSession, new DeploymentInitiatorImpl(hh), ListUtil.listOf(new UploadedBundleFileImpl(uploadedFile)));
            } else {
                throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_FILE_NOT_UPLOADABLE, "Invalid module bundle or license file upload. Only jar/war/kar and 'license.xml.bpc'/'license.xml.virtimo' files can be uploaded.");
            }
            Response response = this.extJsFormSuccessResponse(uploadedFile.getFileName());
            return response;
        }
        catch (Exception ex) {
            LOGGER.error("Exception while importing module bundle or license file.", (Throwable)ex);
            Response response = this.extJsFormErrorResponse(expectedUploadFieldName, ex.getLocalizedMessage());
            return response;
        }
        finally {
            if (uploadedFile != null) {
                uploadedFile.cleanUp();
            }
        }
    }

    private Response extJsFormSuccessResponse(String filename) {
        HashMap<String, Object> successResp = new HashMap<String, Object>();
        successResp.put("success", true);
        successResp.put("file", filename);
        return Response.ok(successResp).build();
    }

    public Response extJsFormErrorResponse(String uploadFieldName, String errorMessage) {
        return Response.ok(MapUtil.mapOf("success", false, "msg", errorMessage)).build();
    }

    @POST
    @Path(value="/migrate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_GET_MIGRATED_MODULES_CONFIG", message="Not allowed to use deployment")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Converts the provided model configurations to the model version of this installation.", description="Deployment diffs can only be done when both systems use the same model version. This endpoint\nconverts the model configurations provided in the content body to the model version of this\ninstallation.\n")
    @ReturnDescription(value="The migrated module configurations as JSON")
    public Response migrateModulesConfig(@Context UserSession userSession, @Context HttpHeaders hh, Map<String, Object> modulesConfig) {
        LOGGER.info("migrateModulesConfig");
        try {
            Map<String, Object> migratedModulesConfig = this.deploymentManagerTracker.getService().migrateModulesConfig(userSession, new DeploymentInitiatorImpl(hh), modulesConfig);
            return Response.ok(migratedModulesConfig).build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while migrating a modules config for deployment.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/index/{index}/copy")
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_COPY_INDEX", message="Not allowed to use deployment")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Copy an index from one deployment system to another.", description="Copy an index from one deployment system to another.")
    public Response copyIndex(@Parameter(description="the name of the index to copy") @PathParam(value="index") String indexName, @Parameter(description="the backend connection ID of the deployment source system") @QueryParam(value="source") String sourceDeploymentSystemId, @Parameter(description="the backend connection ID of the deployment target system") @QueryParam(value="target") String targetDeploymentSystemId, @Parameter(description="the block size used to read that number of documents from the source system at once (set too high = out of memory; too low = bad performance)") @QueryParam(value="blocksize") @DefaultValue(value="2500") int blockSize, @Parameter(description="true to delete an existing index on the target system, false to fail if an index exists already") @QueryParam(value="deleteOnTarget") @DefaultValue(value="false") boolean deleteIndexOnTarget, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("copyIndex indexName={}, sourceDeploymentSystemId={}, targetDeploymentSystemId={}, deleteIndexOnTarget={}", (Object)indexName, (Object)sourceDeploymentSystemId, (Object)targetDeploymentSystemId, (Object)deleteIndexOnTarget);
        try {
            this.deploymentManagerTracker.getService().copyIndex(userSession, indexName, sourceDeploymentSystemId, targetDeploymentSystemId, blockSize, deleteIndexOnTarget);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while copying an index from one deployment system to another.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/indices")
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_LIST_INDICES", message="Not allowed to use deployment")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Get a list of OpenSearch indices.", description="Get a list of OpenSearch indices.")
    @ReturnDescription(value="the index infos")
    public Response getIndexInfos(@Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("getIndexInfos");
        try {
            Map<String, IndexInfo> indexInfos = this.openSearchServiceTracker.getService().getIndexInfos();
            return Response.ok(indexInfos).build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while getting the list of indices.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/index/{index}/info")
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_DOWNLOAD_INDEX", message="Not allowed to use deployment")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Get some infos of an index to deploy.", description="Get some infos of an index to deploy.")
    @ReturnDescription(value="the index info with its settings and mapping")
    public Response getIndexInfo(@Parameter(description="the real name of the index, no alias allowed") @PathParam(value="index") String indexName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("getIndexInfo indexName={}", (Object)indexName);
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            if (!oss.existsIndex(indexName)) {
                throw new OpenSearchIndexNotFoundException(indexName);
            }
            if (!oss.getIndexNamesWithAlias(indexName).isEmpty()) {
                throw new OpenSearchRelatedException((ErrorCode)BpcErrorCode.OPENSEARCH_EXCEPTION, "Please provide an index name instead of an alias: {alias}", MapUtil.mapOf("alias", indexName));
            }
            DeploymentIndexInfo indexInfo = new DeploymentIndexInfo(indexName, oss.getAliasesForIndexName(indexName), oss.getSettings(indexName), oss.getMapping(indexName));
            return Response.ok((Object)indexInfo).build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while fetching info of an OpenSearch index.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/index/{index}/download")
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_DOWNLOAD_INDEX", message="Not allowed to use deployment")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Downloads the first block of data from the given index.", description="Downloads the first block of data from the given index.")
    @ReturnDescription(value="the requested data")
    public Response downloadFirstIndexBlock(@Parameter(description="the name of the index") @PathParam(value="index") String indexName, @Parameter(description="the block size") @QueryParam(value="blocksize") @DefaultValue(value="2500") int blockSize, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("downloadFirstIndexBlock indexName={}, blockSize={}", (Object)indexName, (Object)blockSize);
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            SearchRequest searchReq = new SearchRequest().indices(indexName).scroll(new TimeValue(60000L)).source(new SearchSourceBuilder().size(blockSize).query(QueryBuilders.matchAllQuery()));
            SearchResponse searchResponse = oss.getClient().search(searchReq, RequestOptions.DEFAULT);
            DeploymentIndexData indexData = new DeploymentIndexData(indexName, searchResponse.getScrollId(), this.extractData(searchResponse));
            return Response.ok((Object)indexData).build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while downloading the first block of an OpenSearch index.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/index/{index}/download/{scrollid}")
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_DOWNLOAD_INDEX", message="Not allowed to use deployment")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Downloads the subsequent block of data from the given index.", description="Downloads the subsequent block of data from the given index.")
    @ReturnDescription(value="the requested data")
    public Response downloadSubsequentIndexBlock(@Parameter(description="the name of the index") @PathParam(value="index") String indexName, @Parameter(description="the scroll identifier") @PathParam(value="scrollid") String scrollId, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("downloadSubsequentIndexBlock indexName={}, scrollId={}", (Object)indexName, (Object)scrollId);
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            SearchResponse searchResponse = oss.getClient().scroll(new SearchScrollRequest(scrollId).scroll(new TimeValue(600000L)), RequestOptions.DEFAULT);
            DeploymentIndexData indexData = new DeploymentIndexData(indexName, searchResponse.getScrollId(), this.extractData(searchResponse));
            return Response.ok((Object)indexData).build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while downloading the subsequent content of an OpenSearch index.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    List<Map<String, Object>> extractData(SearchResponse searchResponse) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (searchResponse != null) {
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                result.add(Map.of("id", hit.getId(), "source", hit.getSourceAsMap()));
            }
        }
        return result;
    }

    @DELETE
    @Path(value="/index/{index}/download/{scrollid}")
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_DOWNLOAD_INDEX", message="Not allowed to use deployment")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="To release a no longer used scroll identifier.", description="To release a no longer used scroll identifier. This helps OpenSearch to release resources much faster.")
    public Response releaseScrollId(@Parameter(description="the index name") @PathParam(value="index") String indexName, @Parameter(description="the scroll identifier to release") @PathParam(value="scrollid") String scrollId, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("releaseScrollId indexName={}, scrollId={}", (Object)indexName, (Object)scrollId);
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            oss.releaseScrollId(scrollId);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while releasing the scroll identifier of an index download.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/index/{index}/prepare")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_UPLOAD_INDEX", message="Not allowed to use deployment")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Prepares an index for upload.", description="Prepares an index for upload. Creates it with the given settings and mapping.\n\nBody:\n[source,json]\n----\n{\n   \"settings\": settings as JSON object,\n   \"mapping\": mapping as JSON object\n}\n----\n")
    public Response prepareIndexForUpload(@Parameter(description="the name of the index (must be an alias)") @PathParam(value="index") String indexName, @Parameter(description="true to delete an existing index, false to throw an error when it exists already") @QueryParam(value="delete_existing") @DefaultValue(value="false") boolean deleteExistingIndex, @Context UserSession userSession, @Context HttpHeaders hh, byte[] postBodyInBytes) {
        LOGGER.info("prepareIndexForUpload indexName={}", (Object)indexName);
        try {
            String postBodyAsString = GZipContentUtil.getContentAsString(postBodyInBytes, hh);
            Map<String, Object> indexInfo = JsonUtil.getInstance().jsonStringAsMap(postBodyAsString);
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            if (indexInfo == null || !indexInfo.containsKey("settings") || !indexInfo.containsKey("mapping")) {
                throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_DATA_MISSING, "Index preparation failed. Data is missing or invalid.");
            }
            if (!(indexInfo.get("settings") instanceof Map)) {
                throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_DATA_MISSING, "Index preparation failed. Data is invalid.");
            }
            if (!(indexInfo.get("mapping") instanceof Map)) {
                throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_DATA_MISSING, "Index preparation failed. Data is invalid.");
            }
            if (deleteExistingIndex) {
                if (oss.existsIndex(indexName)) {
                    Set<String> indexNames = oss.getIndexNamesWithAlias(indexName);
                    for (String name : indexNames) {
                        oss.deleteIndex(name);
                    }
                }
            } else if (oss.existsIndex(indexName)) {
                throw new OpenSearchRelatedException((ErrorCode)BpcErrorCode.OPENSEARCH_EXCEPTION, "Index exists already: {index}", MapUtil.mapOf("index", indexName));
            }
            Map settings = (Map)indexInfo.get("settings");
            Map mapping = (Map)indexInfo.get("mapping");
            oss.createIndex(indexName, settings, mapping);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while preparing the index for upload.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/index/{index}/upload")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_UPLOAD_INDEX", message="Not allowed to use deployment")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Feed an index with the uploaded data.", description="Feed an index with the uploaded data.\n\nBody:\n[source,json]\n----\n[\n   {\"id\": document id 1, \"source\": JSON data 1},\n   {\"id\": document id 2, \"source\": JSON data 2},\n   ...\n]\n----\n")
    public Response uploadIndexData(@Parameter(description="the name of the index (must be an alias)") @PathParam(value="index") String indexName, @Context UserSession userSession, @Context HttpHeaders hh, byte[] postBodyInBytes) {
        LOGGER.info("uploadIndexData indexName={}, dataEntries=...", (Object)indexName);
        try {
            String postBodyAsString = GZipContentUtil.getContentAsString(postBodyInBytes, hh);
            List dataEntries = JsonUtil.getInstance().jsonStringAsList(postBodyAsString);
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            if (!oss.existsIndex(indexName)) {
                throw new OpenSearchRelatedException((ErrorCode)BpcErrorCode.OPENSEARCH_EXCEPTION, "Upload failed. The index '{index}' does not exist.", MapUtil.mapOf("index", indexName));
            }
            Set<String> indexNamesForAlias = oss.getIndexNamesWithAlias(indexName);
            if (indexNamesForAlias.size() == 0) {
                throw new OpenSearchRelatedException((ErrorCode)BpcErrorCode.OPENSEARCH_EXCEPTION, "Upload failed. Please provide an alias instead of an real index name: {index}", MapUtil.mapOf("index", indexName));
            }
            if (indexNamesForAlias.size() > 1) {
                throw new OpenSearchRelatedException((ErrorCode)BpcErrorCode.OPENSEARCH_EXCEPTION, "Upload failed. Please be sure that the alias '{alias}' is assigned to one index only.", MapUtil.mapOf("alias", indexName));
            }
            if (dataEntries != null && dataEntries.size() > 0) {
                BulkResponse bulkResponse;
                BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
                for (Map dataEntry : dataEntries) {
                    String id = (String)dataEntry.get("id");
                    Map source = (Map)dataEntry.get("source");
                    bulkRequest.add(new IndexRequest(indexName).id(id).source(source, (MediaType)XContentType.JSON));
                }
                if (bulkRequest.numberOfActions() > 0 && (bulkResponse = oss.getClient().bulk(bulkRequest, RequestOptions.DEFAULT)).hasFailures()) {
                    throw new OpenSearchRelatedException((ErrorCode)BpcErrorCode.OPENSEARCH_EXCEPTION, "Indexing of uploaded data failed: ${error}", MapUtil.mapOf("error", bulkResponse.buildFailureMessage()));
                }
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while uploading index data.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

