/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.event.resource;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=false)
public class EventData {
    private static final String TOPIC_SUFFIX = "de/virtimo/bpc/core/eventService/externalEvent/";
    @JsonProperty(value="topic")
    private String topic;
    @JsonProperty(value="data")
    private Map<String, Object> data;
    @JsonProperty(value="recipients")
    private Map<String, Object> recipients;

    @JsonIgnore
    public boolean hasData() {
        return this.data != null && !this.data.isEmpty();
    }

    @JsonIgnore
    public String getEventTopic() {
        if (this.topic != null && !this.topic.trim().isEmpty()) {
            return TOPIC_SUFFIX + this.topic;
        }
        return this.topic;
    }

    @JsonIgnore
    public Map<String, Object> getEventProperties() {
        HashMap<String, Object> eventProperties = new HashMap<String, Object>();
        eventProperties.put("data", this.data);
        if (this.recipients != null) {
            eventProperties.put("_websocketRecipients", this.recipients);
        }
        return eventProperties;
    }
}

