/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.event.resource;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.event.resource.EventData;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="event")
@Tag(name="Event API", description="BPC has an event system to inform clients of certain events to trigger corresponding actions.\nThis API allows to post events that can be received by targeted BPC users.\n")
public class EventEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(EventEndpoint.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<EventManager> eventManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public EventEndpoint(BundleContext bundleContext) {
        LOGGER.info("EventEndpoint bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(this.bundleContext, EventManager.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @OperationDescription(summary="Sends a new event.", description="To send a new event, send a JSON message with the following structure:\n\n[source,json]\n----\n{\n     \"topic\": \"exampleTopic\",\n     \"data\": {\n         \"key1\": \"value1\",\n         \"key2\": \"value2\"\n     },\n     \"recipients\": {\n         \"users\": [ ... ],\n         \"roles\": [ \"bpcadmin\" ],\n         \"organizations\": [ \"virtimo\" ]\n     }\n}\n----\n\n**Fields**\n\n`topic` (required) :: The topic of the event.\n`data` (required) :: The data of the event.\n`recipients` (optional) :: The recipients of the event. Users, roles, or organizations can be specified.\n")
    @Consumes(value={"application/json"})
    @POST
    @Path(value="/")
    @BpcRoleOrRightRequired(role="EVENT_API_ADMIN", right="EVENT_API_SEND", message="Not allowed to send event")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="403", description="No access rights"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response processEvent(EventData eventData, @Context HttpHeaders hh) {
        LOGGER.info("processEvent");
        try {
            if (!eventData.hasData()) {
                throw new IllegalArgumentException("data empty");
            }
            this.eventManagerTracker.getService().fireEvent(eventData.getEventTopic(), eventData.getEventProperties());
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to fire the event", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

