/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.filestorage;

import com.fasterxml.jackson.databind.JsonNode;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.filestorage.FileStorageConfiguration;
import de.virtimo.bpc.api.filestorage.exception.enums.FileStorageTypes;
import de.virtimo.bpc.core.opensearch.ModuleConfigurationImpl;
import de.virtimo.bpc.module.simple.SimpleModuleConfig;
import de.virtimo.bpc.util.JsonUtil;
import java.util.Map;

public class FileStorageConfigurationImpl
implements FileStorageConfiguration {
    private final ModuleConfiguration moduleConfiguration;

    public FileStorageConfigurationImpl(Map<String, Setting> settings) {
        this.moduleConfiguration = new SimpleModuleConfig(settings);
    }

    public FileStorageConfigurationImpl(ModuleConfiguration moduleConfiguration) {
        this.moduleConfiguration = moduleConfiguration;
    }

    public String getInstanceId() {
        if (this.moduleConfiguration instanceof ModuleConfigurationImpl) {
            return ((ModuleConfigurationImpl)this.moduleConfiguration).getInstanceId();
        }
        return null;
    }

    public ModuleConfiguration getModuleConfiguration() {
        return this.moduleConfiguration;
    }

    @Override
    public String getStorageType() {
        return this.moduleConfiguration.getSettingValue("fileStorageType").asString("");
    }

    @Override
    public FileStorageTypes getStorageTypeEnum() {
        return switch (this.getStorageType()) {
            case "s3" -> FileStorageTypes.AWS_S3;
            case "azureBlobStorage" -> FileStorageTypes.AZURE_BLOB_STORAGE;
            case "googleCloudStorage" -> FileStorageTypes.GOOGLE_GLOUD_STORAGE;
            default -> FileStorageTypes.UNKNOWN;
        };
    }

    @Override
    public String getAwsEndpointUrl() {
        return this.moduleConfiguration.getSettingValue("fileStorageAwsEndpointUrl").asString("");
    }

    @Override
    public String getAwsRegion() {
        return this.moduleConfiguration.getSettingValue("fileStorageAwsCloudRegion").asString("");
    }

    @Override
    public String getAwsCredentialsKey() {
        return this.moduleConfiguration.getSettingValue("fileStorageAwsCredentialsKey").asString("");
    }

    @Override
    public String getAwsCredentialsSecret() {
        return this.moduleConfiguration.getSettingValue("fileStorageAwsCredentialsSecret").asString("");
    }

    @Override
    public String getAzureEndpointUrl() {
        return this.moduleConfiguration.getSettingValue("fileStorageAzureEndpointUrl").asString("");
    }

    @Override
    public String getAzureAccountName() {
        return this.moduleConfiguration.getSettingValue("fileStorageAzureAccountName").asString("");
    }

    @Override
    public String getAzureAccountKey() {
        return this.moduleConfiguration.getSettingValue("fileStorageAzureAccountKey").asString("");
    }

    @Override
    public String getGoogleCloudProjectId() {
        return this.moduleConfiguration.getSettingValue("fileStorageGoogleCloudProjectId").asString("");
    }

    @Override
    public String getGoogleCloudServiceAccountJson() {
        Map serviceAccountMap = this.moduleConfiguration.getSettingValue("fileStorageGoogleCloudServiceAccountJson").asMap();
        JsonNode jsonNode = JsonUtil.getInstance().convertMapToJsonNode(serviceAccountMap);
        return jsonNode.toString();
    }
}

