/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.filestorage;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ItemRestriction;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchIndexMappingNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchIndexNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.filestorage.FileStorageService;
import de.virtimo.bpc.api.filestorage.FileStoreItem;
import de.virtimo.bpc.api.filestorage.FileStoreItemPutDto;
import de.virtimo.bpc.api.filestorage.FileStoreItems;
import de.virtimo.bpc.api.filestorage.ObjectStoreReference;
import de.virtimo.bpc.api.filestorage.clients.ObjectStorageClient;
import de.virtimo.bpc.api.filestorage.clients.ObjectStorageClientFactoryService;
import de.virtimo.bpc.api.filestorage.exception.FileStorageIndexPreparationException;
import de.virtimo.bpc.api.filestorage.exception.FileStoreBadSortQueryException;
import de.virtimo.bpc.api.filestorage.exception.FileStoreConnectionCloseException;
import de.virtimo.bpc.api.filestorage.exception.FileStoreConnectionException;
import de.virtimo.bpc.api.filestorage.exception.FileStoreItemExistsException;
import de.virtimo.bpc.api.filestorage.exception.FileStoreItemNotFoundException;
import de.virtimo.bpc.api.filestorage.exception.FileStoreItemRightsException;
import de.virtimo.bpc.api.filestorage.exception.enums.FileStorageOperation;
import de.virtimo.bpc.api.multipart.UploadedFile;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.api.storage.exception.StoreItemJsonException;
import de.virtimo.bpc.backendconnections.BackendConnectionsModule;
import de.virtimo.bpc.core.filestorage.FileStorageConfigurationImpl;
import de.virtimo.bpc.core.filestorage.FileStoragePersistenceHandler;
import de.virtimo.bpc.core.filestorage.FileStoreItemFactory;
import de.virtimo.bpc.util.UUIDGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.zip.CRC32;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;

public class FileStorageServiceImpl
implements BpcService,
FileStorageService {
    private static final Logger LOGGER = LogManager.getLogger(FileStorageServiceImpl.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker = null;
    private BpcServicesTracker<ObjectStorageClientFactoryService> objectStorageClientFactoryServiceTracker;
    private final int PRESIGN_URL_VALIDITY_MINUTES = 5;

    public FileStorageServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        if (bundleContext != null) {
            this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
            this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
            this.objectStorageClientFactoryServiceTracker = new BpcServicesTracker<ObjectStorageClientFactoryService>(bundleContext, ObjectStorageClientFactoryService.class);
        } else {
            LOGGER.warn("BundleContext is null? Hopefully this is just an integration test.");
        }
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public OpenSearchService getOpenSearchService() throws ServiceNotFoundException {
        return this.openSearchServiceTracker.getService();
    }

    @Override
    public FileStoreItems getItems(Integer start, Integer limit, String backendConnectionId, String bucket, String sort, @NotNull UserSession userSession) throws ServiceNotFoundException, OpenSearchIndexNotFoundException, OpenSearchRelatedException, OpenSearchIndexMappingNotFoundException, FileStorageIndexPreparationException, FileStoreBadSortQueryException {
        LOGGER.info("getItems start={}, limit={}, backendConnectionId={}, bucket={}, userSession=...", (Object)start, (Object)limit, (Object)backendConnectionId, (Object)bucket);
        if (start == null || start < 0) {
            start = 0;
            LOGGER.debug("No 'start' parameter given or out of range. Set start to {}", (Object)start);
        }
        if (limit == null || limit < 0 || limit > 10000) {
            limit = 10000;
            LOGGER.debug("No 'limit' parameter given or out of range. Set limit to {}", (Object)limit);
        }
        FileStoragePersistenceHandler persistenceHandler = new FileStoragePersistenceHandler(this.getOpenSearchService());
        return persistenceHandler.loadFileStoreItems(start, limit, backendConnectionId, bucket, sort, userSession);
    }

    @Override
    public FileStoreItem getItem(String itemId, UserSession userSession) throws ServiceNotFoundException, OpenSearchRelatedException, OpenSearchIndexNotFoundException, FileStoreItemNotFoundException, FileStoreItemRightsException, FileStorageIndexPreparationException {
        LOGGER.info("getItem itemId={}, userSession=...", (Object)itemId);
        FileStoragePersistenceHandler persistenceHandler = new FileStoragePersistenceHandler(this.getOpenSearchService());
        FileStoreItem storeItem = persistenceHandler.loadFileStoreItem(itemId);
        if (!storeItem.isReadableBy(userSession)) {
            throw new FileStoreItemRightsException(itemId);
        }
        return storeItem;
    }

    @Override
    public URL getPresignedDownloadUrl(String itemId, UserSession userSession) throws OpenSearchIndexNotFoundException, OpenSearchRelatedException, FileStorageIndexPreparationException, FileStoreItemNotFoundException, ServiceNotFoundException, FileStoreItemRightsException, ModuleNotFoundException, ModuleInstanceNotFoundException, FileStoreConnectionException {
        LOGGER.info("getPresignedDownloadUrl itemId={}, userSession=...", (Object)itemId);
        FileStoragePersistenceHandler persistenceHandler = new FileStoragePersistenceHandler(this.getOpenSearchService());
        FileStoreItem storeItem = persistenceHandler.loadFileStoreItem(itemId);
        if (!storeItem.isReadableBy(userSession)) {
            throw new FileStoreItemRightsException(itemId);
        }
        ObjectStoreReference objectStoreReference = storeItem.getObjectStoreReference();
        FileStorageConfigurationImpl storageConnectionConfig = this.getFileStorageConnectionConfig(objectStoreReference.backendConnectionId());
        URL presignedUrl = null;
        ObjectStorageClientFactoryService objectStorageFactoryService = this.objectStorageClientFactoryServiceTracker.getService();
        try (ObjectStorageClient objectStorageClient = objectStorageFactoryService.getObjectStorageClient(storageConnectionConfig);){
            presignedUrl = objectStorageClient.getPresignedDownloadURL(storeItem, 5);
        }
        catch (FileStoreConnectionCloseException e) {
            if (presignedUrl == null) {
                throw new FileStoreConnectionException(e, storageConnectionConfig.getStorageTypeEnum(), FileStorageOperation.GET_PRESIGNED_URL);
            }
            LOGGER.warn("Failed to close file store connection.", (Throwable)e);
        }
        catch (FileStoreConnectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FileStoreConnectionException(e, storageConnectionConfig.getStorageTypeEnum(), FileStorageOperation.GET_PRESIGNED_URL);
        }
        return presignedUrl;
    }

    @Override
    public FileStoreItem createItem(UploadedFile file, String bucket, String backendConnectionId, ItemRestriction readRestriction, ItemRestriction writeRestriction, String creatorServiceId, UserSession userSession, boolean performUserRestrictionChecks) throws SystemException {
        LOGGER.info("createItem file={}, bucket={}, backendConnectionId={}, readRestriction=..., writeRestriction=..., userSession=...", (Object)file.getFileName(), (Object)bucket, (Object)backendConnectionId);
        FileStoragePersistenceHandler persistenceHandler = new FileStoragePersistenceHandler(this.getOpenSearchService());
        String itemId = UUIDGenerator.randomUUID();
        try {
            FileStoreItem existingStoreItem = persistenceHandler.loadFileStoreItem(itemId);
            if (existingStoreItem != null) {
                throw new FileStoreItemExistsException(itemId);
            }
        }
        catch (FileStoreItemNotFoundException existingStoreItem) {
            // empty catch block
        }
        FileStorageConfigurationImpl storageConnectionConfig = this.getFileStorageConnectionConfig(backendConnectionId);
        ZonedDateTime creationDate = ZonedDateTime.now();
        FileSizeAndChecksum fileSizeAndChecksum = this.getFileSizeAndCrc32(file);
        ObjectStoreReference objectStoreReference = new ObjectStoreReference(backendConnectionId, bucket, itemId);
        FileStoreItem fileItem = FileStoreItem.withId(itemId).withCreator(userSession.getLoginName()).withCreatorServiceId(creatorServiceId).withCreationDate(creationDate).withModificationDate(creationDate).withFilename(file.getFileName()).withContentType(file.getContentType().toString()).withFilesize(fileSizeAndChecksum.fileSize()).withChecksumCrc32(fileSizeAndChecksum.crc32()).withReadRestriction(readRestriction).withWriteRestriction(writeRestriction).withObjectStoreReference(objectStoreReference).build();
        if (performUserRestrictionChecks) {
            this.validateFileRestrictionsOnCreate(fileItem, userSession);
        }
        ObjectStorageClientFactoryService objectStorageFactoryService = this.objectStorageClientFactoryServiceTracker.getService();
        try (ObjectStorageClient objectStorageClient = objectStorageFactoryService.getObjectStorageClient(storageConnectionConfig);){
            objectStorageClient.uploadFile(file, bucket, itemId, file.getContentType().toString());
            try {
                persistenceHandler.saveFileStoreItem(fileItem);
            }
            catch (Exception e) {
                objectStorageClient.deleteFile(bucket, itemId);
                throw e;
            }
        }
        catch (FileStoreConnectionCloseException e) {
            LOGGER.warn("Failed to close file store connection.", (Throwable)e);
        }
        catch (OpenSearchIndexNotFoundException | OpenSearchRelatedException | FileStorageIndexPreparationException | FileStoreConnectionException | StoreItemJsonException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FileStoreConnectionException(e, storageConnectionConfig.getStorageTypeEnum(), FileStorageOperation.UPLOAD_FILE);
        }
        return fileItem;
    }

    @Override
    public FileStoreItem updateFile(String itemId, UploadedFile file, UserSession userSession) throws SystemException {
        LOGGER.info("updateFile itemId={}, file={}, userSession=...", (Object)itemId, (Object)file.getFileName());
        FileStoragePersistenceHandler persistenceHandler = new FileStoragePersistenceHandler(this.getOpenSearchService());
        FileStoreItem storeItem = persistenceHandler.loadFileStoreItem(itemId);
        if (!storeItem.isWriteableBy(userSession)) {
            throw new FileStoreItemRightsException(itemId);
        }
        FileSizeAndChecksum sizeAndChecksum = this.getFileSizeAndCrc32(file);
        ObjectStoreReference objectStoreReference = storeItem.getObjectStoreReference();
        FileStorageConfigurationImpl storageConnectionConfig = this.getFileStorageConnectionConfig(objectStoreReference.backendConnectionId());
        ObjectStorageClientFactoryService objectStorageFactoryService = this.objectStorageClientFactoryServiceTracker.getService();
        try (ObjectStorageClient objectStorageClient = objectStorageFactoryService.getObjectStorageClient(storageConnectionConfig);){
            objectStorageClient.uploadFile(file, objectStoreReference.bucket(), objectStoreReference.fileKey(), storeItem.getContentType());
        }
        catch (FileStoreConnectionCloseException e) {
            LOGGER.warn("Failed to close file store connection.", (Throwable)e);
        }
        catch (FileStoreConnectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FileStoreConnectionException(e, storageConnectionConfig.getStorageTypeEnum(), FileStorageOperation.UPLOAD_FILE);
        }
        FileStoreItem updatedFileItem = FileStoreItemFactory.createUpdatedFileItem(storeItem, file.getFileName(), file.getContentType().toString(), sizeAndChecksum.fileSize(), sizeAndChecksum.crc32());
        persistenceHandler.saveFileStoreItem(updatedFileItem);
        return updatedFileItem;
    }

    @Override
    public FileStoreItem updateItemMetadata(String itemId, FileStoreItemPutDto fileStoreItemPutDto, UserSession userSession) throws SystemException {
        LOGGER.info("updateItemMetadata itemId={}, fileStoreItemPutDto={}, userSession=...", (Object)itemId, (Object)fileStoreItemPutDto);
        FileStoragePersistenceHandler persistenceHandler = new FileStoragePersistenceHandler(this.getOpenSearchService());
        FileStoreItem storeItem = persistenceHandler.loadFileStoreItem(itemId);
        if (!storeItem.isWriteableBy(userSession)) {
            throw new FileStoreItemRightsException(itemId);
        }
        if (fileStoreItemPutDto.readRestriction != null) {
            this.validateFileRestriction(fileStoreItemPutDto.readRestriction, userSession, "The user does not fulfill updated Read Restrictions.");
        }
        if (fileStoreItemPutDto.writeRestriction != null) {
            this.validateFileRestriction(fileStoreItemPutDto.writeRestriction, userSession, "The user does not fulfill updated Write Restrictions.");
        }
        FileStoreItem updatedFileItem = FileStoreItemFactory.createUpdatedFileItem(storeItem, fileStoreItemPutDto);
        persistenceHandler.saveFileStoreItem(updatedFileItem);
        return updatedFileItem;
    }

    @Override
    public void deleteItem(String itemId, UserSession userSession, boolean performUserRestrictionChecks) throws ServiceNotFoundException, OpenSearchRelatedException, OpenSearchIndexNotFoundException, FileStoreItemNotFoundException, FileStoreItemRightsException, FileStorageIndexPreparationException, ModuleNotFoundException, ModuleInstanceNotFoundException, FileStoreConnectionException {
        LOGGER.info("deleteItem itemId={}, userSession=...", (Object)itemId);
        FileStoragePersistenceHandler persistenceHandler = new FileStoragePersistenceHandler(this.getOpenSearchService());
        FileStoreItem storeItem = persistenceHandler.loadFileStoreItem(itemId);
        if (performUserRestrictionChecks && !storeItem.isDeletableBy(userSession)) {
            throw new FileStoreItemRightsException(itemId);
        }
        ObjectStoreReference objectStoreRef = storeItem.getObjectStoreReference();
        FileStorageConfigurationImpl storageConnectionConfig = this.getFileStorageConnectionConfig(objectStoreRef.backendConnectionId());
        ObjectStorageClientFactoryService objectStorageFactoryService = this.objectStorageClientFactoryServiceTracker.getService();
        try (ObjectStorageClient objectStorageClient = objectStorageFactoryService.getObjectStorageClient(storageConnectionConfig);){
            objectStorageClient.deleteFile(objectStoreRef.bucket(), objectStoreRef.fileKey());
        }
        catch (FileStoreConnectionCloseException e) {
            LOGGER.warn("Failed to close file store connection.", (Throwable)e);
        }
        catch (FileStoreConnectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FileStoreConnectionException(e, storageConnectionConfig.getStorageTypeEnum(), FileStorageOperation.DELETE_FILE);
        }
        persistenceHandler.deleteFileStoreItem(itemId);
    }

    private FileSizeAndChecksum getFileSizeAndCrc32(UploadedFile file) throws SystemException {
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[8192];
        long totalBytes = 0L;
        try (InputStream instream = file.getInputStream();){
            int bytesRead;
            while ((bytesRead = instream.read(buffer)) != -1) {
                crc.update(buffer, 0, bytesRead);
                totalBytes += (long)bytesRead;
            }
        }
        catch (IOException e) {
            throw new SystemException((ErrorCode)BpcErrorCode.FILE_STORAGE_INTERNAL_ERROR, "Error while reading uploaded file: " + e.getMessage());
        }
        return new FileSizeAndChecksum(totalBytes, String.format("%08x", crc.getValue()));
    }

    private void validateFileRestrictionsOnCreate(FileStoreItem fileStoreItem, UserSession userSession) throws SystemException {
        this.validateFileRestriction(fileStoreItem.getReadRestriction(), userSession, "The user needs read access on the file they create.");
        this.validateFileRestriction(fileStoreItem.getWriteRestriction(), userSession, "The user needs write access on the file they create.");
    }

    private void validateFileRestriction(ItemRestriction itemRestriction, UserSession userSession, String message) throws SystemException {
        if (itemRestriction == null || !itemRestriction.isValid() || !itemRestriction.hasAccess(userSession)) {
            throw new SystemException((ErrorCode)BpcErrorCode.FILE_STORAGE_BAD_REQUEST, message);
        }
    }

    private FileStorageConfigurationImpl getFileStorageConnectionConfig(String backendConnectionId) throws ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOGGER.info("getBackendConnectionConfiguration deploymentSystemId={}", (Object)backendConnectionId);
        BackendConnectionsModule backendConnectionsModule = (BackendConnectionsModule)this.moduleManagerTracker.getService().getModuleById("backendconnection");
        List<ModuleInstance> fileBackendConnections = backendConnectionsModule.getModuleInstancesByInstanceType("file_storage");
        Optional<ModuleInstance> fileBackendConnection = fileBackendConnections.stream().filter(c -> c.getModuleId().equals(backendConnectionId)).findFirst();
        if (fileBackendConnection.isEmpty()) {
            throw new ModuleInstanceNotFoundException("backendconnection", backendConnectionId);
        }
        return new FileStorageConfigurationImpl(fileBackendConnection.get().getConfiguration());
    }

    private record FileSizeAndChecksum(long fileSize, String crc32) {
    }
}

