/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.filestorage;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingValidator;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.FrontendWarningException;
import de.virtimo.bpc.api.filestorage.clients.ObjectStorageClient;
import de.virtimo.bpc.api.filestorage.clients.ObjectStorageClientFactoryService;
import de.virtimo.bpc.core.filestorage.FileStorageConfigurationImpl;
import de.virtimo.bpc.util.MapUtil;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class FileStorageSettingValidator
implements SettingValidator {
    private static final Logger LOGGER = LogManager.getLogger(FileStorageSettingValidator.class);
    private BundleContext bundleContext;
    private final BpcServicesTracker<ObjectStorageClientFactoryService> objectStorageClientFactoryServiceTracker;

    public FileStorageSettingValidator(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.objectStorageClientFactoryServiceTracker = new BpcServicesTracker<ObjectStorageClientFactoryService>(bundleContext, ObjectStorageClientFactoryService.class);
    }

    @Override
    public void destroy() {
        LOGGER.info("destroy");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public boolean canValidate(String moduleId, String moduleInstanceId, String instanceType) {
        return "backendconnection".equalsIgnoreCase(moduleId) && "file_storage".equalsIgnoreCase(instanceType);
    }

    @Override
    public boolean canValidate(Setting setting) {
        return false;
    }

    @Override
    public List<FrontendWarningException> validate(Setting setting) throws ValidationException {
        return null;
    }

    @Override
    public List<FrontendWarningException> validate(String moduleId, String moduleInstanceId, String instanceType, Map<String, Setting> settings) throws ValidationException {
        LOGGER.info("validate moduleId={}, moduleInstanceId={}, instanceType={}, settings:...", (Object)moduleId, (Object)moduleInstanceId, (Object)instanceType);
        FileStorageConfigurationImpl configuration = new FileStorageConfigurationImpl(settings);
        try {
            ObjectStorageClientFactoryService objectStorageFactoryService = this.objectStorageClientFactoryServiceTracker.getService();
            try (ObjectStorageClient objectStorageClient = objectStorageFactoryService.getObjectStorageClient(configuration);){
                objectStorageClient.listBuckets();
            }
        }
        catch (Throwable ex) {
            throw new ValidationException((ErrorCode)BpcErrorCode.FILE_STORAGE_CONNECTION_VALIDATION_FAILED, "Could not connect to file storage service ({service}):\n{message}", MapUtil.mapOf("message", ex.getMessage(), "service", configuration.getStorageType()));
        }
        return null;
    }
}

