/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.filestorage.objectstorage;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.filestorage.FileStorageConfiguration;
import de.virtimo.bpc.api.filestorage.clients.AwsS3StorageClientCreationService;
import de.virtimo.bpc.api.filestorage.clients.AzureBlobStorageClientCreationService;
import de.virtimo.bpc.api.filestorage.clients.GoogleCloudStorageClientCreationService;
import de.virtimo.bpc.api.filestorage.clients.ObjectStorageClient;
import de.virtimo.bpc.api.filestorage.clients.ObjectStorageClientFactoryService;
import de.virtimo.bpc.api.filestorage.exception.FileStoreConnectionException;
import de.virtimo.bpc.api.filestorage.exception.enums.FileStorageOperation;
import de.virtimo.bpc.api.filestorage.exception.enums.FileStorageTypes;
import org.osgi.framework.BundleContext;

public class ObjectStorageClientFactoryServiceImpl
implements ObjectStorageClientFactoryService,
BpcService {
    private final BundleContext bundleContext;
    private final BpcServicesTracker<GoogleCloudStorageClientCreationService> googleCloudStorageClientCreationServiceTracker;
    private final BpcServicesTracker<AzureBlobStorageClientCreationService> azureBlobStorageClientCreationServiceTracker;
    private final BpcServicesTracker<AwsS3StorageClientCreationService> awsS3StorageClientCreationServiceTracker;

    public ObjectStorageClientFactoryServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.googleCloudStorageClientCreationServiceTracker = new BpcServicesTracker<GoogleCloudStorageClientCreationService>(bundleContext, GoogleCloudStorageClientCreationService.class);
        this.azureBlobStorageClientCreationServiceTracker = new BpcServicesTracker<AzureBlobStorageClientCreationService>(bundleContext, AzureBlobStorageClientCreationService.class);
        this.awsS3StorageClientCreationServiceTracker = new BpcServicesTracker<AwsS3StorageClientCreationService>(bundleContext, AwsS3StorageClientCreationService.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public ObjectStorageClient getObjectStorageClient(FileStorageConfiguration configuration) throws FileStoreConnectionException {
        try {
            switch (configuration.getStorageType()) {
                case "s3": {
                    AwsS3StorageClientCreationService awsS3ClientCreationService = this.awsS3StorageClientCreationServiceTracker.getService();
                    return awsS3ClientCreationService.getAwsS3StorageClient(configuration.getAwsEndpointUrl(), configuration.getAwsRegion(), configuration.getAwsCredentialsKey(), configuration.getAwsCredentialsSecret());
                }
                case "azureBlobStorage": {
                    AzureBlobStorageClientCreationService azureClientCreationService = this.azureBlobStorageClientCreationServiceTracker.getService();
                    return azureClientCreationService.getAzureBlobStorageClient(configuration.getAzureEndpointUrl(), configuration.getAzureAccountName(), configuration.getAzureAccountKey());
                }
                case "googleCloudStorage": {
                    GoogleCloudStorageClientCreationService googleClientCreationService = this.googleCloudStorageClientCreationServiceTracker.getService();
                    return googleClientCreationService.getGoogleCloudStorageClient(configuration.getGoogleCloudProjectId(), configuration.getGoogleCloudServiceAccountJson());
                }
            }
            throw new FileStoreConnectionException(new IllegalArgumentException("Invalid storage type: " + configuration.getStorageType()), FileStorageTypes.UNKNOWN, FileStorageOperation.ESTABLISH_CONNECTION);
        }
        catch (ServiceNotFoundException e) {
            throw new FileStoreConnectionException(new ServiceNotFoundException(GoogleCloudStorageClientCreationService.class), configuration.getStorageTypeEnum(), FileStorageOperation.ESTABLISH_CONNECTION);
        }
    }
}

