/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.httpproxy;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.ConnectionTestException;
import de.virtimo.bpc.api.ConnectionTester;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.core.httpproxy.HttpProxyCall;
import de.virtimo.bpc.core.httpproxy.HttpProxyCallConfigFromBackendConnection;
import de.virtimo.bpc.util.StringUtil;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class HttpProxyConnectionTester
implements ConnectionTester {
    private static final Logger LOGGER = LogManager.getLogger(HttpProxyConnectionTester.class);
    private final BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private final BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;

    public HttpProxyConnectionTester(BundleContext bundleContext) {
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(bundleContext, CoreBundleConfiguration.class);
        this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(bundleContext, ClientSessionManager.class);
    }

    @Override
    public void destroy() {
        LOGGER.info("destroy");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public boolean canBeUsedToPerformConnectionTest(ModuleInstance moduleInstance) {
        LOGGER.info("canBeUsedToPerformConnectionTest moduleInstance=...");
        return moduleInstance != null && "backendconnection".equalsIgnoreCase(moduleInstance.getParentModule().getModuleId()) && "http_proxy".equalsIgnoreCase(moduleInstance.getInstanceType());
    }

    @Override
    public void performConnectionTest(ModuleInstance moduleInstance, Map<String, Object> testData) throws ConnectionTestException {
        try {
            this.addNonHijackableSessionIdToTestData(testData);
            HttpProxyCallConfigFromBackendConnection config = new HttpProxyCallConfigFromBackendConnection(moduleInstance);
            HttpProxyCall httpProxyCall = new HttpProxyCall(config);
            httpProxyCall.doConnectionTest(testData);
        }
        catch (ConnectionTestException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConnectionTestException(ex);
        }
    }

    private void addNonHijackableSessionIdToTestData(Map<String, Object> testData) {
        if (testData.containsKey("___nonHijackableSessionId___")) {
            return;
        }
        Object object = testData.get("___userSession___");
        if (!(object instanceof UserSession)) {
            return;
        }
        UserSession userSession = (UserSession)object;
        try {
            ClientSessionManager sessionManager = this.clientSessionManagerTracker.getService();
            String nonHijackableSessionId = sessionManager.getNonHijackableSessionIdFromSessionId(userSession.getSessionId());
            if (!StringUtil.isNullOrEmpty(nonHijackableSessionId)) {
                testData.put("___nonHijackableSessionId___", nonHijackableSessionId);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error while adding ___nonHijackableSessionId___ to testData", (Throwable)e);
        }
    }
}

