/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.httpproxy;

import de.virtimo.bpc.api.AbstractBackendModuleLoadedAndAutoCreateModuleInstancesDoneEventHandler;
import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.security.AbstractCheck;
import de.virtimo.bpc.api.security.CheckResult;
import de.virtimo.bpc.api.security.CheckResultStorageService;
import de.virtimo.bpc.backendconnections.BackendConnections;
import de.virtimo.bpc.core.security.check.AbstractBpcSecurityCheck;
import de.virtimo.bpc.util.StringUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;

public class HttpProxySecurityCheck
extends AbstractBpcSecurityCheck {
    private static final Logger LOGGER = LogManager.getLogger(HttpProxySecurityCheck.class);
    public static final String IDENTIFIER = "BackendConnectionHttpProxyCheck";
    public static final AbstractCheck.InterimResult RESULT_DISABLED_CERTIFICATE_VALIDATION = new AbstractCheck.InterimResult(-1, "Disabled certificate validation");
    public static final AbstractCheck.InterimResult RESULT_USED_BASIC_AUTHENTICATION = new AbstractCheck.InterimResult(1, "Basic Authentication");
    public static final AbstractCheck.InterimResult RESULT_BASIC_AUTHENTICATION_WITHOUT_TLS = new AbstractCheck.InterimResult(-1, "Basic Authentication without TLS");
    public static final AbstractCheck.InterimResult RESULT_TLS_ACTIVATED = new AbstractCheck.InterimResult(2, "TLS activated");
    public static final AbstractCheck.InterimResult RESULT_NO_TLS = new AbstractCheck.InterimResult(0, "No TLS used");
    private final BpcServicesTracker<ModuleManager> moduleManagerServiceTracker;

    public HttpProxySecurityCheck(BundleContext bundleContext) {
        super(bundleContext);
        this.moduleManagerServiceTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
        this.eventRegistration.forBackendModuleLoadedAndAutoCreateModuleInstancesDoneEvents("backendconnection", new BackendConnectionsModuleLoadedAndAutoCreateModuleInstancesDoneEventHandler());
    }

    @Override
    protected void coreReady() {
    }

    @Override
    public void shutdownService() {
        super.shutdownService();
    }

    @Override
    public String getDescription() {
        return "Check the backend connections configuration of type http proxy";
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public int getMaximumScore() {
        return 3;
    }

    private void checkConfigurations() {
        LOGGER.info("Checking configurations");
        try {
            for (ModuleConfiguration moduleConfiguration : BackendConnections.getAllModuleConfigurations(this.moduleManagerServiceTracker.getService(), "http_proxy")) {
                this.checkConfiguration(moduleConfiguration);
            }
        }
        catch (ModuleNotFoundException e) {
            LOGGER.error("BackendConnections-Module not found.", (Throwable)e);
        }
        catch (ServiceNotFoundException e) {
            LOGGER.error("ModuleManager-Service not found.", (Throwable)e);
        }
    }

    private void checkConfiguration(ModuleConfiguration moduleConfigurationOfHttpProxy) {
        try {
            String instanceId = moduleConfigurationOfHttpProxy.getSetting("allowUntrustedConnections").getInstanceId();
            ArrayList<AbstractCheck.InterimResult> interimResults = new ArrayList<AbstractCheck.InterimResult>();
            interimResults.add(this.checkAllowUntrustedConnection(moduleConfigurationOfHttpProxy));
            interimResults.add(this.checkUsageOfBasicAuthentication(moduleConfigurationOfHttpProxy));
            interimResults.add(this.checkTls(moduleConfigurationOfHttpProxy));
            CheckResult checkResult = this.getCheckResultBuilderFromInterimResults(interimResults).withCheckResultId("backend-connection-http-proxy-" + instanceId).withTags(List.of("backend-connection", "http-proxy", instanceId)).build();
            LOGGER.info("HTTP Proxy configuration check result: {}", (Object)checkResult);
            ((CheckResultStorageService)this.checkResultStorageServiceTracker.getService()).storeCheckResult(checkResult);
        }
        catch (Exception e) {
            LOGGER.error("Failed to check configuration", (Throwable)e);
        }
    }

    private void checkConfiguration(String instanceId) {
        if (StringUtil.isNullOrEmpty(instanceId)) {
            return;
        }
        try {
            List<ModuleConfiguration> httpProxyModuleConfigurations = BackendConnections.getAllModuleConfigurations(this.moduleManagerServiceTracker.getService(), "http_proxy");
            httpProxyModuleConfigurations.stream().filter(mc -> mc.getSetting("allowUntrustedConnections").getInstanceId().equals(instanceId)).findFirst().ifPresent(this::checkConfiguration);
        }
        catch (ModuleNotFoundException e) {
            LOGGER.error("BackendConnections-Module not found.", (Throwable)e);
        }
        catch (ServiceNotFoundException e) {
            LOGGER.error("ModuleManager-Service not found.", (Throwable)e);
        }
    }

    private AbstractCheck.InterimResult checkAllowUntrustedConnection(ModuleConfiguration moduleConfiguration) {
        Setting allowUntrustedConnectionSetting = moduleConfiguration.getSetting("allowUntrustedConnections");
        if (allowUntrustedConnectionSetting.getSettingValue().asBoolean()) {
            LOGGER.warn("Backend Connection (Type {}, ID {}) is allowed to use untrusted connections", (Object)"http_proxy", (Object)allowUntrustedConnectionSetting.getInstanceId());
            return RESULT_DISABLED_CERTIFICATE_VALIDATION;
        }
        return new AbstractCheck.InterimResult(0, null);
    }

    private AbstractCheck.InterimResult checkUsageOfBasicAuthentication(ModuleConfiguration moduleConfiguration) {
        String username = moduleConfiguration.getSettingValue("connectionUsername").asString();
        String password = moduleConfiguration.getSettingValue("connectionPassword").asString();
        if (username != null && !username.isEmpty() && password != null && !password.isEmpty()) {
            if (!this.useSecureConnection(moduleConfiguration)) {
                LOGGER.warn("Backend Connection (Type {}, ID {}) uses basic authentication without TLS", (Object)"http_proxy", (Object)moduleConfiguration.getSetting("connectionPassword").getInstanceId());
                return RESULT_BASIC_AUTHENTICATION_WITHOUT_TLS;
            }
            return RESULT_USED_BASIC_AUTHENTICATION;
        }
        return new AbstractCheck.InterimResult(0, null);
    }

    private AbstractCheck.InterimResult checkTls(ModuleConfiguration moduleConfiguration) {
        if (this.useSecureConnection(moduleConfiguration)) {
            return RESULT_TLS_ACTIVATED;
        }
        return RESULT_NO_TLS;
    }

    private boolean useSecureConnection(ModuleConfiguration moduleConfiguration) {
        String urlString = null;
        try {
            urlString = moduleConfiguration.getSettingValue("connectionBaseUrl").asString();
            URL url = new URL(urlString);
            return "https".equalsIgnoreCase(url.getProtocol());
        }
        catch (MalformedURLException e) {
            String httpProxyName = "";
            Setting nameSetting = moduleConfiguration.getSetting("module_name");
            if (nameSetting != null) {
                httpProxyName = nameSetting.getSettingValue().asString();
                String instanceId = nameSetting.getInstanceId();
                if (!StringUtil.isNullOrEmpty(instanceId)) {
                    httpProxyName = String.format("%s (%s)", httpProxyName, instanceId);
                }
            }
            LOGGER.warn("Cannot parse protocol from URL ('{}') for HTTP-Proxy {}. (Treat as \"no tls\")", (Object)urlString, (Object)httpProxyName);
            return false;
        }
    }

    private class BackendConnectionsModuleLoadedAndAutoCreateModuleInstancesDoneEventHandler
    extends AbstractBackendModuleLoadedAndAutoCreateModuleInstancesDoneEventHandler {
        private BackendConnectionsModuleLoadedAndAutoCreateModuleInstancesDoneEventHandler() {
        }

        @Override
        public void processModule(Module module) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            HttpProxySecurityCheck.this.eventRegistration.forModuleInstanceCreatedEvents("backendconnection", "http_proxy", new ModuleInstanceChangedEventHandler());
            HttpProxySecurityCheck.this.eventRegistration.forModuleInstanceUpdatedEvents("backendconnection", "http_proxy", new ModuleInstanceChangedEventHandler());
            HttpProxySecurityCheck.this.checkConfigurations();
        }
    }

    private class ModuleInstanceChangedEventHandler
    extends AbstractEventHandler {
        private ModuleInstanceChangedEventHandler() {
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.debug("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            String moduleInstanceId = event.getProperty("moduleInstanceId").toString();
            HttpProxySecurityCheck.this.checkConfiguration(moduleInstanceId);
        }
    }
}

