/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.httpproxy;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.HttpProxyException;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.HttpProxyService;
import de.virtimo.bpc.backendconnections.BackendConnectionsModule;
import de.virtimo.bpc.core.httpproxy.HttpProxyCall;
import de.virtimo.bpc.core.httpproxy.HttpProxyCallConfigFromBackendConnection;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class HttpProxyServiceImpl
implements HttpProxyService,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(HttpProxyServiceImpl.class);
    private final BundleContext bundleContext;
    private final BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private final BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private final BpcServicesTracker<ClientSessionManager> clientSessionManagerBpcServicesTracker;

    public HttpProxyServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(bundleContext, CoreBundleConfiguration.class);
        this.clientSessionManagerBpcServicesTracker = new BpcServicesTracker<ClientSessionManager>(bundleContext, ClientSessionManager.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public ModuleConfiguration getConfig(String backendConnectionInstanceId) throws ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        BackendConnectionsModule backendConnectionModule = (BackendConnectionsModule)this.moduleManagerTracker.getService().getModuleById("backendconnection");
        ModuleInstance backendConnectionInstance = backendConnectionModule.getModuleInstanceById(backendConnectionInstanceId);
        return backendConnectionInstance.getConfiguration();
    }

    private HttpProxyCall getHttpProxyCallForBackendConnectionInstance(String backendConnectionInstanceId) throws ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        BackendConnectionsModule backendConnectionModule = (BackendConnectionsModule)this.moduleManagerTracker.getService().getModuleById("backendconnection");
        ModuleInstance backendConnectionInstance = backendConnectionModule.getModuleInstanceById(backendConnectionInstanceId);
        HttpProxyCallConfigFromBackendConnection config = new HttpProxyCallConfigFromBackendConnection(backendConnectionInstance);
        return new HttpProxyCall(config);
    }

    private String getNonHijackableSessionId(UserSession userSession) throws ServiceNotFoundException {
        if (userSession == null) {
            return null;
        }
        ClientSessionManager clientSessionManager = this.clientSessionManagerBpcServicesTracker.getService();
        return clientSessionManager.getNonHijackableSessionIdFromSessionId(userSession.getSessionId());
    }

    @Override
    public Response doGet(String backendConnectionInstanceId, String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession) throws HttpProxyException, ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOGGER.info("doGet backendConnectionInstanceId={}, targetPath={}, targetUrl={}, uriInfo={}, headers=..., userSession=...=", (Object)backendConnectionInstanceId, (Object)targetPath, (Object)targetUrl, (Object)uriInfo);
        return this.getHttpProxyCallForBackendConnectionInstance(backendConnectionInstanceId).doGet(targetPath, targetUrl, uriInfo, headers, userSession, this.getNonHijackableSessionId(userSession));
    }

    @Override
    public Response doPost(String backendConnectionInstanceId, String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession, byte[] body) throws HttpProxyException, ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOGGER.info("doPost backendConnectionInstanceId={}, targetPath={}, targetUrl={}, uriInfo={}, headers=..., userSession=..., body=...=", (Object)backendConnectionInstanceId, (Object)targetPath, (Object)targetUrl, (Object)uriInfo);
        return this.getHttpProxyCallForBackendConnectionInstance(backendConnectionInstanceId).doPost(targetPath, targetUrl, uriInfo, headers, userSession, this.getNonHijackableSessionId(userSession), body);
    }

    @Override
    public Response doPut(String backendConnectionInstanceId, String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession, byte[] body) throws HttpProxyException, ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOGGER.info("doPut backendConnectionInstanceId={}, targetPath={}, targetUrl={}, uriInfo={}, headers=..., userSession=..., body=...=", (Object)backendConnectionInstanceId, (Object)targetPath, (Object)targetUrl, (Object)uriInfo);
        return this.getHttpProxyCallForBackendConnectionInstance(backendConnectionInstanceId).doPut(targetPath, targetUrl, uriInfo, headers, userSession, this.getNonHijackableSessionId(userSession), body);
    }

    @Override
    public Response doDelete(String backendConnectionInstanceId, String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession) throws HttpProxyException, ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOGGER.info("doDelete backendConnectionInstanceId={}, targetPath={}, targetUrl={}, uriInfo={}, headers=..., userSession=...=", (Object)backendConnectionInstanceId, (Object)targetPath, (Object)targetUrl, (Object)uriInfo);
        return this.getHttpProxyCallForBackendConnectionInstance(backendConnectionInstanceId).doDelete(targetPath, targetUrl, uriInfo, headers, userSession, this.getNonHijackableSessionId(userSession));
    }

    @Override
    public Response doOptions(String backendConnectionInstanceId, String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession) throws HttpProxyException, ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOGGER.info("doOptions backendConnectionInstanceId={}, targetPath={}, targetUrl={}, uriInfo={}, headers=..., userSession=...=", (Object)backendConnectionInstanceId, (Object)targetPath, (Object)targetUrl, (Object)uriInfo);
        return this.getHttpProxyCallForBackendConnectionInstance(backendConnectionInstanceId).doOptions(targetPath, targetUrl, uriInfo, headers, userSession, this.getNonHijackableSessionId(userSession));
    }

    @Override
    public Response doPatch(String backendConnectionInstanceId, String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession, byte[] body) throws HttpProxyException, ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOGGER.info("doPatch backendConnectionInstanceId={}, targetPath={}, targetUrl={}, uriInfo={}, headers=..., userSession=..., body=...=", (Object)backendConnectionInstanceId, (Object)targetPath, (Object)targetUrl, (Object)uriInfo);
        return this.getHttpProxyCallForBackendConnectionInstance(backendConnectionInstanceId).doPatch(targetPath, targetUrl, uriInfo, headers, userSession, this.getNonHijackableSessionId(userSession), body);
    }
}

