/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.internationalization;

import de.virtimo.bpc.api.Setting;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TranslationsOfSetting {
    private static final Logger LOGGER = LogManager.getLogger(TranslationsOfSetting.class);
    private final Set<String> isoLanguages = new HashSet<String>(Arrays.asList(Locale.getISOLanguages()));
    private Map customTranslationsMap = null;

    void updateWithSetting(Setting customTranslationsSetting) {
        LOGGER.info("updateWithSetting customTranslationsSetting={}", (Object)customTranslationsSetting);
        this.customTranslationsMap = customTranslationsSetting == null ? null : customTranslationsSetting.getSettingValue().asMap(null);
    }

    Set<String> getLanguages() {
        LOGGER.info("getLanguages");
        HashSet<String> result = new HashSet<String>();
        if (this.customTranslationsMap != null) {
            for (Object languageObject : this.customTranslationsMap.keySet()) {
                String language;
                if (!(languageObject instanceof String) || !this.isoLanguages.contains(language = ((String)languageObject).toLowerCase())) continue;
                result.add(language);
            }
        }
        return result;
    }

    Map<String, Object> getTranslationsForLanguage(String lowerCaseLangKey) {
        Object langEntries;
        LOGGER.info("getTranslationsForLanguage lowerCaseLangKey={}", (Object)lowerCaseLangKey);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.customTranslationsMap != null && this.customTranslationsMap.containsKey(lowerCaseLangKey) && (langEntries = this.customTranslationsMap.get(lowerCaseLangKey)) instanceof Map) {
            result.putAll((Map)langEntries);
        }
        return result;
    }
}

