/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.lookupjoins;

import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.core.lookupjoins.LookupJoin;
import de.virtimo.bpc.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LookupJoins {
    private static final Logger LOGGER = LogManager.getLogger(LookupJoins.class);
    private Map<String, LookupJoin> entries = new HashMap<String, LookupJoin>();

    public LookupJoins(Object joinField) {
        if (joinField instanceof Setting) {
            joinField = ((Setting)joinField).getValue();
        }
        if (joinField instanceof List) {
            List joinList = (List)joinField;
            for (Object joinObject : joinList) {
                if (!(joinObject instanceof Map)) continue;
                LookupJoin lookupJoin = new LookupJoin((Map)joinObject);
                if (!StringUtil.isNullOrEmpty(lookupJoin.getKeyField())) {
                    this.entries.put(lookupJoin.getKeyField(), lookupJoin);
                    continue;
                }
                LOGGER.warn("LookupJoin entry without keyField found: {}", (Object)lookupJoin);
            }
        }
    }

    public boolean hasEntries() {
        return this.entries != null && !this.entries.isEmpty();
    }

    public void clearCaches() {
        LOGGER.info("clearCaches");
        if (this.hasEntries()) {
            for (LookupJoin lookupJoin : this.entries.values()) {
                lookupJoin.clearCache();
            }
        }
    }

    public void clearCaches(Set<String> keyFields) {
        LOGGER.info("clearCaches keyFields: {}", keyFields);
        if (keyFields != null && !keyFields.isEmpty() && this.hasEntries()) {
            for (LookupJoin lookupJoin : this.entries.values()) {
                if (!keyFields.contains(lookupJoin.getKeyField())) continue;
                lookupJoin.clearCache();
            }
        }
    }

    public Set<String> getKeyFields() {
        return this.hasEntries() ? new HashSet<String>(this.entries.keySet()) : new HashSet();
    }

    public static Set<String> getKeyFields(List<LookupJoin> lookupJoins) {
        HashSet<String> result = new HashSet<String>();
        if (lookupJoins != null) {
            for (LookupJoin lookupJoin : lookupJoins) {
                result.add(lookupJoin.getKeyField());
            }
        }
        return result;
    }

    public List<LookupJoin> getEntries() {
        return this.hasEntries() ? new ArrayList<LookupJoin>(this.entries.values()) : Collections.emptyList();
    }

    public boolean isLookupJoinKeyField(String fieldName) {
        return this.hasEntries() && this.entries.containsKey(fieldName);
    }

    public LookupJoin getLookupJoinByKeyField(String fieldName) {
        return this.hasEntries() ? this.entries.get(fieldName) : null;
    }

    public List<LookupJoin> getLookupJoinsByLookupIndex(Set<String> indexOrAliasNames) {
        if (!this.hasEntries()) {
            return Collections.emptyList();
        }
        if (indexOrAliasNames == null || indexOrAliasNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LookupJoin> result = new ArrayList<LookupJoin>();
        for (LookupJoin lookupJoin : this.entries.values()) {
            if (!indexOrAliasNames.contains(lookupJoin.getLookupIndex())) continue;
            result.add(lookupJoin);
        }
        return result;
    }

    public String toString() {
        return "LookupJoins{entries=" + String.valueOf(this.entries) + "}";
    }
}

