/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.lookupjoins;

import de.virtimo.bpc.api.AbstractBackendModuleLoadedEventHandler;
import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.AbstractMaintenanceModeAcknowledgeEventHandler;
import de.virtimo.bpc.api.AbstractServerModeChangedEventHandler;
import de.virtimo.bpc.api.AbstractSettingsUpdatedEventHandler;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Percolator;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.exception.JsonGenerationException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.SearchScrollIterator;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchBpcPluginManager;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.lookupjoins.LookupJoin;
import de.virtimo.bpc.core.lookupjoins.LookupJoinUpdaterData;
import de.virtimo.bpc.core.lookupjoins.LookupJoins;
import de.virtimo.bpc.core.lookupjoins.LookupJoinsManager;
import de.virtimo.bpc.core.lookupjoins.LookupJoinsUpdater;
import de.virtimo.bpc.core.opensearch.XContentBuilderUtil;
import de.virtimo.bpc.core.percolators.PercolatorsProcessorImpl;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationModule;
import de.virtimo.bpc.core.replicator.ReplicationModuleInstance;
import de.virtimo.bpc.logservice.LogServiceModule;
import de.virtimo.bpc.logservice.LogServiceModuleInstance;
import de.virtimo.bpc.opensearch.plugin.dto.FilterDTO;
import de.virtimo.bpc.opensearch.plugin.dto.FiltersDTO;
import de.virtimo.bpc.opensearch.plugin.dto.IndexOperationDTO;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.client.indices.PutMappingRequest;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;

public class LookupJoinsManagerImpl
implements LookupJoinsManager,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(LookupJoinsManager.class);
    private final BundleContext bundleContext;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private final BpcServicesTracker<OpenSearchBpcPluginManager> openSearchBpcPluginManagerTracker;
    private final BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker;
    private final EventRegistration eventRegistration;
    private final ExecutorService executorService;
    private final Map<String, Future<Boolean>> lookupJoinsUpdates;
    private final ExecutorService informClientsExecutorService;

    public LookupJoinsManagerImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.executorService = Executors.newFixedThreadPool(1, new ThreadFactoryWithNamePrefix("bpc-core-lookupjoins-updater"));
        this.lookupJoinsUpdates = new HashMap<String, Future<Boolean>>();
        this.informClientsExecutorService = Executors.newFixedThreadPool(1, new ThreadFactoryWithNamePrefix("bpc-core-lookupjoins-clients-informer"));
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
        this.openSearchBpcPluginManagerTracker = new BpcServicesTracker<OpenSearchBpcPluginManager>(bundleContext, OpenSearchBpcPluginManager.class);
        this.percolatorsManagerTracker = new BpcServicesTracker<PercolatorsManager>(bundleContext, PercolatorsManager.class);
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forBackendModuleLoadedEvents("replication", new ReplicationModuleLoadedEventHandler());
        this.eventRegistration.forBackendModuleLoadedEvents("logservice", new LogServiceModuleLoadedEventHandler());
        this.eventRegistration.forMaintenanceModeAcknowledgeEvents(new MaintenanceModeChangedEventHandler(bundleContext));
        this.eventRegistration.forServerModeChangedEvents(new MasterOrSlaveModeChangedEventHandler());
        this.eventRegistration.forModuleInstanceCreatedEvents("replication", "none", new ReplicationModuleInstanceCreatedEventHandler());
        this.eventRegistration.forModuleInstanceUpdatedEvents("replication", "none", new ReplicationModuleInstanceUpdatedEventHandler());
        this.eventRegistration.forModuleInstanceDeletedEvents("replication", "none", new ReplicationModuleInstanceDeletedEventHandler());
        this.eventRegistration.forModuleInstanceCreatedEvents("logservice", "none", new LogServiceModuleInstanceCreatedEventHandler());
        this.eventRegistration.forModuleInstanceUpdatedEvents("logservice", "none", new LogServiceModuleInstanceUpdatedEventHandler());
        this.eventRegistration.forModuleInstanceDeletedEvents("logservice", "none", new LogServiceModuleInstanceDeletedEventHandler());
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        if (this.executorService != null) {
            try {
                this.executorService.shutdownNow();
                this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (Throwable t) {
                LOGGER.error("Failed to shutdown the lookup joins executor thread pool.");
            }
        }
        if (this.informClientsExecutorService != null) {
            this.informClientsExecutorService.shutdown();
        }
        BpcServicesTracker.stopAll(this);
        this.eventRegistration.unregisterAllEventHandler();
    }

    private void addDynamicTemplatesMapping(OpenSearchService oss, String index) {
        LOGGER.info("addDynamicTemplatesMapping oss=..., index={}", (Object)index);
        Map<String, Object> currentMapping = oss.getMapping(index);
        if (!oss.hasDynamicTemplatesMapping(currentMapping)) {
            try {
                List defaultDynamicTemplates = oss.getDefaultDynamicTemplates();
                XContentBuilder mappingBuilder = XContentFactory.jsonBuilder().prettyPrint();
                mappingBuilder.startObject();
                XContentBuilderUtil.addExistingMapping(mappingBuilder, currentMapping);
                XContentBuilderUtil.addDynamicTemplatesMapping(mappingBuilder, defaultDynamicTemplates);
                mappingBuilder.endObject();
                this.doIndexMappingUpdate(oss, index, mappingBuilder);
            }
            catch (OpenSearchRelatedException | IOException ex) {
                LOGGER.error("Could not create the dynamic template mapping of the index '" + index + "'", (Throwable)ex);
            }
        }
    }

    private void doIndexMappingUpdate(OpenSearchService oss, String index, XContentBuilder mappingBuilder) throws OpenSearchRelatedException {
        try {
            PutMappingRequest putMappingRequest = new PutMappingRequest(index).source(mappingBuilder);
            oss.getClient().indices().putMapping(putMappingRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public void refreshLookupJoins(LookupJoinUpdaterData updaterData) throws InterruptedException, ServiceNotFoundException, OpenSearchRelatedException {
        LOGGER.info("refreshLookupJoins updaterData={}", (Object)updaterData);
        if (updaterData == null) {
            LOGGER.info("Nothing to do");
            return;
        }
        final String osIndex = updaterData.getIndex();
        LookupJoins lookupJoins = updaterData.getLookupJoins();
        Set<String> keyFields = updaterData.getKeyFields();
        if (keyFields == null || keyFields.isEmpty()) {
            LOGGER.info("Nothing to do");
            return;
        }
        lookupJoins.clearCaches(keyFields);
        if (!this.isMasterServer()) {
            LOGGER.info("Nothing to do, because we are not the master server");
            return;
        }
        try {
            final OpenSearchService oss = this.openSearchServiceTracker.getService();
            final PercolatorsManager percolatorsManager = this.percolatorsManagerTracker.getService();
            RestHighLevelClient osClient = oss.getClient();
            this.addDynamicTemplatesMapping(oss, osIndex);
            Set<Percolator> percolatorsFromIndex = percolatorsManager.getAllValidPercolatorsFromIndex(oss, osIndex);
            final PercolatorsProcessorImpl percolatorsProcessor = new PercolatorsProcessorImpl(oss, osIndex, percolatorsFromIndex);
            SearchRequest searchReq = new SearchRequest().indices(osIndex).source(new SearchSourceBuilder().size(500).query(QueryBuilders.matchAllQuery()));
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
            try (SearchScrollIterator searchScrollIterator = new SearchScrollIterator(oss, searchReq);){
                while (searchScrollIterator.hasNext()) {
                    SearchHits searchHits = searchScrollIterator.next();
                    for (SearchHit hit : searchHits) {
                        Map<String, Object> sourceValues = hit.getSourceAsMap();
                        boolean documentUpdateNecessary = false;
                        for (String keyField : keyFields) {
                            LOGGER.debug("Processing key field: {}", (Object)keyField);
                            LookupJoin lookupJoin = lookupJoins.getLookupJoinByKeyField(keyField);
                            Map<String, Object> oldLookupValues = MapUtil.getEntriesWithKeyPrefix(sourceValues, lookupJoin.getResultFieldsPrefix());
                            if (sourceValues.containsKey(keyField)) {
                                Object columnValue = sourceValues.get(keyField);
                                Map<String, Object> newLookupValues = lookupJoin.getAlreadyPrefixedLookupData(oss, columnValue);
                                LOGGER.debug("oldLookupValues: {}", oldLookupValues);
                                LOGGER.debug("newLookupValues: {}", newLookupValues);
                                if (!oldLookupValues.equals(newLookupValues)) {
                                    LOGGER.debug("new and old lookup values are different, must be updated");
                                    documentUpdateNecessary = true;
                                    for (String oldKeyField : oldLookupValues.keySet()) {
                                        sourceValues.remove(oldKeyField);
                                    }
                                    sourceValues.putAll(newLookupValues);
                                    continue;
                                }
                                LOGGER.debug("Great, the old and new lookup values are identical");
                                continue;
                            }
                            LOGGER.debug("Did not find old lookup values");
                            for (String oldKeyField : oldLookupValues.keySet()) {
                                if (sourceValues.remove(oldKeyField) == null) continue;
                                documentUpdateNecessary = true;
                            }
                        }
                        if (documentUpdateNecessary) {
                            LOGGER.debug("The document must be updated: {}", (Object)hit);
                            bulkRequest.add(((IndexRequest)new IndexRequest().index(osIndex)).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
                        } else {
                            LOGGER.debug("Nothing to do, the document is already up to date: {}", (Object)hit);
                        }
                        if (bulkRequest.numberOfActions() <= 250) continue;
                        BulkResponse bulkResponse = osClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                        LOGGER.info("Refreshed lookup joins indexed: {}, hasFailures: {}", (Object)bulkRequest.numberOfActions(), (Object)bulkResponse.hasFailures());
                        percolatorsProcessor.keepDatabaseIDsFromBulkResponse(bulkResponse);
                        bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
                    }
                }
            }
            if (bulkRequest.numberOfActions() > 0) {
                BulkResponse bulkResponse = osClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                LOGGER.info("Refreshed lookup joins indexed: {}, hasFailures: {}", (Object)bulkRequest.numberOfActions(), (Object)bulkResponse.hasFailures());
                percolatorsProcessor.keepDatabaseIDsFromBulkResponse(bulkResponse);
            }
            percolatorsProcessor.process();
            FutureTask<Exception> informClientsFutureTask = new FutureTask<Exception>(new Callable<Exception>(){

                @Override
                public Exception call() {
                    try {
                        percolatorsManager.informClientsAboutReplicatedData(oss, osIndex, percolatorsProcessor);
                        return null;
                    }
                    catch (Exception ex) {
                        LOGGER.error(ex.getMessage(), (Throwable)ex);
                        return ex;
                    }
                }
            });
            this.informClientsExecutorService.execute(informClientsFutureTask);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    private synchronized void unregisterFromOpenSearchChanges() throws ServiceNotFoundException, JsonGenerationException {
        LOGGER.info("unregisterFromOpenSearchChanges");
        OpenSearchService openSearchService = this.openSearchServiceTracker.getService();
        OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
        openSearchBpcPluginManager.unregisterAllFilters(openSearchService);
    }

    private synchronized void registerForOpenSearchChanges() throws ServiceNotFoundException, JsonGenerationException {
        LOGGER.info("registerForOpenSearchChanges");
        OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
        FiltersDTO filtersToRegister = new FiltersDTO();
        try {
            ReplicationModule replicationModule = this.moduleManagerTracker.getService().getModuleByClass(ReplicationModule.class);
            for (ModuleInstance moduleInstance : replicationModule.getModuleInstances().values()) {
                ReplicationModuleInstance replicationModuleInstance = (ReplicationModuleInstance)moduleInstance;
                this.addLookupJoinsToFiltersToRegisterContainer(replicationModuleInstance.getLookupJoins(), filtersToRegister);
            }
        }
        catch (ModuleNotFoundException ex) {
            LOGGER.warn("Failed to register the used '{}' indices for OpenSearch changes. The module is not loaded at the moment. Gets registered when loaded.", (Object)ReplicationModule.class.getSimpleName());
        }
        try {
            LogServiceModule logServiceModule = this.moduleManagerTracker.getService().getModuleByClass(LogServiceModule.class);
            for (ModuleInstance moduleInstance : logServiceModule.getModuleInstances().values()) {
                LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)moduleInstance;
                if (!logServiceModuleInstance.isOpenSearchLoggingEnabled()) continue;
                this.addLookupJoinsToFiltersToRegisterContainer(logServiceModuleInstance.getLookupJoins(), filtersToRegister);
            }
        }
        catch (ModuleNotFoundException ex) {
            LOGGER.warn("Failed to register the used '{}' indices for OpenSearch changes. The module is not loaded at the moment. Gets registered when loaded.", (Object)LogServiceModule.class.getSimpleName());
        }
        LOGGER.info("Filters to register: {}", (Object)filtersToRegister);
        openSearchBpcPluginManager.registerFilters(filtersToRegister);
    }

    private void addLookupJoinsToFiltersToRegisterContainer(LookupJoins lookupJoins, FiltersDTO filtersToRegister) {
        LOGGER.info("addLookupJoinsToFiltersToRegisterContainer lookupJoins=..., filtersToRegister=...");
        if (lookupJoins != null && lookupJoins.hasEntries()) {
            for (LookupJoin lookupJoin : lookupJoins.getEntries()) {
                FilterDTO filterToRegister = new FilterDTO(lookupJoin.getLookupIndex(), true);
                filtersToRegister.addFilter(filterToRegister);
            }
        }
    }

    @Override
    public void handleOpenSearchBpcPluginIndexOperation(IndexOperationDTO indexOperation) throws ServiceNotFoundException {
        LOGGER.debug("handleOpenSearchBpcPluginIndexOperation indexOperation={}", (Object)indexOperation);
        Set indexAndAliasNames = indexOperation.getIndexAndAliasNames();
        ArrayList<LookupJoinUpdaterData> updaterDatas = new ArrayList<LookupJoinUpdaterData>();
        this.collectReplicationJobsUpdaterData(indexAndAliasNames, updaterDatas);
        this.collectLogServiceUpdaterData(indexAndAliasNames, updaterDatas);
        for (LookupJoinUpdaterData updaterData : updaterDatas) {
            LOGGER.info("Loookup joins to refresh: {}", (Object)updaterData);
            Future<Boolean> lookupJoinUpdaterFuture = this.lookupJoinsUpdates.get(updaterData.getIndex());
            if (lookupJoinUpdaterFuture != null && !lookupJoinUpdaterFuture.isDone()) {
                lookupJoinUpdaterFuture.cancel(true);
            }
            Future<Boolean> futureUpdate = this.executorService.submit(new LookupJoinsUpdater(this, updaterData));
            this.lookupJoinsUpdates.put(updaterData.getIndex(), futureUpdate);
        }
    }

    private void collectReplicationJobsUpdaterData(Set<String> indexAndAliasNames, List<LookupJoinUpdaterData> updaterDatas) throws ServiceNotFoundException {
        try {
            ReplicationModule replicationModule = this.moduleManagerTracker.getService().getModuleByClass(ReplicationModule.class);
            for (ModuleInstance moduleInstance : replicationModule.getModuleInstances().values()) {
                List<LookupJoin> relatedLookupJoinEntries;
                ReplicationModuleInstance replicationModuleInstance = (ReplicationModuleInstance)moduleInstance;
                LookupJoins lookupJoins = replicationModuleInstance.getLookupJoins();
                if (lookupJoins == null || !lookupJoins.hasEntries() || (relatedLookupJoinEntries = lookupJoins.getLookupJoinsByLookupIndex(indexAndAliasNames)) == null || relatedLookupJoinEntries.isEmpty()) continue;
                ReplicationJob replicationJob = replicationModuleInstance.getReplicationJob();
                LookupJoinUpdaterData updaterData = new LookupJoinUpdaterData(replicationJob.getTarget().getIndex(), lookupJoins, LookupJoins.getKeyFields(relatedLookupJoinEntries));
                updaterDatas.add(updaterData);
            }
        }
        catch (ModuleNotFoundException ex) {
            LOGGER.warn("Skipping '{}' indices related events until the module is loaded.", (Object)ReplicationModule.class.getSimpleName());
        }
    }

    private void collectLogServiceUpdaterData(Set<String> indexAndAliasNames, List<LookupJoinUpdaterData> updaterDatas) throws ServiceNotFoundException {
        try {
            LogServiceModule logServiceModule = this.moduleManagerTracker.getService().getModuleByClass(LogServiceModule.class);
            for (ModuleInstance moduleInstance : logServiceModule.getModuleInstances().values()) {
                List<LookupJoin> relatedLookupJoinEntries;
                LookupJoins lookupJoins;
                LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)moduleInstance;
                if (!logServiceModuleInstance.isOpenSearchLoggingEnabled() || !(lookupJoins = logServiceModuleInstance.getLookupJoins()).hasEntries() || (relatedLookupJoinEntries = lookupJoins.getLookupJoinsByLookupIndex(indexAndAliasNames)) == null || relatedLookupJoinEntries.isEmpty()) continue;
                LookupJoinUpdaterData parentUpdaterData = new LookupJoinUpdaterData(logServiceModuleInstance.getOpenSearchParentIndex(), lookupJoins, LookupJoins.getKeyFields(relatedLookupJoinEntries));
                updaterDatas.add(parentUpdaterData);
                if (!logServiceModuleInstance.hasOpenSearchChildProcessingEnabled()) continue;
                LookupJoinUpdaterData childUpdaterData = new LookupJoinUpdaterData(logServiceModuleInstance.getOpenSearchChildIndex(), lookupJoins, LookupJoins.getKeyFields(relatedLookupJoinEntries));
                updaterDatas.add(childUpdaterData);
            }
        }
        catch (ModuleNotFoundException ex) {
            LOGGER.warn("Skipping '{}' indices related events until the module is loaded.", (Object)LogServiceModule.class.getSimpleName());
        }
    }

    private boolean isMasterServer() {
        LOGGER.debug("isMasterServer");
        try {
            return this.moduleManagerTracker.getService().getModuleByClass(CoreModule.class).isMasterServer();
        }
        catch (ModuleNotFoundException | ServiceNotFoundException ex) {
            LOGGER.error("Having big troubles to get the ModuleManager service and CoreModule.", (Throwable)ex);
            return false;
        }
    }

    private boolean isMaintenanceModeEnabled() {
        LOGGER.debug("isMaintenanceModeEnabled");
        try {
            return this.moduleManagerTracker.getService().getModuleByClass(CoreModule.class).isMaintenanceModeEnabled();
        }
        catch (ModuleNotFoundException | ServiceNotFoundException ex) {
            LOGGER.error("Having big troubles to get the ModuleManager service and CoreModule.", (Throwable)ex);
            return false;
        }
    }

    private void onlyRegisterForOpenSearchChangesWhenNecessary() {
        LOGGER.debug("onlyRegisterForOpenSearchChangesWhenNecessary");
        try {
            if (this.isMasterServer() && !this.isMaintenanceModeEnabled()) {
                this.registerForOpenSearchChanges();
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to register for OpenSearch changes.", (Throwable)ex);
        }
    }

    private class ReplicationModuleLoadedEventHandler
    extends AbstractBackendModuleLoadedEventHandler {
        private ReplicationModuleLoadedEventHandler() {
        }

        @Override
        public void processLoadedModule(Module module) {
            LOGGER.info("{}.processLoadedModule module=...", (Object)this.getClass().getSimpleName());
            LookupJoinsManagerImpl.this.onlyRegisterForOpenSearchChangesWhenNecessary();
        }
    }

    private class LogServiceModuleLoadedEventHandler
    extends AbstractBackendModuleLoadedEventHandler {
        private LogServiceModuleLoadedEventHandler() {
        }

        @Override
        public void processLoadedModule(Module module) {
            LOGGER.info("{}.processLoadedModule module=...", (Object)this.getClass().getSimpleName());
            LookupJoinsManagerImpl.this.onlyRegisterForOpenSearchChangesWhenNecessary();
        }
    }

    private class MaintenanceModeChangedEventHandler
    extends AbstractMaintenanceModeAcknowledgeEventHandler {
        public MaintenanceModeChangedEventHandler(BundleContext bundleContext) {
            super(bundleContext, "_core");
        }

        @Override
        public void processNewMaintenanceMode(boolean enabled) {
            LOGGER.info("{}.processNewMaintenanceMode enabled={}", (Object)this.getClass().getSimpleName(), (Object)enabled);
            try {
                if (enabled) {
                    LookupJoinsManagerImpl.this.unregisterFromOpenSearchChanges();
                } else if (LookupJoinsManagerImpl.this.isMasterServer()) {
                    LookupJoinsManagerImpl.this.registerForOpenSearchChanges();
                }
            }
            catch (Exception ex) {
                LOGGER.error(this.getClass().getSimpleName() + ": Failed to process the maintenance mode changed event.", (Throwable)ex);
            }
        }
    }

    private class MasterOrSlaveModeChangedEventHandler
    extends AbstractServerModeChangedEventHandler {
        private MasterOrSlaveModeChangedEventHandler() {
        }

        @Override
        public void processThisIsNowTheMasterServer(AbstractServerModeChangedEventHandler.ServerModeOfThisServerChangedEvent serverModeOfThisServerChangedEvent) {
            LOGGER.info("{}.processThisIsNowTheMasterServer serverModeOfThisServerChangedEvent={}", (Object)this.getClass().getSimpleName(), (Object)serverModeOfThisServerChangedEvent);
            try {
                if (!LookupJoinsManagerImpl.this.isMaintenanceModeEnabled()) {
                    LookupJoinsManagerImpl.this.registerForOpenSearchChanges();
                }
            }
            catch (Exception ex) {
                LOGGER.error(this.getClass().getSimpleName() + ": Failed to process the set this server as master event.", (Throwable)ex);
            }
        }

        @Override
        public void processThisIsNowASlaveServer(AbstractServerModeChangedEventHandler.ServerModeOfThisServerChangedEvent serverModeOfThisServerChangedEvent) {
            LOGGER.info("{}.processThisIsNowASlaveServer serverModeOfThisServerChangedEvent={}", (Object)this.getClass().getSimpleName(), (Object)serverModeOfThisServerChangedEvent);
            try {
                LookupJoinsManagerImpl.this.unregisterFromOpenSearchChanges();
            }
            catch (Exception ex) {
                LOGGER.error(this.getClass().getSimpleName() + ": Failed to process the set this server as slave event.", (Throwable)ex);
            }
        }
    }

    private class ReplicationModuleInstanceCreatedEventHandler
    extends AbstractEventHandler {
        private ReplicationModuleInstanceCreatedEventHandler() {
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            LookupJoinsManagerImpl.this.onlyRegisterForOpenSearchChangesWhenNecessary();
        }
    }

    private class ReplicationModuleInstanceUpdatedEventHandler
    extends AbstractSettingsUpdatedEventHandler {
        private ReplicationModuleInstanceUpdatedEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return this.isModuleUpdatedEventOfSettings(event, Arrays.asList("join"));
        }

        @Override
        public void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            LookupJoinsManagerImpl.this.onlyRegisterForOpenSearchChangesWhenNecessary();
        }
    }

    private class ReplicationModuleInstanceDeletedEventHandler
    extends AbstractEventHandler {
        private ReplicationModuleInstanceDeletedEventHandler() {
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            LookupJoinsManagerImpl.this.onlyRegisterForOpenSearchChangesWhenNecessary();
        }
    }

    private class LogServiceModuleInstanceCreatedEventHandler
    extends AbstractEventHandler {
        private LogServiceModuleInstanceCreatedEventHandler() {
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            LookupJoinsManagerImpl.this.onlyRegisterForOpenSearchChangesWhenNecessary();
        }
    }

    private class LogServiceModuleInstanceUpdatedEventHandler
    extends AbstractSettingsUpdatedEventHandler {
        private LogServiceModuleInstanceUpdatedEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return this.isModuleUpdatedEventOfSettings(event, Arrays.asList("joins"));
        }

        @Override
        public void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            LookupJoinsManagerImpl.this.onlyRegisterForOpenSearchChangesWhenNecessary();
        }
    }

    private class LogServiceModuleInstanceDeletedEventHandler
    extends AbstractEventHandler {
        private LogServiceModuleInstanceDeletedEventHandler() {
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            LookupJoinsManagerImpl.this.onlyRegisterForOpenSearchChangesWhenNecessary();
        }
    }
}

