/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.multipart;

import de.virtimo.bpc.api.multipart.UploadedBundleFile;
import de.virtimo.bpc.api.multipart.UploadedFile;
import de.virtimo.bpc.core.multipart.UploadedFileImpl;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.osgi.framework.BundleException;

public class UploadedBundleFileImpl
extends UploadedFileImpl
implements UploadedBundleFile {
    private String symbolicName;
    private boolean symbolicNameAlreadyEvaluated = false;

    public UploadedBundleFileImpl(Attachment attachment) throws IOException {
        super(attachment);
    }

    public UploadedBundleFileImpl(UploadedFile uploadedFile) throws IOException {
        super(uploadedFile);
    }

    @Override
    public String getSymbolicName() throws IOException, BundleException {
        if (!this.symbolicNameAlreadyEvaluated) {
            this.symbolicNameAlreadyEvaluated = true;
            this.symbolicName = this.getSymbolicNameOfBundle(this.getInputStream());
        }
        return this.symbolicName;
    }

    private String getSymbolicNameOfBundle(InputStream inputStream) throws IOException, BundleException {
        try (JarInputStream jar = new JarInputStream(inputStream);){
            Manifest m = jar.getManifest();
            if (m == null) {
                throw new BundleException("The uploaded bundle file " + this.getFileName() + " does not have a META-INF/MANIFEST.MF!");
            }
            String bundleSymbolicName = m.getMainAttributes().getValue("Bundle-SymbolicName");
            if (!StringUtil.isNullOrEmpty(bundleSymbolicName)) {
                String bundleSymbolicNameWithoutParameters;
                List<String> exploded = StringUtil.explode(bundleSymbolicName, ";");
                String string = bundleSymbolicNameWithoutParameters = exploded.get(0);
                return string;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "UploadedBundleFileImpl{symbolicNameAlreadyEvaluated=" + this.symbolicNameAlreadyEvaluated + ", attachmentName='" + this.attachmentName + "', fileName='" + this.fileName + "', contentType=" + String.valueOf(this.contentType) + ", symbolicName='" + this.symbolicName + "', temporaryContentFile=" + String.valueOf(this.temporaryContentFile) + "}";
    }
}

