/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch;

import de.virtimo.bpc.api.ConnectionTestException;
import de.virtimo.bpc.api.ConnectionTester;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.NoSuitableConnectionTesterFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectionTesters {
    private static final Logger LOGGER = LogManager.getLogger(ConnectionTesters.class);
    private final List<ConnectionTester> connectionTesters = new ArrayList<ConnectionTester>();

    public void destroy() {
        LOGGER.info("destroy");
        for (ConnectionTester connectionTester : this.connectionTesters) {
            connectionTester.destroy();
        }
        this.connectionTesters.clear();
    }

    public List<ConnectionTester> getAll() {
        return new ArrayList<ConnectionTester>(this.connectionTesters);
    }

    public void set(ConnectionTester connectionTester) {
        LOGGER.info("set connectionTester={}", (Object)connectionTester);
        if (connectionTester != null) {
            final String newConnectionTesterClassName = connectionTester.getClass().getName();
            this.connectionTesters.removeIf(new Predicate<ConnectionTester>(){

                @Override
                public boolean test(ConnectionTester connectionTester) {
                    return newConnectionTesterClassName.equals(connectionTester.getClass().getName());
                }
            });
            this.connectionTesters.add(connectionTester);
        }
    }

    public void remove(ConnectionTester connectionTester) {
        LOGGER.info("remove connectionTester={}", (Object)connectionTester);
        if (connectionTester != null) {
            final String newConnectionTesterClassName = connectionTester.getClass().getName();
            this.connectionTesters.removeIf(new Predicate<ConnectionTester>(){

                @Override
                public boolean test(ConnectionTester connectionTester) {
                    return newConnectionTesterClassName.equals(connectionTester.getClass().getName());
                }
            });
        }
    }

    public void performConnectionTest(ModuleInstance moduleInstance, Map<String, Object> testData) throws NoSuitableConnectionTesterFoundException, ConnectionTestException {
        LOGGER.info("performConnectionTest moduleInstance=..., testData=...");
        boolean connectionTesterExists = false;
        for (ConnectionTester connectionTester : this.getAll()) {
            if (!connectionTester.canBeUsedToPerformConnectionTest(moduleInstance)) continue;
            connectionTesterExists = true;
            connectionTester.performConnectionTest(moduleInstance, testData);
            break;
        }
        if (!connectionTesterExists) {
            throw new NoSuitableConnectionTesterFoundException(moduleInstance);
        }
    }
}

