/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch;

import de.virtimo.bpc.Destroyable;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.opensearch.ManagedIndexConfig;
import de.virtimo.bpc.api.opensearch.ManagedIndicesHandler;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.ManagedIndexConfigs;
import de.virtimo.bpc.core.utils.BpcBundleUtil;
import de.virtimo.bpc.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class ManagedIndicesHandlerImpl
implements ManagedIndicesHandler,
Destroyable,
BundleListener {
    private static final Logger LOGGER = LogManager.getLogger(ManagedIndicesHandlerImpl.class);
    private final BundleContext bundleContext;
    private OpenSearchService oss;
    private final Map<String, ManagedIndexConfigs> bundleSymbolicNameAndManagedIndexConfigs;
    private static final Object MANAGED_INDEX_CONFIGS_CONTAINER_LOCK = new Object();

    public ManagedIndicesHandlerImpl(BundleContext bundleContext, OpenSearchService oss) {
        this.bundleContext = bundleContext;
        this.oss = oss;
        this.bundleSymbolicNameAndManagedIndexConfigs = new HashMap<String, ManagedIndexConfigs>();
        if (bundleContext == null) {
            LOGGER.warn("Failed to add bundle listener due to missing BundleContext. Maybe a unit or integration test?");
        } else {
            bundleContext.addBundleListener((BundleListener)this);
        }
        if (bundleContext == null) {
            LOGGER.warn("Failed to prepare the managed indices of all registered BPC bundles due to missing BundleContext. Maybe a unit or integration test?");
        } else {
            this.prepareManagedIndicesOfAllBpcBackendBundles();
        }
    }

    @Override
    public void destroy() {
        LOGGER.debug("destroy");
        if (this.bundleContext != null) {
            this.bundleContext.removeBundleListener((BundleListener)this);
        }
        this.oss = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedIndexConfig getManagedIndexConfig(String indexAliasName) {
        LOGGER.info("getManagedIndexConfigFromAllBpcBackendBundles indexAliasName={}", (Object)indexAliasName);
        if (StringUtil.isNullOrEmpty(indexAliasName)) {
            return null;
        }
        Object object = MANAGED_INDEX_CONFIGS_CONTAINER_LOCK;
        synchronized (object) {
            return this._getManagedIndexConfig(indexAliasName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIndexWithHiddenFlag(Set<String> aliases) {
        Object object = MANAGED_INDEX_CONFIGS_CONTAINER_LOCK;
        synchronized (object) {
            for (String indexAlias : aliases) {
                ManagedIndexConfig managedIndexConfig = this._getManagedIndexConfig(indexAlias);
                if (managedIndexConfig == null || !managedIndexConfig.isHidden()) continue;
                return true;
            }
        }
        return false;
    }

    private ManagedIndexConfig _getManagedIndexConfig(String indexAliasName) {
        LOGGER.info("_getManagedIndexConfig indexAliasName={}", (Object)indexAliasName);
        for (ManagedIndexConfigs manageIndexConfigsOfBundle : this.bundleSymbolicNameAndManagedIndexConfigs.values()) {
            for (ManagedIndexConfig managedIndexConfig : manageIndexConfigsOfBundle) {
                if (!managedIndexConfig.canBeUsedForExactAliasName(indexAliasName)) continue;
                return managedIndexConfig;
            }
        }
        for (ManagedIndexConfigs manageIndexConfigsOfBundle : this.bundleSymbolicNameAndManagedIndexConfigs.values()) {
            for (ManagedIndexConfig managedIndexConfig : manageIndexConfigsOfBundle) {
                if (!managedIndexConfig.canBeUsedMatchingWildcard(indexAliasName)) continue;
                return managedIndexConfig;
            }
        }
        return null;
    }

    @Override
    public boolean isManagedIndex(String indexAliasName) {
        return this.getManagedIndexConfig(indexAliasName) != null;
    }

    @Override
    public String createManagedIndex(String indexAliasName) throws OpenSearchRelatedException {
        LOGGER.info("createManagedIndex indexAliasName={}", (Object)indexAliasName);
        return this.createManagedIndex(indexAliasName, null, true);
    }

    @Override
    public Map<String, String> createManagedIndices(Set<String> indexAliasNames) throws OpenSearchRelatedException {
        LOGGER.info("createManagedIndices indexAliasNames={}", indexAliasNames);
        HashMap<String, String> aliasAndCreatedIndexNames = new HashMap<String, String>();
        if (indexAliasNames != null && !indexAliasNames.isEmpty()) {
            for (String indexAliasName : indexAliasNames) {
                String nameOfCreatedIndex = this.createManagedIndex(indexAliasName, null, true);
                aliasAndCreatedIndexNames.put(indexAliasName, nameOfCreatedIndex);
            }
        }
        return aliasAndCreatedIndexNames;
    }

    @Override
    public String createManagedIndex(String indexAliasName, String indexName, boolean addAlias) throws OpenSearchRelatedException {
        LOGGER.info("createManagedIndex indexAliasName={}, indexName={}, addAlias={}", (Object)indexAliasName, (Object)indexName, (Object)addAlias);
        ManagedIndexConfig indexConfiguration = this.getManagedIndexConfig(indexAliasName);
        Map<String, Object> settings = null;
        if (indexConfiguration != null && indexConfiguration.hasSettings()) {
            settings = indexConfiguration.getSettings();
        }
        if (settings == null) {
            settings = this.oss.getDefaultIndexCreationSettings();
        }
        Map<String, Object> mappings = null;
        if (indexConfiguration != null && indexConfiguration.hasMappings()) {
            mappings = indexConfiguration.getMappings();
        }
        return this.oss.createIndex(addAlias ? indexAliasName : null, indexName, settings, mappings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareManagedIndicesOfAllBpcBackendBundles() {
        LOGGER.info("prepareManagedIndicesOfAllBpcBackendBundles");
        Object object = MANAGED_INDEX_CONFIGS_CONTAINER_LOCK;
        synchronized (object) {
            for (Bundle bundle : this.bundleContext.getBundles()) {
                if (bundle.getState() != 32 || !BpcBundleUtil.isBpcBackendBundle(bundle)) continue;
                ManagedIndexConfigs managedIndexConfigs = this._cacheManageIndexConfigsFromBundle(bundle);
                try {
                    this._prepareManagedIndices(managedIndexConfigs);
                }
                catch (OpenSearchRelatedException ex) {
                    LOGGER.error("Error while preparing managed indices of bundle: " + bundle.getSymbolicName(), (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareManagedIndices(Bundle bundle) throws OpenSearchRelatedException {
        LOGGER.info("prepareManagedIndices bundle=...");
        Object object = MANAGED_INDEX_CONFIGS_CONTAINER_LOCK;
        synchronized (object) {
            ManagedIndexConfigs managedIndexConfigs = this._cacheManageIndexConfigsFromBundle(bundle);
            this._prepareManagedIndices(managedIndexConfigs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareManagedIndices(Map<String, Object> managedIndicesConfigMap) throws OpenSearchRelatedException {
        LOGGER.info("prepareManagedIndices managedIndicesConfigMap=...");
        Object object = MANAGED_INDEX_CONFIGS_CONTAINER_LOCK;
        synchronized (object) {
            ManagedIndexConfigs managedIndexConfigs = new ManagedIndexConfigs(managedIndicesConfigMap);
            this._prepareManagedIndices(managedIndexConfigs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareManagedIndices(String bundleSymbolicName, Map<String, Object> managedIndicesConfigMap) throws OpenSearchRelatedException {
        LOGGER.info("prepareManagedIndices bundleSymbolicName={}, managedIndicesConfigMap=...", (Object)bundleSymbolicName);
        Object object = MANAGED_INDEX_CONFIGS_CONTAINER_LOCK;
        synchronized (object) {
            ManagedIndexConfigs managedIndexConfigs = new ManagedIndexConfigs(managedIndicesConfigMap);
            if (!managedIndexConfigs.isEmpty()) {
                this.bundleSymbolicNameAndManagedIndexConfigs.put(bundleSymbolicName, managedIndexConfigs);
                this._prepareManagedIndices(managedIndexConfigs);
            }
        }
    }

    private void _prepareManagedIndices(ManagedIndexConfigs managedIndexConfigs) throws OpenSearchRelatedException {
        LOGGER.info("_prepareManagedIndices managedIndexConfigs=...");
        if (managedIndexConfigs != null) {
            for (ManagedIndexConfig managedIndexConfig : managedIndexConfigs) {
                if (!managedIndexConfig.isCreateOnStart()) continue;
                String aliasName = managedIndexConfig.getAliasName();
                if (aliasName != null && !this.oss.existsIndex(aliasName) && this.oss.getIndexNamesWithAlias(aliasName).isEmpty()) {
                    LOGGER.debug("No index or alias with name {} found. Create index now.", (Object)aliasName);
                    this.oss.createIndex(aliasName, managedIndexConfig.getSettings(), managedIndexConfig.getMappings());
                    continue;
                }
                LOGGER.info("Skip creation of existing index or alias {}", (Object)aliasName);
            }
        }
    }

    private ManagedIndexConfigs _cacheManageIndexConfigsFromBundle(Bundle bundle) {
        LOGGER.info("_cacheManageIndexConfigsFromBundle bundle={}", (Object)bundle);
        ManagedIndexConfigs managedIndexConfigs = new ManagedIndexConfigs(bundle);
        if (!managedIndexConfigs.isEmpty()) {
            this.bundleSymbolicNameAndManagedIndexConfigs.put(bundle.getSymbolicName(), managedIndexConfigs);
        }
        return managedIndexConfigs;
    }

    private void _uncacheManageIndexConfigsOfBundle(String moduleBundleSymbolicName) {
        LOGGER.info("_uncacheManageIndexConfigsOfBundle moduleBundleSymbolicName={}", (Object)moduleBundleSymbolicName);
        this.bundleSymbolicNameAndManagedIndexConfigs.remove(moduleBundleSymbolicName);
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        LOGGER.debug("bundleChanged bundleEvent=...");
        Bundle bundle = bundleEvent.getBundle();
        if (!BpcBundleUtil.isBpcBackendBundle(bundle)) {
            return;
        }
        if (BpcBundleUtil.isBpcBackendCoreBundle(bundle)) {
            return;
        }
        switch (bundleEvent.getType()) {
            case 2: {
                LOGGER.info("Found started backend bundle, caching and preparing managed indices of bundle: {}", (Object)bundle);
                this.processBpcBundleStartedEvent(bundle);
                break;
            }
            case 4: 
            case 16: {
                LOGGER.info("Found stopped/uninstalled backend bundle, removing cached managed indices of bundle: {}", (Object)bundle);
                this.processBpcBundleStoppedEvent(bundle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBpcBundleStartedEvent(Bundle bundle) {
        LOGGER.info("processBpcBundleStartedEvent bundle={}", (Object)bundle);
        Object object = MANAGED_INDEX_CONFIGS_CONTAINER_LOCK;
        synchronized (object) {
            try {
                ManagedIndexConfigs managedIndexConfigs = this._cacheManageIndexConfigsFromBundle(bundle);
                this._prepareManagedIndices(managedIndexConfigs);
            }
            catch (OpenSearchRelatedException ex) {
                LOGGER.error("Error while preparing managed indices of bundle: {}", (Object)bundle.getSymbolicName(), (Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBpcBundleStoppedEvent(Bundle bundle) {
        LOGGER.info("processBpcBundleStoppedEvent bundle={}", (Object)bundle);
        Object object = MANAGED_INDEX_CONFIGS_CONTAINER_LOCK;
        synchronized (object) {
            this._uncacheManageIndexConfigsOfBundle(bundle.getSymbolicName());
        }
    }
}

