/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;

public class BpcConfigurationIndexMigrationFromModelVersion26To27
extends AllSearchHitsMigration {
    private static final Logger LOGGER = LogManager.getLogger(BpcConfigurationIndexMigrationFromModelVersion26To27.class);
    private static final Set<String> UNUSED_SETTINGS = Set.of("inubit_actionEndpoint", "inubit_changeStateEndpoint", "inubit_VpsEndpoint", "inubit_aperakEndPoint", "inubit_dbGridId", "inubit_pmMandant", "function_interactionColumn", "function_interactionFormId");

    public BpcConfigurationIndexMigrationFromModelVersion26To27(OpenSearchService oss) {
        super(oss, 27);
    }

    @Override
    List<IndexRequest> migrateSearchHit(RestHighLevelClient osClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        if (!hit.getId().equals(sourceValues.get("id"))) {
            LOGGER.warn("Skipping document with ID mismatch: {} != {}", (Object)hit.getId(), sourceValues.get("id"));
            return null;
        }
        String settingName = (String)sourceValues.get("name");
        String moduleId = (String)sourceValues.get("moduleId");
        if (!"monitor".equals(moduleId)) {
            if ("_core".equals(moduleId) && "guiModules".equals(settingName)) {
                return null;
            }
            if ("plugin_configuration".equals(settingName) && "_core".equals(moduleId)) {
                ArrayList pluginConfiguration = (ArrayList)sourceValues.get("value");
                pluginConfiguration.add((HashMap)this.getPluginConfig("bpcNotification"));
                sourceValues.put("value", pluginConfiguration);
            }
            return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
        }
        if ("function_changeStateConfig".equals(settingName)) {
            return this.migrateChangeStateConfig(hit.getId(), sourceValues, newIndex.getName());
        }
        if ("actionEndpointProcessor".equals(settingName)) {
            return this.migrateProcessorSetting(osClient, oldIndex, newIndex, hit.getId(), sourceValues, "inubit_actionEndpoint", "actionEndpointProcessor");
        }
        if ("vpsEndpointProcessor".equals(settingName)) {
            return this.migrateProcessorSetting(osClient, oldIndex, newIndex, hit.getId(), sourceValues, "inubit_VpsEndpoint", "vpsEndpointProcessor");
        }
        if ("changeStateEndpointProcessor".equals(settingName)) {
            return this.migrateProcessorSetting(osClient, oldIndex, newIndex, hit.getId(), sourceValues, "inubit_changeStateEndpoint", "changeStateEndpointProcessor");
        }
        if (UNUSED_SETTINGS.contains(settingName)) {
            return null;
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
    }

    private List<IndexRequest> migrateChangeStateConfig(String settingId, Map<String, Object> sourceValues, String newIndexName) {
        Object value = sourceValues.get("value");
        if (!(value instanceof List)) {
            LOGGER.warn("Skipping 'function_changeStateConfig' migration for setting '{}' because its value is not a list.", (Object)settingId);
            return Collections.singletonList(new IndexRequest(newIndexName).id(settingId).source(sourceValues, (MediaType)XContentType.JSON));
        }
        try {
            List configList = (List)value;
            boolean modified = false;
            for (Map item : configList) {
                if (!item.containsKey("childStatus")) continue;
                Object childStatusValue = item.remove("childStatus");
                HashMap metadata = new HashMap();
                metadata.put("childStatus", childStatusValue);
                item.put("metadata", metadata);
                modified = true;
            }
            if (modified) {
                LOGGER.info("Migrated 'function_changeStateConfig' for setting ID '{}': moved 'childStatus' to metadata.", (Object)settingId);
            }
        }
        catch (ClassCastException e) {
            LOGGER.error("Failed to process 'function_changeStateConfig' with ID '{}' due to unexpected data structure. Copying original.", (Object)settingId, (Object)e);
        }
        return Collections.singletonList(new IndexRequest(newIndexName).id(settingId).source(sourceValues, (MediaType)XContentType.JSON));
    }

    private List<IndexRequest> migrateProcessorSetting(RestHighLevelClient osClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, String settingId, Map<String, Object> sourceValues, String oldEndpointName, String newProcessorName) {
        String instanceId = (String)sourceValues.get("instanceId");
        String proxyId = this.queryMonitorSettingValueFromIndex(osClient, oldIndex.getName(), instanceId, "inubit_proxyId");
        if (proxyId == null || proxyId.isBlank()) {
            LOGGER.warn("No inubit_proxyId found for instanceId {}. Skipping migration.", (Object)instanceId);
            return Collections.singletonList(new IndexRequest(newIndex.getName()).id(settingId).source(sourceValues, (MediaType)XContentType.JSON));
        }
        boolean proxyInstanceExists = this.doesModuleInstanceExistInIndex(osClient, oldIndex.getName(), "backendconnection", proxyId);
        if (!proxyInstanceExists) {
            LOGGER.warn("'{}' for instanceId '{}' was migrated successfully but 'Backend Connections' Module instance with ID '{}' was not found in the index.", (Object)newProcessorName, (Object)instanceId, (Object)proxyId);
        }
        String baseUrl = this.queryMonitorSettingValueFromIndex(osClient, oldIndex.getName(), instanceId, "inubit_baseUrl");
        String endpoint = this.queryMonitorSettingValueFromIndex(osClient, oldIndex.getName(), instanceId, oldEndpointName);
        String bpcUrl = "bpc://backendconnection/%s%s%s".formatted(proxyId, baseUrl, endpoint);
        String moduleId = (String)sourceValues.get("moduleId");
        String instanceType = (String)sourceValues.get("instanceType");
        String newSettingId = this.createV1SettingId(moduleId, instanceId, newProcessorName);
        Map<String, Object> newSettingMap = this.createV1SettingMap(newSettingId, moduleId, instanceId, instanceType, newProcessorName, "text", bpcUrl);
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(newSettingId).source(newSettingMap, (MediaType)XContentType.JSON));
    }

    private String queryMonitorSettingValueFromIndex(RestHighLevelClient osClient, String indexName, String instanceId, String settingName) {
        try {
            String identityProviderSettingId = this.createV1SettingId("monitor", instanceId, settingName);
            SearchRequest request = new SearchRequest().indices(indexName).source(new SearchSourceBuilder().query(QueryBuilders.termQuery("id", identityProviderSettingId)));
            SearchResponse response = osClient.search(request, RequestOptions.DEFAULT);
            SearchHit[] hits = response.getHits().getHits();
            return hits == null || hits.length == 0 ? null : (String)hits[0].getSourceAsMap().get("value");
        }
        catch (Exception ex) {
            return null;
        }
    }

    private boolean doesModuleInstanceExistInIndex(RestHighLevelClient osClient, String indexName, String moduleId, String instanceId) {
        if (instanceId == null || instanceId.isBlank()) {
            return false;
        }
        try {
            SearchRequest request = new SearchRequest(indexName);
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            sourceBuilder.query(QueryBuilders.boolQuery().must(QueryBuilders.termQuery("moduleId", moduleId)).must(QueryBuilders.termQuery("instanceId", instanceId)));
            sourceBuilder.size(0);
            sourceBuilder.fetchSource(false);
            request.source(sourceBuilder);
            SearchResponse response = osClient.search(request, RequestOptions.DEFAULT);
            return Objects.requireNonNull(response.getHits().getTotalHits()).value() > 0L;
        }
        catch (IOException e) {
            LOGGER.error("Error while checking for existence of module instance '{}' (module '{}') in index '{}'", (Object)instanceId, (Object)moduleId, (Object)indexName, (Object)e);
            return false;
        }
    }

    private Map<String, Object> getPluginConfig(String pluginName) {
        HashMap<String, Object> pluginConfig = new HashMap<String, Object>();
        pluginConfig.put("hook", "core_global_application_toolbar_right");
        pluginConfig.put("plugin", pluginName);
        pluginConfig.put("sourceModule", "_core");
        return pluginConfig;
    }
}

