/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.search.SearchHit;

public class BpcConfigurationIndexMigrationFromModelVersion28To29
extends AllSearchHitsMigration {
    private static final Logger LOGGER = LogManager.getLogger(BpcConfigurationIndexMigrationFromModelVersion28To29.class);
    private static final String SETTING_NAME = "apiKeys";
    private static final String MODULE_ID = "_core";
    private static final String INSTANCE_ID = "noinstance";
    private static final String VALUE_TYPE = "json";
    private static final String FORMS_RENDERER_URL_SETTING_NAME = "rendererUrl";
    private static final String FORMS_MODULE_ID = "forms";
    private static final String FORMS_INSTANCE_ID = "noinstance";

    public BpcConfigurationIndexMigrationFromModelVersion28To29(OpenSearchService oss) {
        super(oss, 29);
    }

    @Override
    List<IndexRequest> migrateSearchHit(RestHighLevelClient osClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        if (!hit.getId().equals(sourceValues.get("id"))) {
            LOGGER.warn("Skipping document with ID mismatch: {} != {}", (Object)hit.getId(), sourceValues.get("id"));
            return null;
        }
        String settingName = (String)sourceValues.get("name");
        String moduleId = (String)sourceValues.get("moduleId");
        String instanceId = (String)sourceValues.get("instanceId");
        String valueType = (String)sourceValues.get("type");
        if (FORMS_RENDERER_URL_SETTING_NAME.equals(settingName) && "noinstance".equals(instanceId) && MODULE_ID.equals(moduleId) && VALUE_TYPE.equals(valueType)) {
            return this.migrateApiKeysToList(newIndex, sourceValues);
        }
        if (SETTING_NAME.equals(settingName) && "noinstance".equals(instanceId) && FORMS_MODULE_ID.equals(moduleId)) {
            sourceValues.put("value", "bpc-forms-renderer/index.html");
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
    }

    private List<IndexRequest> migrateApiKeysToList(IndexToMigrate newIndex, Map<String, Object> sourceValues) {
        String settingName = (String)sourceValues.get("name");
        String moduleId = (String)sourceValues.get("moduleId");
        String instanceId = (String)sourceValues.get("instanceId");
        String instanceType = (String)sourceValues.get("instanceType");
        ArrayList apiKeyList = new ArrayList();
        Object value = sourceValues.get("value");
        if (value instanceof Map) {
            Map valueMap = (Map)value;
            for (String key : valueMap.keySet()) {
                Object apiKeyObj = valueMap.get(key);
                if (!(apiKeyObj instanceof Map)) continue;
                Map apiKeyValueMap = (Map)apiKeyObj;
                HashMap<String, String> newApiKeyValueMap = new HashMap<String, String>(apiKeyValueMap);
                newApiKeyValueMap.put("apiKey", key);
                apiKeyList.add(newApiKeyValueMap);
            }
        }
        String newSettingId = this.createV1SettingId(moduleId, instanceId, settingName);
        Map<String, Object> newSettingMap = this.createV1SettingMap(newSettingId, moduleId, instanceId, instanceType, settingName, VALUE_TYPE, apiKeyList);
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(newSettingId).source(newSettingMap, (MediaType)XContentType.JSON));
    }
}

