/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.search.SearchHit;

public class BpcConfigurationIndexMigrationFromModelVersion29To30
extends AllSearchHitsMigration {
    private static final Logger LOGGER = LogManager.getLogger(BpcConfigurationIndexMigrationFromModelVersion29To30.class);
    private static final String SETTING_NAME_ENDPOINT = "fileStorageEndpointUrl";
    private static final String SETTING_NAME_REGION = "fileStorageCloudRegion";
    private static final String SETTING_NAME_ACCESS_KEY = "fileStorageCredentialsKey";
    private static final String SETTING_NAME_SECRET_KEY = "fileStorageCredentialsSecret";
    private static final String SETTING_NAME_AWS_ENDPOINT = "fileStorageAwsEndpointUrl";
    private static final String SETTING_NAME_AWS_REGION = "fileStorageAwsCloudRegion";
    private static final String SETTING_NAME_AWS_ACCESS_KEY = "fileStorageAwsCredentialsKey";
    private static final String SETTING_NAME_AWS_SECRET_KEY = "fileStorageAwsCredentialsSecret";
    private static final String SETTING_NAME_STORAGE_TYPE = "fileStorageType";
    private static final String MODULE_ID = "backendconnection";
    private static final String INSTANCE_TYPE = "file_storage";

    public BpcConfigurationIndexMigrationFromModelVersion29To30(OpenSearchService oss) {
        super(oss, 30);
    }

    @Override
    List<IndexRequest> migrateSearchHit(RestHighLevelClient osClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        if (!hit.getId().equals(sourceValues.get("id"))) {
            LOGGER.warn("Skipping document with ID mismatch: {} != {}", (Object)hit.getId(), sourceValues.get("id"));
            return null;
        }
        String settingName = (String)sourceValues.get("name");
        String moduleId = (String)sourceValues.get("moduleId");
        String instanceType = (String)sourceValues.get("instanceType");
        String instanceId = (String)sourceValues.get("instanceId");
        if (MODULE_ID.equals(moduleId) && INSTANCE_TYPE.equals(instanceType)) {
            if (SETTING_NAME_ENDPOINT.equals(settingName)) {
                List<IndexRequest> renamedEndpointUrlSetting = this.renameSetting(newIndex, sourceValues, SETTING_NAME_AWS_ENDPOINT, moduleId, instanceId, instanceType);
                List<IndexRequest> newStorageTypeSetting = this.createS3TypeSetting(newIndex, moduleId, instanceId, instanceType);
                ArrayList<IndexRequest> newSettings = new ArrayList<IndexRequest>(renamedEndpointUrlSetting);
                newSettings.addAll(newStorageTypeSetting);
                return newSettings;
            }
            if (SETTING_NAME_REGION.equals(settingName)) {
                return this.renameSetting(newIndex, sourceValues, SETTING_NAME_AWS_REGION, moduleId, instanceId, instanceType);
            }
            if (SETTING_NAME_ACCESS_KEY.equals(settingName)) {
                return this.renameSetting(newIndex, sourceValues, SETTING_NAME_AWS_ACCESS_KEY, moduleId, instanceId, instanceType);
            }
            if (SETTING_NAME_SECRET_KEY.equals(settingName)) {
                return this.renameSetting(newIndex, sourceValues, SETTING_NAME_AWS_SECRET_KEY, moduleId, instanceId, instanceType);
            }
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
    }

    private List<IndexRequest> createS3TypeSetting(IndexToMigrate newIndex, String moduleId, String instanceId, String instanceType) {
        String newSettingId = this.createV1SettingId(moduleId, instanceId, SETTING_NAME_STORAGE_TYPE);
        Map<String, Object> newSettingMap = this.createV1SettingMap(newSettingId, moduleId, instanceId, instanceType, SETTING_NAME_AWS_ENDPOINT, "list", "s3");
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(newSettingId).source(newSettingMap, (MediaType)XContentType.JSON));
    }

    private List<IndexRequest> renameSetting(IndexToMigrate newIndex, Map<String, Object> sourceValues, String newSettingName, String moduleId, String instanceId, String instanceType) {
        String type = (String)sourceValues.get("type");
        String value = (String)sourceValues.get("value");
        String newSettingId = this.createV1SettingId(moduleId, instanceId, newSettingName);
        Map<String, Object> newSettingMap = this.createV1SettingMap(newSettingId, moduleId, instanceId, instanceType, newSettingName, type, value);
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(newSettingId).source(newSettingMap, (MediaType)XContentType.JSON));
    }
}

