/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.exception.IndexMigrationException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.opensearch.migration.BpcAuditlogIndexMigrationFromModelVersion1To2;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion10To11;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion11To12;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion12To13;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion13To14;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion14To15;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion15To16;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion16To17;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion17To18;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion18To19;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion19To20;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion20To21;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion21To22;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion22To23;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion23To24;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion24To25;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion25To26;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion26To27;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion27To28;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion28To29;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion29To30;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion6To7;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion7To8;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion8To9;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion9To10;
import de.virtimo.bpc.core.opensearch.migration.BpcNotificationIndexMigrationFromModelVersion1To2;
import de.virtimo.bpc.core.opensearch.migration.BpcNotificationIndexMigrationFromModelVersion2To3;
import de.virtimo.bpc.core.opensearch.migration.BpcNotificationIndexMigrationFromModelVersion3To4;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import de.virtimo.bpc.util.ListUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BpcIndicesMigrator {
    private static final Logger LOGGER = LogManager.getLogger(BpcIndicesMigrator.class);
    private final OpenSearchService oss;
    private final List<MigratableIndex> migratableIndices;

    public BpcIndicesMigrator(OpenSearchService oss) {
        this.oss = oss;
        this.migratableIndices = ListUtil.listOf(new MigratableIndex("bpc-configuration", BpcIndicesMigrator.getLowestSupportedModelVersionOfBpcConfigurationIndex(), BpcIndicesMigrator.getCurrentModelVersionOfBpcConfigurationIndex()), new MigratableIndex("bpc-notification", BpcIndicesMigrator.getLowestSupportedModelVersionOfBpcNotificationIndex(), BpcIndicesMigrator.getCurrentModelVersionOfBpcNotificationIndex()), new MigratableIndex("bpc-auditlog", BpcIndicesMigrator.getLowestSupportedModelVersionOfBpcAuditlogIndex(), BpcIndicesMigrator.getCurrentModelVersionOfBpcAuditlogIndex()));
    }

    public boolean isMigratableIndex(Set<String> aliasesOfIndex) {
        return this.getMigratableIndex(aliasesOfIndex) != null;
    }

    public boolean mustBeMigrated(Set<String> aliasesOfIndex) {
        MigratableIndex migratableIndex = this.getMigratableIndex(aliasesOfIndex);
        if (migratableIndex == null) {
            return false;
        }
        int currentModelVersion = this.oss.getModelVersion(migratableIndex.aliasOfIndex());
        return currentModelVersion < migratableIndex.latestModelVersion();
    }

    private MigratableIndex getMigratableIndex(Set<String> aliasesOfIndex) {
        if (aliasesOfIndex == null) {
            return null;
        }
        if (aliasesOfIndex.size() != 1) {
            return null;
        }
        return this.getMigratableIndex(aliasesOfIndex.iterator().next());
    }

    private MigratableIndex getMigratableIndex(String aliasOfIndex) {
        if (StringUtil.isNullOrEmpty(aliasOfIndex)) {
            return null;
        }
        for (MigratableIndex migratableIndex : this.migratableIndices) {
            if (!aliasOfIndex.equals(migratableIndex.aliasOfIndex())) continue;
            return migratableIndex;
        }
        return null;
    }

    public String migrateBpcConfigurationIndex() throws IndexMigrationException, OpenSearchRelatedException {
        LOGGER.info("migrateBpcConfigurationIndex");
        return this.migrateBpcConfigurationIndex("bpc-configuration");
    }

    public static int getLowestSupportedModelVersionOfBpcConfigurationIndex() {
        return 6;
    }

    public static int getCurrentModelVersionOfBpcConfigurationIndex() {
        return 30;
    }

    public String migrateBpcConfigurationIndex(String aliasName) throws IndexMigrationException, OpenSearchRelatedException {
        LOGGER.info("migrateBpcConfigurationIndex aliasName={}", (Object)aliasName);
        int toModelVersion = BpcIndicesMigrator.getCurrentModelVersionOfBpcConfigurationIndex();
        if (!this.oss.existsIndex(aliasName)) {
            LOGGER.info("Migration not necessary for [{}]. Does not exist.", (Object)aliasName);
            return null;
        }
        String indexName = this.getTheOneAndOnlyIndexNameForAlias(aliasName);
        int currentModelVersion = this.oss.getModelVersion(aliasName);
        if (currentModelVersion == toModelVersion) {
            LOGGER.info("Migration not necessary for [{}]. Uses already the required model version: {}", (Object)aliasName, (Object)toModelVersion);
            return indexName;
        }
        this.checkFutureModelVersion(aliasName, currentModelVersion, toModelVersion);
        LOGGER.warn("Migration necessary. The current [{}] model version is '{}' and required is '{}'.", (Object)aliasName, (Object)currentModelVersion, (Object)toModelVersion);
        IndexToMigrate nextIndexToMigrate = new IndexToMigrate(aliasName, indexName);
        if (currentModelVersion == 6) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion6To7(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 7) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion7To8(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 8) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion8To9(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 9) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion9To10(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 10) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion10To11(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 11) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion11To12(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 12) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion12To13(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 13) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion13To14(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 14) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion14To15(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 15) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion15To16(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 16) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion16To17(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 17) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion17To18(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 18) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion18To19(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 19) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion19To20(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 20) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion20To21(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 21) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion21To22(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 22) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion22To23(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 23) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion23To24(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 24) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion24To25(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 25) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion25To26(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 26) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion26To27(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 27) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion27To28(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 28) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion28To29(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 29) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion29To30(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 30) {
            // empty if block
        }
        return nextIndexToMigrate.getName();
    }

    public String migrateBpcNotificationIndex() throws IndexMigrationException, OpenSearchRelatedException {
        LOGGER.info("migrateBpcNotificationIndex");
        return this.migrateBpcNotificationIndex("bpc-notification");
    }

    public static int getLowestSupportedModelVersionOfBpcNotificationIndex() {
        return 0;
    }

    public static int getCurrentModelVersionOfBpcNotificationIndex() {
        return 4;
    }

    public String migrateBpcNotificationIndex(String aliasName) throws IndexMigrationException, OpenSearchRelatedException {
        LOGGER.info("migrateBpcNotificationIndex aliasName={}", (Object)aliasName);
        int toModelVersion = BpcIndicesMigrator.getCurrentModelVersionOfBpcNotificationIndex();
        if (!this.oss.existsIndex(aliasName)) {
            LOGGER.info("Migration not necessary for [{}]. Does not exist.", (Object)aliasName);
            return null;
        }
        String indexName = this.getTheOneAndOnlyIndexNameForAlias(aliasName);
        int currentModelVersion = this.oss.getModelVersion(aliasName);
        if (currentModelVersion == toModelVersion) {
            LOGGER.info("Migration not necessary for [{}]. Uses already the required model version: {}", (Object)aliasName, (Object)toModelVersion);
            return indexName;
        }
        this.checkFutureModelVersion(aliasName, currentModelVersion, toModelVersion);
        LOGGER.warn("Migration necessary. The current [{}] model version is '{}' and required is '{}'.", (Object)aliasName, (Object)currentModelVersion, (Object)toModelVersion);
        IndexToMigrate nextIndexToMigrate = new IndexToMigrate(aliasName, indexName);
        if (currentModelVersion == 1) {
            nextIndexToMigrate = new BpcNotificationIndexMigrationFromModelVersion1To2(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 2) {
            nextIndexToMigrate = new BpcNotificationIndexMigrationFromModelVersion2To3(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 3) {
            nextIndexToMigrate = new BpcNotificationIndexMigrationFromModelVersion3To4(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 4) {
            // empty if block
        }
        return nextIndexToMigrate.getName();
    }

    public String migrateBpcAuditlogIndex() throws IndexMigrationException, OpenSearchRelatedException {
        LOGGER.info("migrateBpcAuditlogIndex");
        return this.migrateBpcAuditlogIndex("bpc-auditlog");
    }

    public static int getLowestSupportedModelVersionOfBpcAuditlogIndex() {
        return 0;
    }

    public static int getCurrentModelVersionOfBpcAuditlogIndex() {
        return 2;
    }

    public String migrateBpcAuditlogIndex(String aliasName) throws IndexMigrationException, OpenSearchRelatedException {
        LOGGER.info("migrateBpcAuditlogIndex aliasName={}", (Object)aliasName);
        int toModelVersion = BpcIndicesMigrator.getCurrentModelVersionOfBpcAuditlogIndex();
        if (!this.oss.existsIndex(aliasName)) {
            LOGGER.info("Migration not necessary for [{}]. Does not exist.", (Object)aliasName);
            return null;
        }
        String indexName = this.getTheOneAndOnlyIndexNameForAlias(aliasName);
        int currentModelVersion = this.oss.getModelVersion(aliasName);
        if (currentModelVersion == toModelVersion) {
            LOGGER.info("Migration not necessary for [{}]. Uses already the required model version: {}", (Object)aliasName, (Object)toModelVersion);
            return indexName;
        }
        this.checkFutureModelVersion(aliasName, currentModelVersion, toModelVersion);
        LOGGER.warn("Migration necessary. The current [{}] model version is '{}' and required is '{}'.", (Object)aliasName, (Object)currentModelVersion, (Object)toModelVersion);
        IndexToMigrate nextIndexToMigrate = new IndexToMigrate(aliasName, indexName);
        if (currentModelVersion == 1) {
            nextIndexToMigrate = new BpcAuditlogIndexMigrationFromModelVersion1To2(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 2) {
            // empty if block
        }
        return nextIndexToMigrate.getName();
    }

    private String getTheOneAndOnlyIndexNameForAlias(String aliasName) throws OpenSearchRelatedException, IndexMigrationException {
        LOGGER.info("getIndexNameForAlias aliasName={}", (Object)aliasName);
        Set<String> indexNames = this.oss.getIndexNamesWithAlias(aliasName);
        if (indexNames.size() != 1) {
            throw new IndexMigrationException((ErrorCode)CoreErrorCode.INDEX_MIGRATION_ALIAS_WITH_MULTIPLE_INDICES, "Index migration failed. Please have a look why the index alias '${aliasName}' is assigned to multiple indices: ${indexNames}", MapUtil.mapOf("aliasName", aliasName, "indexNames", String.valueOf(indexNames)));
        }
        return indexNames.iterator().next();
    }

    private void checkFutureModelVersion(String aliasName, int currentModelVersion, int toModelVersion) throws IndexMigrationException {
        if (currentModelVersion > toModelVersion) {
            throw new IndexMigrationException((ErrorCode)CoreErrorCode.INDEX_MIGRATION_NOT_ALLOWED_VERSION, "You are trying to use a '${indexName}' index which is from a newer BPC version. This is not possible!", MapUtil.mapOf("indexName", aliasName, "indexModelVersion", currentModelVersion, "bpcModelVersion", toModelVersion));
        }
    }

    private record MigratableIndex(String aliasOfIndex, int lowestSupportedModelVersion, int latestModelVersion) {
    }
}

