/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.search.SearchHit;

public class BpcNotificationIndexMigrationFromModelVersion3To4
extends AllSearchHitsMigration {
    private static final Logger LOGGER = LogManager.getLogger(BpcNotificationIndexMigrationFromModelVersion3To4.class);
    private static final boolean testRun = false;

    public BpcNotificationIndexMigrationFromModelVersion3To4(OpenSearchService oss) {
        super(oss, 4);
        try {
            if (!oss.existsIndex("bpc-notification")) {
                LOGGER.info("Migration not necessary: index '{}' does not exist", (Object)"bpc-notification");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<IndexRequest> migrateSearchHit(RestHighLevelClient osClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        if (sourceValues.containsKey("type") && "link".equals(sourceValues.get("type"))) {
            sourceValues.put("type", "info");
        }
        if (sourceValues.containsKey("typeSpecificData")) {
            Object typeSpecificData = sourceValues.get("typeSpecificData");
            sourceValues.put("linkData", typeSpecificData);
            sourceValues.remove("typeSpecificData");
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
    }
}

