/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.percolators;

import de.virtimo.bpc.api.Percolator;
import de.virtimo.bpc.api.exception.OpenSearchIndexNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.percolators.PercolatorImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;

class PercolatorsOpenSearchHandler {
    private static final Logger LOGGER = LogManager.getLogger(PercolatorsOpenSearchHandler.class);
    private final OpenSearchService oss;

    PercolatorsOpenSearchHandler(OpenSearchService oss) {
        this.oss = oss;
    }

    boolean registerPercolator(Percolator percolator, QueryBuilder queryBuilder) {
        LOGGER.info("registerPercolator percolator={}, queryBuilder={}", (Object)percolator, (Object)queryBuilder);
        try {
            if (!this.oss.existsIndex(percolator.getIndex())) {
                LOGGER.info("Must not register the percolator query, because the related index '{}' does not exist.", (Object)percolator.getIndex());
                return false;
            }
            Map<String, String> currentFieldTypeMapping = this.oss.getFieldsTypeMapping(percolator.getIndex());
            if (!currentFieldTypeMapping.containsKey("_percolator_query") || !"percolator".equalsIgnoreCase(currentFieldTypeMapping.get("_percolator_query"))) {
                LOGGER.error("Could not register the percolator query, because the mapping of the percolator type field '_percolator_query' is missing or is not of type 'percolator' in the related index '" + percolator.getIndex() + "'.");
                return false;
            }
            IndexRequest req = (IndexRequest)((IndexRequest)new IndexRequest().index(percolator.getIndex())).id(percolator.getUID()).source(XContentFactory.jsonBuilder().startObject().field("_percolator_query", queryBuilder).endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            IndexResponse indexResponse = this.oss.getClient().index(req, RequestOptions.DEFAULT);
            LOGGER.info("indexResponse:{}", (Object)indexResponse);
            return true;
        }
        catch (IOException | OpenSearchException ex) {
            LOGGER.error("Failed to create/update the percolator query of index '" + percolator.getIndex() + "' due to an OpenSearch error.", (Throwable)ex);
            return false;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to create/update the percolator query of index '" + percolator.getIndex() + "'.", (Throwable)ex);
            return false;
        }
    }

    Set<Percolator> getPercolatorsFromIndex(String index) {
        LOGGER.info("getPercolatorsFromIndex index={}", (Object)index);
        HashSet<Percolator> result = new HashSet<Percolator>();
        try {
            SearchRequest searchRequest = new SearchRequest().indices(index).source(new SearchSourceBuilder().size(100).query(QueryBuilders.existsQuery("_percolator_query")));
            this.oss.search(searchRequest, searchHit -> {
                String indexName = searchHit.getIndex();
                String indexAliasName = this.oss.aliasFromBpcIndexName(indexName);
                String percolatorUID = searchHit.getId();
                result.add(new PercolatorImpl(indexAliasName != null ? indexAliasName : indexName, percolatorUID));
            });
        }
        catch (OpenSearchIndexNotFoundException ex) {
            LOGGER.warn("Evaluate percolator IDs ... the OpenSearch index does not exist: {}", (Object)index);
        }
        catch (Exception ex) {
            LOGGER.error("Evaluate percolator IDs .... failed to get the percolator of the index: " + index, (Throwable)ex);
        }
        return result;
    }

    void deletePercolators(Set<Percolator> percolatorsToDelete) throws OpenSearchRelatedException {
        LOGGER.info("deletePercolators percolatorsToDelete={}", percolatorsToDelete);
        if (percolatorsToDelete == null || percolatorsToDelete.isEmpty()) {
            return;
        }
        try {
            RestHighLevelClient osClient = this.oss.getClient();
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
            for (Percolator percolatorToDelete : percolatorsToDelete) {
                bulkRequest.add(((DeleteRequest)new DeleteRequest().index(percolatorToDelete.getIndex())).id(percolatorToDelete.getUID()));
            }
            BulkResponse bulkResponse = osClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            LOGGER.info("Percolators deleted: {}, with failures: {}", (Object)bulkRequest.numberOfActions(), (Object)bulkResponse.hasFailures());
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    List<Object> getContentOfNewOrUpdatedDatabaseIDs(String index, Set<String> newOrUpdatedDatabaseIDs) throws OpenSearchRelatedException {
        LOGGER.info("getContentOfNewOrUpdatedDatabaseIDs index={}, newOrUpdatedDatabaseIDs=...", (Object)index);
        ArrayList<Object> dataList = new ArrayList<Object>();
        if (newOrUpdatedDatabaseIDs != null && !newOrUpdatedDatabaseIDs.isEmpty()) {
            MultiGetRequest req = new MultiGetRequest().refresh(true);
            for (String databaseID : newOrUpdatedDatabaseIDs) {
                req.add(index, databaseID);
            }
            MultiGetResponse multiGetResponse = this.oss.mget(req, RequestOptions.DEFAULT);
            for (MultiGetItemResponse response : multiGetResponse.getResponses()) {
                dataList.add(response.getResponse().getSource());
            }
        }
        return dataList;
    }
}

