/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import java.sql.Timestamp;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LastUpdateTimestampOnRestartHandler {
    private static final Logger LOGGER = LogManager.getLogger(LastUpdateTimestampOnRestartHandler.class);
    private final String replicationJobId;
    private final OpenSearchService oss;
    private final String index;

    public LastUpdateTimestampOnRestartHandler(String replicationJobId, OpenSearchService oss, String index) {
        this.replicationJobId = replicationJobId;
        this.oss = oss;
        this.index = index;
    }

    public String getReplicationJobId() {
        return this.replicationJobId;
    }

    public String getIndex() {
        return this.index;
    }

    public Timestamp readFromIndex() {
        LOGGER.debug("readLastUpdateTimestampOnRestartFromIndex");
        Object lastUpdateTimestampOnRestartObject = this.oss.getMetaDataValue(this.index, "last_update_timestamp:::" + this.replicationJobId);
        if (lastUpdateTimestampOnRestartObject instanceof Number) {
            return new Timestamp(((Number)lastUpdateTimestampOnRestartObject).longValue());
        }
        return null;
    }

    public void deleteFromIndex() throws OpenSearchRelatedException {
        LOGGER.debug("deleteLastUpdateTimestampOnRestartFromIndex");
        this.oss.removeMetaDataValue(this.index, "last_update_timestamp:::" + this.replicationJobId);
    }

    public void saveToIndex(Timestamp timestamp) throws OpenSearchRelatedException {
        LOGGER.debug("saveLastUpdateTimestampOnRestartToIndex timestamp=...");
        this.oss.setMetaDataValue(this.index, "last_update_timestamp:::" + this.replicationJobId, timestamp.getTime());
    }
}

