/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.AbstractBackendModuleLoadedEventHandler;
import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.AbstractMaintenanceModeAcknowledgeEventHandler;
import de.virtimo.bpc.api.AbstractServerModeChangedEventHandler;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.auditlog.SystemAuditLog;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.exception.JsonGenerationException;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchBpcPluginManager;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.lookupjoins.LookupJoinUpdaterData;
import de.virtimo.bpc.core.lookupjoins.LookupJoins;
import de.virtimo.bpc.core.lookupjoins.LookupJoinsManager;
import de.virtimo.bpc.core.opensearch.ModuleManagerImpl;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationJobNotFoundException;
import de.virtimo.bpc.core.replicator.ReplicationJobsConverter;
import de.virtimo.bpc.core.replicator.ReplicationManager;
import de.virtimo.bpc.core.replicator.ReplicationModuleInstance;
import de.virtimo.bpc.module.AbstractInstantiableModule;
import de.virtimo.bpc.module.ModuleConfigurationBuilder;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobForcedStartActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobRefreshLookupJoinsActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobRestartActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobRuntimeStatsDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobsClearLookupJoinCachesActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobsDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobsRefreshLookupJoinsActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobsWithRuntimeStatsFromAllServersDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobsWithRuntimeStatsFromServerDTO;
import de.virtimo.bpc.opensearch.plugin.dto.TailsyncManualStartActionDTO;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ClearLookupJoinCachesOfReplicationJobsWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.RefreshLookupJoinsOfAllReplicationJobsWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.RefreshLookupJoinsOfReplicationJobWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobForcedStartWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobRestartWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobStartActionWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobStatsRequestWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobStopActionWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.TailsyncManualStartWebsocketMessage;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;

public class ReplicationModule
extends AbstractInstantiableModule {
    private static final Logger LOGGER = LogManager.getLogger(ReplicationModule.class);
    public static final String SETTING_REPLICATOR_THREAD_COUNT = "replicatorThreadCount";
    private static final int TIMEOUT_IN_SECONDS_FOR_REPLICATIONJOB_STATE_CHANGES = 15;
    public static final String MODULE_ID = "replication";
    private static final Object SEND_TO_PLUGIN_LOCK = new Object();
    private static final Object REPLICATION_MODULE_INSTANCES_LOCK = new Object();
    private BpcServicesTracker<ReplicationManager> replicationManagerTracker;
    private BpcServicesTracker<OpenSearchBpcPluginManager> openSearchBpcPluginManagerTracker;
    private BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private BpcServicesTracker<LookupJoinsManager> lookupJoinsManagerTracker;
    private BpcServicesTracker<DatabaseManager> databaseManagerTracker;
    private BpcServicesTracker<EventManager> eventManagerTracker;
    private final EventRegistration eventRegistration = new EventRegistration(null);

    public ReplicationModule(ModuleManager moduleManager) {
        super(moduleManager);
    }

    @Override
    public void setModuleBundle(Bundle moduleBundle) {
        super.setModuleBundle(moduleBundle);
        BundleContext bundleContext = moduleBundle.getBundleContext();
        BpcServicesTracker.stopAll(this);
        this.replicationManagerTracker = new BpcServicesTracker<ReplicationManager>(bundleContext, ReplicationManager.class);
        this.openSearchBpcPluginManagerTracker = new BpcServicesTracker<OpenSearchBpcPluginManager>(bundleContext, OpenSearchBpcPluginManager.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(bundleContext, CoreBundleConfiguration.class);
        this.lookupJoinsManagerTracker = new BpcServicesTracker<LookupJoinsManager>(bundleContext, LookupJoinsManager.class);
        this.databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(bundleContext, DatabaseManager.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(bundleContext, EventManager.class);
        this.eventRegistration.setBundleContext(bundleContext);
        this.eventRegistration.forMaintenanceModeAcknowledgeEvents(new MaintenanceModeChangedEventHandler(bundleContext));
        this.eventRegistration.forBackendModuleLoadedEvents(MODULE_ID, new ReplicationModuleLoadedEventHandler());
        this.eventRegistration.forServerModeChangedEvents(new MasterOrSlaveModeChangedEventHandler());
        this.eventRegistration.forOpenSearchPluginEvents(new StopReplicationJobActionEventHandler());
        this.eventRegistration.forOpenSearchPluginEvents(new StartReplicationJobActionEventHandler());
        this.eventRegistration.forOpenSearchPluginEvents(new ForcedStartOfReplicationJobActionEventHandler());
        this.eventRegistration.forOpenSearchPluginEvents(new RestartOfReplicationJobActionEventHandler());
        this.eventRegistration.forOpenSearchPluginEvents(new RefreshLookupJoinsOfReplicationJobActionEventHandler());
        this.eventRegistration.forOpenSearchPluginEvents(new RefreshLookupJoinsOfAllReplicationJobsActionEventHandler());
        this.eventRegistration.forOpenSearchPluginEvents(new ClearLookupJoinCachesOfReplicationJobsActionEventHandler());
        this.eventRegistration.forOpenSearchPluginEvents(new ManualStartOfTailsyncActionEventHandler());
        this.eventRegistration.forOpenSearchPluginEvents(new GetReplicationJobStatsActionEventHandler());
    }

    @Override
    public void destroy() {
        LOGGER.info("destroy");
        super.destroy();
        this.eventRegistration.unregisterAllEventHandler();
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public String getModuleId() {
        return MODULE_ID;
    }

    @Override
    public String getModuleName() {
        return "Replication";
    }

    @Override
    public Class<? extends ModuleInstance> getModuleInstanceClass() {
        return ReplicationModuleInstance.class;
    }

    @Override
    public ModuleConfiguration getDefaultConfiguration() {
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).addSortableGroupedSettingsFromFile(this.getModuleBundle(), "defaults/replication/default_module_settings.json").build();
    }

    @Override
    public ModuleConfiguration getDefaultInstanceConfiguration() {
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).withInstanceId(null).addSortableGroupedSettingsFromFile(this.getModuleBundle(), "defaults/replication/default_instance_settings.json").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendForcedStartOfReplicationJobActionToPlugin(String replicationJobId, UserSession initiatedByUserSession) throws ServiceNotFoundException, JsonGenerationException {
        LOGGER.info("sendForcedStartOfReplicationJobActionToPlugin replicationJobId={}, initiatedByUserSession={}", (Object)replicationJobId, (Object)initiatedByUserSession);
        Object object = SEND_TO_PLUGIN_LOCK;
        synchronized (object) {
            OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
            openSearchBpcPluginManager.sendForcedStartOfReplicationJobAction(replicationJobId, initiatedByUserSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRestartOfReplicationJobActionToPlugin(String replicationJobId, UserSession initiatedByUserSession) throws ServiceNotFoundException, JsonGenerationException {
        LOGGER.info("sendRestartOfReplicationJobActionToPlugin replicationJobId={}, initiatedByUserSession=...", (Object)replicationJobId);
        Object object = SEND_TO_PLUGIN_LOCK;
        synchronized (object) {
            OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
            openSearchBpcPluginManager.sendRestartOfReplicationJobAction(replicationJobId, initiatedByUserSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRefreshLookupJoinsOfReplicationJobActionToPlugin(String replicationJobId, UserSession initiatedByUserSession) throws ServiceNotFoundException, JsonGenerationException {
        LOGGER.info("sendRefreshLookupJoinsOfReplicationJobActionToPlugin replicationJobId={}, initiatedByUserSession=...", (Object)replicationJobId);
        Object object = SEND_TO_PLUGIN_LOCK;
        synchronized (object) {
            OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
            openSearchBpcPluginManager.sendRefreshLookupJoinsOfReplicationJobAction(replicationJobId, initiatedByUserSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRefreshLookupJoinsOfAllReplicationJobsActionToPlugin(UserSession initiatedByUserSession) throws ServiceNotFoundException, JsonGenerationException {
        LOGGER.info("sendRefreshLookupJoinsOfAllReplicationJobsActionToPlugin initiatedByUserSession=...");
        Object object = SEND_TO_PLUGIN_LOCK;
        synchronized (object) {
            OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
            openSearchBpcPluginManager.sendRefreshLookupJoinsOfAllReplicationJobsAction(initiatedByUserSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendClearLookupJoinCachesActionToPlugin(UserSession initiatedByUserSession) throws ServiceNotFoundException, JsonGenerationException {
        LOGGER.info("sendClearLookupJoinCachesActionToPlugin initiatedByUserSession=...");
        Object object = SEND_TO_PLUGIN_LOCK;
        synchronized (object) {
            OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
            openSearchBpcPluginManager.sendClearLookupJoinCachesOfReplicationJobsAction(initiatedByUserSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendManualStartOfTailsyncAction(String replicationJobId, UserSession initiatedByUserSession) throws ServiceNotFoundException, JsonGenerationException {
        LOGGER.info("sendManualStartOfTailsyncAction replicationJobId={}, initiatedByUserSession={}", (Object)replicationJobId, (Object)initiatedByUserSession);
        Object object = SEND_TO_PLUGIN_LOCK;
        synchronized (object) {
            OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
            openSearchBpcPluginManager.sendManualStartOfTailsyncAction(replicationJobId, initiatedByUserSession);
        }
    }

    private int createHashcodeToDetectConfigChanges(ModuleConfiguration jobConfig) throws SettingException {
        Objects.requireNonNull(jobConfig, "jobConfig must not be null");
        int result = 1;
        Collection<Setting> settings = jobConfig.getSettings().values();
        for (Setting setting : settings) {
            result = 31 * result + Arrays.hashCode(setting.toJsonAsBytes());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendReplicationJobsToPluginForOrchestration() throws ServiceNotFoundException, JsonGenerationException, SettingException {
        LOGGER.info("sendReplicationJobsToOpenSearchBpcPluginForOrchestration");
        Object object = SEND_TO_PLUGIN_LOCK;
        synchronized (object) {
            OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
            ReplicationJobsDTO replicationJobsDTO = new ReplicationJobsDTO();
            for (ModuleInstance replicationModuleInstance : this.getModuleInstances().values()) {
                ModuleConfiguration replicationModuleInstanceConfig = replicationModuleInstance.getConfiguration();
                String replicationJobId = replicationModuleInstance.getModuleId();
                boolean replicationJobEnabled = replicationModuleInstanceConfig.getSettingValue("replicationEnabled").asBoolean(true);
                int replicationJobConfigHashcode = this.createHashcodeToDetectConfigChanges(replicationModuleInstanceConfig);
                ReplicationJobDTO replicationJobDTO = new ReplicationJobDTO(replicationJobId, replicationJobEnabled, Integer.valueOf(replicationJobConfigHashcode));
                replicationJobsDTO.add(replicationJobDTO);
            }
            openSearchBpcPluginManager.orchestrateReplicationJobs(replicationJobsDTO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendReplicationJobsToPluginForOrchestrationForJobsToStopTemporarily(Set<String> replicationJobIDs, boolean stopAction) throws ServiceNotFoundException, JsonGenerationException, SettingException {
        LOGGER.info("sendReplicationJobsToPluginForOrchestrationForJobsToStopTemporarily replicationJobIDs={}, stopAction={}", replicationJobIDs, (Object)stopAction);
        if (replicationJobIDs == null || replicationJobIDs.isEmpty()) {
            return;
        }
        Object object = SEND_TO_PLUGIN_LOCK;
        synchronized (object) {
            OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
            boolean mustBeOrchestrated = false;
            ReplicationJobsDTO replicationJobsDTO = new ReplicationJobsDTO();
            for (ModuleInstance replicationModuleInstance : this.getModuleInstances().values()) {
                ModuleConfiguration replicationModuleInstanceConfig = replicationModuleInstance.getConfiguration();
                String replicationJobId = replicationModuleInstance.getModuleId();
                boolean replicationJobEnabled = replicationModuleInstanceConfig.getSettingValue("replicationEnabled").asBoolean(true);
                int replicationJobConfigHashcode = this.createHashcodeToDetectConfigChanges(replicationModuleInstanceConfig);
                if (replicationJobIDs.contains(replicationJobId)) {
                    if (stopAction) {
                        if (replicationJobEnabled) {
                            replicationJobEnabled = false;
                            mustBeOrchestrated = true;
                        }
                    } else if (replicationJobEnabled) {
                        replicationJobEnabled = true;
                        mustBeOrchestrated = true;
                    }
                }
                ReplicationJobDTO replicationJobDTO = new ReplicationJobDTO(replicationJobId, replicationJobEnabled, Integer.valueOf(replicationJobConfigHashcode));
                replicationJobsDTO.add(replicationJobDTO);
            }
            if (mustBeOrchestrated) {
                openSearchBpcPluginManager.orchestrateReplicationJobs(replicationJobsDTO);
            }
        }
    }

    public void waitUntilReplicationJobsAreStopped(Set<String> replicationJobIDs) throws ServiceNotFoundException {
        LOGGER.info("waitUntilReplicationJobsAreStopped replicationJobIDs={}", replicationJobIDs);
        OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
        openSearchBpcPluginManager.waitUntilReplicationJobsAreInState(replicationJobIDs, "STOPPED", 15L);
    }

    public void waitUntilReplicationJobsAreRunning(Set<String> replicationJobIDs) throws ServiceNotFoundException {
        LOGGER.info("waitUntilReplicationJobsAreRunning replicationJobIDs={}", replicationJobIDs);
        OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
        openSearchBpcPluginManager.waitUntilReplicationJobsAreInState(replicationJobIDs, "RUNNING", 15L);
    }

    @Override
    public void moduleInstanceCreated(ModuleInstance moduleInstance) {
        LOGGER.info("moduleInstanceCreated moduleInstance={}", (Object)moduleInstance);
        if (moduleInstance instanceof ReplicationModuleInstance) {
            ReplicationModuleInstance replicationModuleInstance = (ReplicationModuleInstance)moduleInstance;
            String replicationJobId = replicationModuleInstance.getModuleId();
            try {
                CoreModule coreModule = this.getModuleManager().getModuleByClass(CoreModule.class);
                if (coreModule.isMasterServer()) {
                    this.sendReplicationJobsToPluginForOrchestration();
                    SystemAuditLog.info("ReplicationJobsOrchestration", "Replication jobs orchestration started due to new replication job '" + replicationJobId + "'.");
                } else {
                    LOGGER.info("Replication jobs orchestration not started for new replication job '{}', because this BPC server is not the master.", (Object)replicationJobId);
                    SystemAuditLog.info("ReplicationJobsOrchestration", "Replication jobs orchestration no started for new replication job '" + replicationJobId + "', because this BPC server is not the master.");
                }
            }
            catch (Exception ex) {
                LOGGER.error("Replication job '{}' created, but starting the replication jobs orchestration failed.", (Object)replicationJobId, (Object)ex);
                SystemAuditLog.error("ReplicationJobsOrchestration", "Replication jobs orchestration failed for the new replication job '" + replicationJobId + "'.", null, ex.getMessage());
            }
        }
    }

    @Override
    public void moduleInstanceUpdated(ModuleInstance moduleInstance) {
        LOGGER.info("moduleInstanceUpdated moduleInstance={}", (Object)moduleInstance);
        if (moduleInstance instanceof ReplicationModuleInstance) {
            ReplicationModuleInstance replicationModuleInstance = (ReplicationModuleInstance)moduleInstance;
            String replicationJobId = replicationModuleInstance.getModuleId();
            try {
                CoreModule coreModule = this.getModuleManager().getModuleByClass(CoreModule.class);
                if (coreModule.isMasterServer()) {
                    this.sendReplicationJobsToPluginForOrchestration();
                    SystemAuditLog.info("ReplicationJobsOrchestration", "Replication jobs orchestration started due to updated replication job '" + replicationJobId + "'.");
                } else {
                    LOGGER.info("Replication jobs orchestration not started for updated replication job '{}', because this BPC server is not the master.", (Object)replicationJobId);
                    SystemAuditLog.info("ReplicationJobsOrchestration", "Replication jobs orchestration not started for updated replication job '" + replicationJobId + "', because this BPC server is not the master.");
                }
            }
            catch (Exception ex) {
                LOGGER.error("Replication job '{}' updated, but starting the replication jobs orchestration failed.", (Object)replicationJobId, (Object)ex);
                SystemAuditLog.error("ReplicationJobsOrchestration", "Replication jobs orchestration failed for the updated replication job '" + replicationJobId + "'.", null, ex.getMessage());
            }
        }
    }

    @Override
    public void moduleInstanceDeleted(ModuleInstance moduleInstance) {
        LOGGER.info("moduleInstanceDeleted moduleInstance={}", (Object)moduleInstance);
        if (moduleInstance instanceof ReplicationModuleInstance) {
            String replicationJobId = moduleInstance.getModuleId();
            try {
                CoreModule coreModule = this.getModuleManager().getModuleByClass(CoreModule.class);
                if (coreModule.isMasterServer()) {
                    this.sendReplicationJobsToPluginForOrchestration();
                    SystemAuditLog.info("ReplicationJobsOrchestration", "Replication jobs orchestration started due to deleted replication job '" + replicationJobId + "'.");
                } else {
                    LOGGER.info("Replication jobs orchestration not started for deleted replication job '{}', because this BPC server is not the master.", (Object)replicationJobId);
                    SystemAuditLog.info("ReplicationJobsOrchestration", "Replication jobs orchestration not started for deleted replication job '" + replicationJobId + "', because this BPC server is not the master.");
                }
            }
            catch (Exception ex) {
                LOGGER.error("Replication job '{}' deleted, but starting the replication jobs orchestration failed.", (Object)replicationJobId, (Object)ex);
                SystemAuditLog.error("ReplicationJobsOrchestration", "Replication jobs orchestration failed for the deleted replication job '" + replicationJobId + "'.", null, ex.getMessage());
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getSource() instanceof ModuleConfiguration && SETTING_REPLICATOR_THREAD_COUNT.equals(evt.getPropertyName())) {
            try {
                ReplicationManager replicationManager = this.replicationManagerTracker.getService();
                replicationManager.setReplicatorThreadCount(this.getReplicatorThreadCount());
            }
            catch (Exception ex) {
                LOGGER.error("Replicator thread count setting update recognized, but failed to set it in the replication manager.", (Throwable)ex);
            }
        }
    }

    public ReplicationManager getReplicationManager() throws ServiceNotFoundException {
        return this.replicationManagerTracker.getService();
    }

    public Integer getReplicatorThreadCount() {
        return this.getConfiguration().getSettingValue(SETTING_REPLICATOR_THREAD_COUNT).asInt(1);
    }

    @NotNull
    public ReplicationJob getReplicationJob(String replicationJobId) throws ReplicationJobNotFoundException {
        LOGGER.info("getReplicationJob replicationJobId={}", (Object)replicationJobId);
        ReplicationModuleInstance replicationModuleInstance = (ReplicationModuleInstance)this.getModuleInstance(replicationJobId);
        if (replicationModuleInstance == null) {
            replicationModuleInstance = this.forcedLoadOfReplicationModuleInstance(replicationJobId);
        }
        if (replicationModuleInstance != null) {
            return replicationModuleInstance.getReplicationJob();
        }
        throw new ReplicationJobNotFoundException(replicationJobId);
    }

    private ReplicationModuleInstance forcedLoadOfReplicationModuleInstance(String replicationJobId) {
        LOGGER.info("forcedLoadOfReplicationModuleInstance replicationJobId={}", (Object)replicationJobId);
        try {
            ModuleConfiguration moduleInstanceConfiguration = ((ModuleManagerImpl)this.getModuleManager()).loadModuleInstanceConfiguration(this, replicationJobId, "none");
            ModuleInstance moduleInstance = this.createModuleInstance(replicationJobId, "none", moduleInstanceConfiguration);
            if (moduleInstance instanceof ReplicationModuleInstance) {
                return (ReplicationModuleInstance)moduleInstance;
            }
        }
        catch (ModuleInstanceNotFoundException moduleInstanceConfiguration) {
        }
        catch (Exception ex) {
            LOGGER.warn("Forced load of the following replication module instance failed: {}", (Object)replicationJobId, (Object)ex);
        }
        return null;
    }

    @NotNull
    public List<ReplicationJob> getAllReplicationJobs() {
        ArrayList<ReplicationJob> result = new ArrayList<ReplicationJob>();
        for (ModuleInstance moduleInstance : this.getModuleInstances().values()) {
            ReplicationModuleInstance replicationModuleInstance = (ReplicationModuleInstance)moduleInstance;
            result.add(replicationModuleInstance.getReplicationJob());
        }
        return result;
    }

    @NotNull
    public List<ReplicationJob> getReplicationJobsUsingTargetIndexAliases(Set<String> aliases) {
        LOGGER.info("getReplicationJobsUsingTargetIndexAliases aliases={}", aliases);
        ArrayList<ReplicationJob> result = new ArrayList<ReplicationJob>();
        if (aliases != null) {
            List<ReplicationJob> jobs = this.getAllReplicationJobs();
            for (ReplicationJob job : jobs) {
                String replicationJobTargetIndex = job.getTarget().getIndex();
                if (!aliases.contains(replicationJobTargetIndex)) continue;
                result.add(job);
            }
        }
        return result;
    }

    public List<ReplicationJobRuntimeStatsDTO> getReplicationJobsWithRuntimeStatsFromAllServersUsingIndex(String dataIndex) throws ServiceNotFoundException {
        LOGGER.info("getReplicationJobsWithRuntimeStatsFromAllServersUsingIndex dataIndex={}", (Object)dataIndex);
        ArrayList<ReplicationJobRuntimeStatsDTO> result = new ArrayList<ReplicationJobRuntimeStatsDTO>();
        if (!StringUtil.isNullOrEmpty(dataIndex)) {
            List<ReplicationJobRuntimeStatsDTO> fromAllServers = this.getReplicationJobsWithRuntimeStatsFromAllServers();
            block0: for (ReplicationJob job : this.getAllReplicationJobs()) {
                if (!job.getTarget().getIndex().equalsIgnoreCase(dataIndex)) continue;
                for (ReplicationJobRuntimeStatsDTO replicationJobStats : fromAllServers) {
                    if (!job.getId().equals(replicationJobStats.getId())) continue;
                    result.add(replicationJobStats);
                    continue block0;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReplicationJobRuntimeStatsDTO> getReplicationJobsWithRuntimeStatsFromAllServers() throws ServiceNotFoundException {
        LOGGER.info("getReplicationJobsWithRuntimeStatsFromAllServers");
        DatabaseManager databaseManager = this.databaseManagerTracker.getService();
        ReplicationJobsConverter replicationJobsConverter = new ReplicationJobsConverter(this, databaseManager);
        HashMap<String, ReplicationJobRuntimeStatsDTO> replicationJobRuntimeStatsEntries = new HashMap<String, ReplicationJobRuntimeStatsDTO>();
        for (ReplicationJob job : this.getAllReplicationJobs()) {
            ReplicationJobRuntimeStatsDTO replicationJobRuntimeStats = replicationJobsConverter.convertToReplicationJobRuntimeStatsDTO(null, job);
            replicationJobRuntimeStatsEntries.put(replicationJobRuntimeStats.getId(), replicationJobRuntimeStats);
        }
        Object object = SEND_TO_PLUGIN_LOCK;
        synchronized (object) {
            OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
            ReplicationJobsWithRuntimeStatsFromAllServersDTO replicationJobsWithRuntimeStatsFromAllServersDTO = openSearchBpcPluginManager.getReplicationJobsWithRuntimeStatsFromAllServers();
            replicationJobsWithRuntimeStatsFromAllServersDTO.forEach(replicationJobsWithRuntimeStatsFromServerDTO -> {
                List replicationJobEntries = replicationJobsWithRuntimeStatsFromServerDTO.getReplicationJobs();
                for (ReplicationJobRuntimeStatsDTO replicationJobEntry : replicationJobEntries) {
                    replicationJobRuntimeStatsEntries.put(replicationJobEntry.getId(), replicationJobEntry);
                }
            });
        }
        return new ArrayList<ReplicationJobRuntimeStatsDTO>(replicationJobRuntimeStatsEntries.values());
    }

    public ReplicationJobsWithRuntimeStatsFromServerDTO getReplicationJobsWithRuntimeStatsFromThisServer() throws ServiceNotFoundException {
        LOGGER.info("getReplicationJobsWithRuntimeStatsFromThisServer");
        CoreBundleConfiguration coreBundleConfiguration = this.coreBundleConfigurationTracker.getService();
        DatabaseManager databaseManager = this.databaseManagerTracker.getService();
        ReplicationManager replicationManager = this.replicationManagerTracker.getService();
        String serverUUIDFromThisServer = coreBundleConfiguration.getServerUUID();
        ReplicationJobsConverter replicationJobsConverter = new ReplicationJobsConverter(this, databaseManager);
        ReplicationJobsWithRuntimeStatsFromServerDTO statsFromServer = new ReplicationJobsWithRuntimeStatsFromServerDTO(serverUUIDFromThisServer);
        for (ReplicationJob job : replicationManager.getJobs()) {
            ReplicationJobRuntimeStatsDTO replicationJobRuntimeStats = replicationJobsConverter.convertToReplicationJobRuntimeStatsDTO(serverUUIDFromThisServer, job);
            statsFromServer.add(replicationJobRuntimeStats);
        }
        return statsFromServer;
    }

    public LookupJoins getLookupJoinsOfReplicationJob(String replicationJobId) {
        LOGGER.debug("getLookupJoinsOfReplicationJob replicationJobId={}", (Object)replicationJobId);
        ReplicationModuleInstance replicationModuleInstance = (ReplicationModuleInstance)this.getModuleInstance(replicationJobId);
        if (replicationModuleInstance != null) {
            return replicationModuleInstance.getLookupJoins();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshLookupJoinsOfReplicationJob(String replicationJobId) throws ServiceNotFoundException, OpenSearchRelatedException, InterruptedException {
        LOGGER.info("refreshLookupJoinsOfReplicationJob replicationJobId={}", (Object)replicationJobId);
        ArrayList<LookupJoinUpdaterData> updaterDatas = new ArrayList<LookupJoinUpdaterData>();
        Object object = REPLICATION_MODULE_INSTANCES_LOCK;
        synchronized (object) {
            ReplicationModuleInstance replicationModuleInstance = (ReplicationModuleInstance)this.getModuleInstance(replicationJobId);
            if (replicationModuleInstance != null) {
                ReplicationJob replicationJob = replicationModuleInstance.getReplicationJob();
                LookupJoins lookupJoins = replicationModuleInstance.getLookupJoins();
                LookupJoinUpdaterData updaterData = new LookupJoinUpdaterData(replicationJob.getTarget().getIndex(), lookupJoins, lookupJoins.getKeyFields());
                updaterDatas.add(updaterData);
            } else {
                LOGGER.warn("Refreshing the lookup joins of replication job '{}' is not possible, because it does not exist.", (Object)replicationJobId);
            }
        }
        if (!updaterDatas.isEmpty()) {
            LookupJoinsManager lookupJoinsManager = this.lookupJoinsManagerTracker.getService();
            for (LookupJoinUpdaterData updaterData : updaterDatas) {
                lookupJoinsManager.refreshLookupJoins(updaterData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshLookupJoinsOfAllReplicationJobs() throws ServiceNotFoundException, OpenSearchRelatedException, InterruptedException {
        LOGGER.info("refreshLookupJoinsOfReplicationJobs");
        ArrayList<LookupJoinUpdaterData> updaterDatas = new ArrayList<LookupJoinUpdaterData>();
        Object object = REPLICATION_MODULE_INSTANCES_LOCK;
        synchronized (object) {
            for (ModuleInstance moduleInstance : this.getModuleInstances().values()) {
                ReplicationModuleInstance replicationModuleInstance = (ReplicationModuleInstance)moduleInstance;
                ReplicationJob replicationJob = replicationModuleInstance.getReplicationJob();
                LookupJoins lookupJoins = replicationModuleInstance.getLookupJoins();
                LookupJoinUpdaterData updaterData = new LookupJoinUpdaterData(replicationJob.getTarget().getIndex(), lookupJoins, lookupJoins.getKeyFields());
                updaterDatas.add(updaterData);
            }
        }
        if (!updaterDatas.isEmpty()) {
            LookupJoinsManager lookupJoinsManager = this.lookupJoinsManagerTracker.getService();
            for (LookupJoinUpdaterData updaterData : updaterDatas) {
                lookupJoinsManager.refreshLookupJoins(updaterData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLookupJoinCaches() {
        LOGGER.info("clearLookupJoinCaches");
        Object object = REPLICATION_MODULE_INSTANCES_LOCK;
        synchronized (object) {
            for (ModuleInstance moduleInstance : this.getModuleInstances().values()) {
                ReplicationModuleInstance replicationModuleInstance = (ReplicationModuleInstance)moduleInstance;
                replicationModuleInstance.getLookupJoins().clearCaches();
            }
        }
    }

    private class MaintenanceModeChangedEventHandler
    extends AbstractMaintenanceModeAcknowledgeEventHandler {
        public MaintenanceModeChangedEventHandler(BundleContext bundleContext) {
            super(bundleContext, ReplicationModule.MODULE_ID);
        }

        @Override
        public void processNewMaintenanceMode(boolean enabled) {
            LOGGER.info("{}.processNewMaintenanceMode enabled={}", (Object)this.getClass().getSimpleName(), (Object)enabled);
        }
    }

    private class ReplicationModuleLoadedEventHandler
    extends AbstractBackendModuleLoadedEventHandler {
        private ReplicationModuleLoadedEventHandler() {
        }

        @Override
        public void processLoadedModule(Module module) {
            LOGGER.info("{}.processLoadedModule module=...", (Object)this.getClass().getSimpleName());
            try {
                ReplicationManager replicationManager = ReplicationModule.this.replicationManagerTracker.getService();
                replicationManager.initialize((ReplicationModule)module);
            }
            catch (ServiceNotFoundException ex) {
                LOGGER.error("ReplicationManager is not available? Should be impossible!", (Throwable)ex);
            }
            try {
                CoreModule coreModule = ReplicationModule.this.getModuleManager().getModuleByClass(CoreModule.class);
                if (coreModule.isMasterServer()) {
                    ReplicationModule.this.sendReplicationJobsToPluginForOrchestration();
                    SystemAuditLog.info("ReplicationJobsOrchestration", "Replication jobs orchestration started, because the replication module has been loaded on master server.");
                } else {
                    SystemAuditLog.info("ReplicationJobsOrchestration", "Replication jobs orchestration not started, because the replication module has not been loaded on the master server.");
                }
            }
            catch (Exception ex) {
                LOGGER.error("Failed to start the replication jobs orchestration on arrived replication module loaded event.", (Throwable)ex);
                SystemAuditLog.error("ReplicationJobsOrchestration", "Failed to start the replication jobs orchestration on replication module loaded event.", null, ex.getMessage());
            }
        }
    }

    private class MasterOrSlaveModeChangedEventHandler
    extends AbstractServerModeChangedEventHandler {
        private MasterOrSlaveModeChangedEventHandler() {
        }

        @Override
        public void processThisIsNowTheMasterServer(AbstractServerModeChangedEventHandler.ServerModeOfThisServerChangedEvent serverModeOfThisServerChangedEvent) {
            LOGGER.info("{}.processThisIsNowTheMasterServer serverModeOfThisServerChangedEvent={}", (Object)this.getClass().getSimpleName(), (Object)serverModeOfThisServerChangedEvent);
            try {
                ReplicationModule.this.sendReplicationJobsToPluginForOrchestration();
                SystemAuditLog.info("ReplicationJobsOrchestration", "Replication jobs orchestration started, because this server '" + serverModeOfThisServerChangedEvent.getThisServerUUID() + "' has become the master.");
            }
            catch (Exception ex) {
                LOGGER.error("Failed to start the replication jobs orchestration on arrived set this server as master event.", (Throwable)ex);
                SystemAuditLog.error("ReplicationJobsOrchestration", "Failed to start the replication jobs orchestration on set as master event.", null, ex.getMessage());
            }
        }

        @Override
        public void processThisIsNowASlaveServer(AbstractServerModeChangedEventHandler.ServerModeOfThisServerChangedEvent serverModeOfThisServerChangedEvent) {
            LOGGER.info("{}.processThisIsNowASlaveServer serverModeOfThisServerChangedEvent={}", (Object)this.getClass().getSimpleName(), (Object)serverModeOfThisServerChangedEvent);
            SystemAuditLog.debug("ReplicationJobsOrchestration", "Replication jobs orchestration not started from this server, because this server '" + serverModeOfThisServerChangedEvent.getThisServerUUID() + "' has become the slave.");
        }
    }

    private class StopReplicationJobActionEventHandler
    extends AbstractEventHandler {
        private StopReplicationJobActionEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return Arrays.asList(event.getPropertyNames()).contains("StopReplicationJobAction");
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            try {
                CoreBundleConfiguration coreBundleConfiguration = ReplicationModule.this.coreBundleConfigurationTracker.getService();
                ReplicationManager replicationManager = ReplicationModule.this.replicationManagerTracker.getService();
                String thisServerUUID = coreBundleConfiguration.getServerUUID();
                ReplicationJobStopActionWebsocketMessage stopJobWsMsg = (ReplicationJobStopActionWebsocketMessage)event.getProperty("StopReplicationJobAction");
                if (!thisServerUUID.equals(stopJobWsMsg.getServerUUID())) {
                    LOGGER.warn("Should not happen that this server with the UUID '{}' receives a replication job stop action event message that is not meant for it: {}", (Object)thisServerUUID, (Object)stopJobWsMsg);
                    return;
                }
                replicationManager.stopReplicationJob(stopJobWsMsg.getJobId());
                SystemAuditLog.info("ReplicationJobsOrchestration", "Replication job '" + stopJobWsMsg.getJobId() + "' stopped on server '" + thisServerUUID + "'.", stopJobWsMsg.getJobId(), null);
                ReplicationModule.this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/replication/job/state/stopped", MapUtil.mapOf("replicationJobId", stopJobWsMsg.getJobId(), "transactionId", stopJobWsMsg.getTransactionId(), "serverUUID", thisServerUUID));
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a stop replication job event.", (Throwable)ex);
                SystemAuditLog.error("ReplicationJobsOrchestration", "Failed to process a stop replication job event.", null, ex.getMessage());
            }
        }
    }

    private class StartReplicationJobActionEventHandler
    extends AbstractEventHandler {
        private StartReplicationJobActionEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return Arrays.asList(event.getPropertyNames()).contains("StartReplicationJobAction");
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            try {
                CoreBundleConfiguration coreBundleConfiguration = ReplicationModule.this.coreBundleConfigurationTracker.getService();
                ReplicationManager replicationManager = ReplicationModule.this.replicationManagerTracker.getService();
                String thisServerUUID = coreBundleConfiguration.getServerUUID();
                ReplicationJobStartActionWebsocketMessage startWsMsg = (ReplicationJobStartActionWebsocketMessage)event.getProperty("StartReplicationJobAction");
                if (!thisServerUUID.equals(startWsMsg.getServerUUID())) {
                    LOGGER.warn("Should not happen that this server with the UUID '{}' receives a replication job start action event message that is not meant for it: {}", (Object)thisServerUUID, (Object)startWsMsg);
                    return;
                }
                replicationManager.startReplicationJob(startWsMsg.getJobId());
                SystemAuditLog.info("ReplicationJobsOrchestration", "Replication job '" + startWsMsg.getJobId() + "' started on server '" + thisServerUUID + "'.", null, startWsMsg.getJobId());
                ReplicationModule.this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/replication/job/state/started", MapUtil.mapOf("replicationJobId", startWsMsg.getJobId(), "transactionId", startWsMsg.getTransactionId(), "serverUUID", thisServerUUID));
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a start replication job event.", (Throwable)ex);
                SystemAuditLog.error("ReplicationJobsOrchestration", "Failed to process a start replication job event.", null, ex.getMessage());
            }
        }
    }

    private class ForcedStartOfReplicationJobActionEventHandler
    extends AbstractEventHandler {
        private ForcedStartOfReplicationJobActionEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return Arrays.asList(event.getPropertyNames()).contains("ForcedStartOfReplicationJobAction");
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            try {
                CoreBundleConfiguration coreBundleConfiguration = ReplicationModule.this.coreBundleConfigurationTracker.getService();
                ReplicationManager replicationManager = ReplicationModule.this.replicationManagerTracker.getService();
                String thisServerUUID = coreBundleConfiguration.getServerUUID();
                ReplicationJobForcedStartWebsocketMessage forcedStartWsMsg = (ReplicationJobForcedStartWebsocketMessage)event.getProperty("ForcedStartOfReplicationJobAction");
                ReplicationJobForcedStartActionDTO forcedStartAction = forcedStartWsMsg.getForcedStartAction();
                replicationManager.forcedStartOfReplicationJob(forcedStartAction.getReplicationJobId());
                if (forcedStartAction.isInitiatedByUser()) {
                    UserAuditLog.info(forcedStartAction.getInitiatedByUser(), "ReplicationJobsOrchestration", "Forced start of replication job '" + forcedStartAction.getReplicationJobId() + "' on server '" + thisServerUUID + "'.", (Object)forcedStartAction.getReplicationJobId(), null);
                } else {
                    SystemAuditLog.info("ReplicationJobsOrchestration", "Forced start of replication job '" + forcedStartAction.getReplicationJobId() + "' on server '" + thisServerUUID + "'.", forcedStartAction.getReplicationJobId(), null);
                }
                ReplicationModule.this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/replication/job/state/forcedStarted", MapUtil.mapOf("replicationJobId", forcedStartAction.getReplicationJobId(), "serverUUID", thisServerUUID));
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a forced start of replication job event.", (Throwable)ex);
                SystemAuditLog.error("ReplicationJobsOrchestration", "Failed to process a forced start of replication job event.", null, ex.getMessage());
            }
        }
    }

    private class RestartOfReplicationJobActionEventHandler
    extends AbstractEventHandler {
        private RestartOfReplicationJobActionEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return Arrays.asList(event.getPropertyNames()).contains("RestartOfReplicationJobAction");
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            try {
                CoreBundleConfiguration coreBundleConfiguration = ReplicationModule.this.coreBundleConfigurationTracker.getService();
                ReplicationManager replicationManager = ReplicationModule.this.replicationManagerTracker.getService();
                String thisServerUUID = coreBundleConfiguration.getServerUUID();
                ReplicationJobRestartWebsocketMessage restartWsMsg = (ReplicationJobRestartWebsocketMessage)event.getProperty("RestartOfReplicationJobAction");
                ReplicationJobRestartActionDTO restartAction = restartWsMsg.getRestartAction();
                replicationManager.restartOfReplicationJob(restartAction.getReplicationJobId());
                if (restartAction.isInitiatedByUser()) {
                    UserAuditLog.info(restartAction.getInitiatedByUser(), "ReplicationJobsOrchestration", "Restart of replication job '" + restartAction.getReplicationJobId() + "' on server '" + thisServerUUID + "'.", (Object)restartAction.getReplicationJobId(), null);
                } else {
                    SystemAuditLog.info("ReplicationJobsOrchestration", "Restart of replication job '" + restartAction.getReplicationJobId() + "' on server '" + thisServerUUID + "'.", restartAction.getReplicationJobId(), null);
                }
                ReplicationModule.this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/replication/job/state/restarted", MapUtil.mapOf("replicationJobId", restartAction.getReplicationJobId(), "serverUUID", thisServerUUID));
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a replication job restart event.", (Throwable)ex);
                SystemAuditLog.error("ReplicationJobsOrchestration", "Failed to process a replication job restart event.", null, ex.getMessage());
            }
        }
    }

    private class RefreshLookupJoinsOfReplicationJobActionEventHandler
    extends AbstractEventHandler {
        private RefreshLookupJoinsOfReplicationJobActionEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return Arrays.asList(event.getPropertyNames()).contains("RefreshLookupJoinsOfReplicationJobAction");
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            try {
                CoreBundleConfiguration coreBundleConfiguration = ReplicationModule.this.coreBundleConfigurationTracker.getService();
                String thisServerUUID = coreBundleConfiguration.getServerUUID();
                RefreshLookupJoinsOfReplicationJobWebsocketMessage websocketMessage = (RefreshLookupJoinsOfReplicationJobWebsocketMessage)event.getProperty("RefreshLookupJoinsOfReplicationJobAction");
                ReplicationJobRefreshLookupJoinsActionDTO action = websocketMessage.getRefreshLookupJoinsAction();
                ReplicationModule.this.refreshLookupJoinsOfReplicationJob(action.getReplicationJobId());
                if (action.isInitiatedByUser()) {
                    UserAuditLog.info(action.getInitiatedByUser(), "ReplicationJobsOrchestration", "Refresh lookup joins of replication job '" + action.getReplicationJobId() + "' on server '" + thisServerUUID + "'.", (Object)action.getReplicationJobId(), null);
                } else {
                    SystemAuditLog.info("ReplicationJobsOrchestration", "Refresh lookup joins of replication job '" + action.getReplicationJobId() + "' on server '" + thisServerUUID + "'.", action.getReplicationJobId(), null);
                }
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a replication job refresh lookup joins event.", (Throwable)ex);
                SystemAuditLog.error("ReplicationJobsOrchestration", "Failed to process a replication job refresh lookup joins event.", null, ex.getMessage());
            }
        }
    }

    private class RefreshLookupJoinsOfAllReplicationJobsActionEventHandler
    extends AbstractEventHandler {
        private RefreshLookupJoinsOfAllReplicationJobsActionEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return Arrays.asList(event.getPropertyNames()).contains("RefreshLookupJoinsOfAllReplicationJobsAction");
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            try {
                CoreBundleConfiguration coreBundleConfiguration = ReplicationModule.this.coreBundleConfigurationTracker.getService();
                String thisServerUUID = coreBundleConfiguration.getServerUUID();
                RefreshLookupJoinsOfAllReplicationJobsWebsocketMessage websocketMessage = (RefreshLookupJoinsOfAllReplicationJobsWebsocketMessage)event.getProperty("RefreshLookupJoinsOfAllReplicationJobsAction");
                ReplicationJobsRefreshLookupJoinsActionDTO action = websocketMessage.getRefreshLookupJoinsAction();
                ReplicationModule.this.refreshLookupJoinsOfAllReplicationJobs();
                if (action.isInitiatedByUser()) {
                    UserAuditLog.info(action.getInitiatedByUser(), "ReplicationJobsOrchestration", "Refresh lookup joins of all replication jobs on server '" + thisServerUUID + "'.");
                } else {
                    SystemAuditLog.info("ReplicationJobsOrchestration", "Refresh lookup joins of all replication jobs on server '" + thisServerUUID + "'.");
                }
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a lookup joins refresh of all replication jobs event.", (Throwable)ex);
                SystemAuditLog.error("ReplicationJobsOrchestration", "Failed to process a lookup joins refresh of all replication jobs event.", null, ex.getMessage());
            }
        }
    }

    private class ClearLookupJoinCachesOfReplicationJobsActionEventHandler
    extends AbstractEventHandler {
        private ClearLookupJoinCachesOfReplicationJobsActionEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return Arrays.asList(event.getPropertyNames()).contains("ClearLookupJoinCachesOfReplicationJobsAction");
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            try {
                CoreBundleConfiguration coreBundleConfiguration = ReplicationModule.this.coreBundleConfigurationTracker.getService();
                String thisServerUUID = coreBundleConfiguration.getServerUUID();
                ClearLookupJoinCachesOfReplicationJobsWebsocketMessage websocketMessage = (ClearLookupJoinCachesOfReplicationJobsWebsocketMessage)event.getProperty("ClearLookupJoinCachesOfReplicationJobsAction");
                ReplicationJobsClearLookupJoinCachesActionDTO action = websocketMessage.getClearLookupJoinCachesAction();
                ReplicationModule.this.clearLookupJoinCaches();
                if (action.isInitiatedByUser()) {
                    UserAuditLog.info(action.getInitiatedByUser(), "ReplicationJobsOrchestration", "Clear lookup join caches of replication jobs on server '" + thisServerUUID + "'.");
                } else {
                    SystemAuditLog.info("ReplicationJobsOrchestration", "Clear lookup join caches of replication jobs on server '" + thisServerUUID + "'.");
                }
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a clear lookup join caches of replication jobs event.", (Throwable)ex);
                SystemAuditLog.error("ReplicationJobsOrchestration", "Failed to process a clear lookup join caches of replication jobs event.", null, ex.getMessage());
            }
        }
    }

    private class ManualStartOfTailsyncActionEventHandler
    extends AbstractEventHandler {
        private ManualStartOfTailsyncActionEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return Arrays.asList(event.getPropertyNames()).contains("ManualStartOfTailsyncAction");
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            try {
                CoreBundleConfiguration coreBundleConfiguration = ReplicationModule.this.coreBundleConfigurationTracker.getService();
                ReplicationManager replicationManager = ReplicationModule.this.replicationManagerTracker.getService();
                String thisServerUUID = coreBundleConfiguration.getServerUUID();
                TailsyncManualStartWebsocketMessage manualStartTailsyncWsMsg = (TailsyncManualStartWebsocketMessage)event.getProperty("ManualStartOfTailsyncAction");
                TailsyncManualStartActionDTO manualStartAction = manualStartTailsyncWsMsg.getManualStartAction();
                replicationManager.manualStartOfTailsync(manualStartAction.getReplicationJobId());
                ReplicationModule.this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/replication/tailsync/manuallyStarted", MapUtil.mapOf("replicationJobId", manualStartAction.getReplicationJobId(), "serverUUID", thisServerUUID));
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a manual start of tailsync event.", (Throwable)ex);
            }
        }
    }

    private class GetReplicationJobStatsActionEventHandler
    extends AbstractEventHandler {
        private GetReplicationJobStatsActionEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return Arrays.asList(event.getPropertyNames()).contains("GetReplicationJobStatsAction");
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            try {
                ReplicationJobStatsRequestWebsocketMessage websocketMessage = (ReplicationJobStatsRequestWebsocketMessage)event.getProperty("GetReplicationJobStatsAction");
                ReplicationJobsWithRuntimeStatsFromServerDTO replicationJobsWithRuntimeStatsFromThisServer = ReplicationModule.this.getReplicationJobsWithRuntimeStatsFromThisServer();
                ReplicationModule.this.eventManagerTracker.getService().fireEvent("de/virtimo/os-bpc-plugin-send-replicationjob-stats-message", MapUtil.mapOf("communicationId", websocketMessage.getCommunicationId(), "replicationJobStats", replicationJobsWithRuntimeStatsFromThisServer));
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a get replication job stats event.", (Throwable)ex);
            }
        }
    }
}

