/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingValidator;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.db.exception.DataSourceNotFoundException;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.FrontendWarningException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.replicator.DatabaseProduct;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationSource;
import de.virtimo.bpc.core.replicator.ReplicationTarget;
import de.virtimo.bpc.core.replicator.SourceTableNameExtractor;
import de.virtimo.bpc.module.simple.SimpleModuleConfig;
import de.virtimo.bpc.util.DateUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.quartz.CronExpression;

public class ReplicationModuleInstanceSettingValidator
implements SettingValidator {
    private static final Logger LOGGER = LogManager.getLogger(ReplicationModuleInstanceSettingValidator.class);
    private final BundleContext bundleContext;
    private final BpcServicesTracker<DatabaseManager> databaseManagerTracker;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;

    public ReplicationModuleInstanceSettingValidator(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(bundleContext, DatabaseManager.class);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
    }

    @Override
    public void destroy() {
        LOGGER.info("destroy");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public boolean canValidate(String moduleId, String moduleInstanceId, String instanceType) {
        return "replication".equalsIgnoreCase(moduleId) && !ModuleConfiguration.isNoModuleInstanceId(moduleInstanceId);
    }

    @Override
    public boolean canValidate(Setting setting) {
        List<String> settingsToValidate = Arrays.asList("sourceTimeZone", "lastUpdateColumnTimeZone");
        return settingsToValidate.contains(setting.getName());
    }

    @Override
    public List<FrontendWarningException> validate(Setting setting) throws ValidationException {
        LOGGER.info("validate setting:{}", (Object)setting);
        if ("sourceTimeZone".equals(setting.getName())) {
            try {
                String sourceTimeZone = (String)setting.getValue();
                if (!StringUtil.isNullOrEmpty(sourceTimeZone)) {
                    ZoneId.of(sourceTimeZone);
                }
            }
            catch (Exception ex) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "The time zone (${field}) is invalid", MapUtil.mapOf("field", "sourceTimeZone"));
            }
        }
        if ("lastUpdateColumnTimeZone".equals(setting.getName())) {
            try {
                String lastUpdateTimestampColumnTimeZone = (String)setting.getValue();
                if (!StringUtil.isNullOrEmpty(lastUpdateTimestampColumnTimeZone)) {
                    ZoneId.of(lastUpdateTimestampColumnTimeZone);
                }
            }
            catch (Exception ex) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "The time zone (${field}) is invalid", MapUtil.mapOf("field", "lastUpdateColumnTimeZone"));
            }
        }
        return null;
    }

    @Override
    public List<FrontendWarningException> validate(String moduleId, String moduleInstanceId, String instanceType, Map<String, Setting> settings) throws ValidationException {
        LOGGER.info("validate moduleId={}, moduleInstanceId={}, instanceType={}, settings:...", (Object)moduleId, (Object)moduleInstanceId, (Object)instanceType);
        try {
            ReplicationJob replicationJob = new ReplicationJob(moduleInstanceId, new SimpleModuleConfig(settings));
            return this.validateReplicationJob(replicationJob);
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause();
            if (cause != null) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, cause.getMessage(), cause);
            }
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, ex.getMessage(), ex);
        }
    }

    private List<FrontendWarningException> validateReplicationJob(ReplicationJob replicationJob) throws ValidationException {
        LOGGER.info("validateReplicationJob replicationJob:{}", (Object)replicationJob);
        if (replicationJob == null) {
            return null;
        }
        if (!replicationJob.isEnabled()) {
            LOGGER.info("Skipping validation of disabled replication job: {}", (Object)replicationJob);
            return null;
        }
        ArrayList<FrontendWarningException> frontendWarnings = new ArrayList<FrontendWarningException>();
        HashMap<String, Integer> databaseTableColumns = new HashMap();
        ReplicationSource source = replicationJob.getSource();
        Connection databaseConnection = null;
        try {
            DatabaseManager databaseManager = this.databaseManagerTracker.getService();
            LOGGER.info("Database manager service: {}", (Object)(databaseManager != null ? 1 : 0));
            DataSource dataSource = databaseManager.getDataSource(source.getDataSourceName());
            LOGGER.info("Data source: {}", (Object)(dataSource != null ? 1 : 0));
            databaseConnection = dataSource.getConnection();
            LOGGER.info("Database connection: {}", (Object)(databaseConnection != null ? 1 : 0));
            if (databaseConnection == null || !databaseConnection.isValid(10)) {
                throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_INVALID_CONNECTION, "Database connection of replication job id '${subFieldValue}' is invalid", MapUtil.mapOf("subFieldValue", replicationJob.getId()));
            }
            boolean databaseTableRelatedChecksCanBeDone = StringUtil.isNullOrEmpty(source.getCommonTableExpressionQuery());
            if (databaseTableRelatedChecksCanBeDone) {
                LOGGER.info("Validating database table: {}", (Object)source.getTable());
                DatabaseMetaData databaseMetaData = databaseConnection.getMetaData();
                SourceTableNameExtractor extractor = this.createSourceTableNameExtractor(replicationJob, databaseMetaData);
                LOGGER.info("Source table name extractor: {}", (Object)extractor);
                this.checkIfTableExists(replicationJob, databaseMetaData, extractor);
                this.checkIfLastUpdateColumnExists(replicationJob, databaseMetaData, extractor);
                if (DatabaseProduct.getIdentifier(databaseConnection) != DatabaseProduct.Identifier.ORACLE) {
                    this.checkIfIndexOnLastUpdateColumnExists(replicationJob, databaseConnection, extractor, frontendWarnings);
                }
                this.checkIfIdColumnsExist(replicationJob, databaseMetaData, extractor);
                databaseTableColumns = this.extractDatabaseTableColumns(databaseMetaData, extractor);
                if (replicationJob.getSettings().isSyncFiles()) {
                    this.performDatabaseBlobColumnsToOpenSearchTypeMappingsValidation(replicationJob, databaseTableColumns);
                }
            }
            this.performReplicationStartDateValidation(replicationJob);
            if (replicationJob.getShadowCopy().isEnabled()) {
                this.performShadowCopySettingsValidation(replicationJob);
            }
            if (replicationJob.getTailSync().isEnabled()) {
                this.performTailSyncSettingsValidation(replicationJob);
            }
            ArrayList<FrontendWarningException> arrayList = frontendWarnings;
            return arrayList;
        }
        catch (ValidationException ex) {
            throw ex;
        }
        catch (ServiceNotFoundException ex) {
            throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_EXCEPTION, "No DatabaseManager service registered");
        }
        catch (DataSourceNotFoundException ex) {
            throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_EXCEPTION, "Data source '${dataSourceName}' not found while validating settings of replication job id '${subFieldValue}'", MapUtil.mapOf("subFieldValue", replicationJob.getId(), "dataSourceName", ex.getProperties().get("dataSourceName")), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_EXCEPTION, "Database exception while validating settings of replication job id '${subFieldValue}'", MapUtil.mapOf("subFieldValue", replicationJob.getId()), (Throwable)ex);
        }
        finally {
            if (databaseConnection != null) {
                try {
                    databaseConnection.close();
                }
                catch (Exception ex) {
                    LOGGER.error("Closing database connection failed.", (Throwable)ex);
                }
            }
        }
    }

    private SourceTableNameExtractor createSourceTableNameExtractor(ReplicationJob replicationJob, DatabaseMetaData databaseMetaData) throws ValidationException, SQLException {
        LOGGER.debug("createSourceTableNameExtractor replicationJob=..., databaseMetaData=...");
        ReplicationSource source = replicationJob.getSource();
        SourceTableNameExtractor extractor = new SourceTableNameExtractor(databaseMetaData, source.getTable());
        if (!extractor.isParsed()) {
            throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_TABLE_NOT_FOUND, "Could not access the database table '${tableName}' of replication job id '${subFieldValue}'", MapUtil.mapOf("subFieldValue", replicationJob.getId(), "tableName", source.getTable()));
        }
        return extractor;
    }

    private void checkIfTableExists(ReplicationJob replicationJob, DatabaseMetaData databaseMetaData, SourceTableNameExtractor extractor) throws ValidationException, SQLException {
        LOGGER.debug("checkIfTableExists replicationJob=..., databaseMetaData=..., extractor=...");
        ReplicationSource source = replicationJob.getSource();
        try (ResultSet tablesResultSet = databaseMetaData.getTables(extractor.getCatalogName(), extractor.getSchemaName(), extractor.getTableName(), null);){
            if (!tablesResultSet.next()) {
                throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_TABLE_NOT_FOUND, "The database table '${tableName}' of replication job id '${subFieldValue}' does not exist", MapUtil.mapOf("subFieldValue", replicationJob.getId(), "tableName", source.getTable()));
            }
        }
    }

    private void checkIfLastUpdateColumnExists(ReplicationJob replicationJob, DatabaseMetaData databaseMetaData, SourceTableNameExtractor extractor) throws ValidationException, SQLException {
        LOGGER.debug("checkIfLastUpdateColumnExists replicationJob=..., databaseMetaData=..., extractor=...");
        ReplicationSource source = replicationJob.getSource();
        try (ResultSet lastUpdateColumnResultSet = databaseMetaData.getColumns(extractor.getCatalogName(), extractor.getSchemaName(), extractor.getTableName(), source.getLastUpdateColumn());){
            if (!lastUpdateColumnResultSet.next()) {
                throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_COLUMN_NOT_FOUND, "The last update timestamp column '${column}' of replication job id '${subFieldValue}' does not exist in the database table '${tableName}'.", MapUtil.mapOf("subFieldValue", replicationJob.getId(), "tableName", source.getTable(), "column", source.getLastUpdateColumn()));
            }
        }
    }

    private void checkIfIndexOnLastUpdateColumnExists(ReplicationJob replicationJob, Connection databaseConnection, SourceTableNameExtractor extractor, List<FrontendWarningException> frontendWarnings) {
        LOGGER.debug("checkIfIndexOnLastUpdateColumnExists replicationJob=..., databaseConnection=..., extractor=..., frontendWarnings=...");
        ReplicationSource source = replicationJob.getSource();
        try {
            if (!this.isColumnWithIndex(databaseConnection, extractor, source.getLastUpdateColumn())) {
                frontendWarnings.add(new FrontendWarningException("Serious performance warning! There seems to be no index on the last update column '${column}' of the database table '${tableName}'.", MapUtil.mapOf("subFieldValue", replicationJob.getId(), "tableName", source.getTable(), "column", source.getLastUpdateColumn())));
            }
        }
        catch (SQLException e) {
            LOGGER.info("Database exception while checking the table '{}' if an index exists for the last update timestamp column: '{}'. Happens for example by database views.", (Object)source.getTable(), (Object)source.getLastUpdateColumn(), (Object)e);
        }
        catch (Exception e) {
            LOGGER.info("Unexpected exception occurred while checking the table '{}' if an index exists for the last update timestamp column: '{}'.", (Object)source.getTable(), (Object)source.getLastUpdateColumn(), (Object)e);
        }
    }

    private void checkIfIdColumnsExist(ReplicationJob replicationJob, DatabaseMetaData databaseMetaData, SourceTableNameExtractor extractor) throws ValidationException, SQLException {
        LOGGER.debug("checkIfIdColumnsExist replicationJob=..., databaseMetaData=..., extractor=...");
        ReplicationSource source = replicationJob.getSource();
        for (String idColumn : source.getIdColumns()) {
            try (ResultSet idColumnResultSet = databaseMetaData.getColumns(extractor.getCatalogName(), extractor.getSchemaName(), extractor.getTableName(), idColumn);){
                if (idColumnResultSet.next()) continue;
                throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_COLUMN_NOT_FOUND, "The ID column '${column}' of replication job id '${subFieldValue}' does not exist in the database table '${tableName}'.", MapUtil.mapOf("subFieldValue", replicationJob.getId(), "tableName", source.getTable(), "column", idColumn));
            }
        }
    }

    private Map<String, Integer> extractDatabaseTableColumns(DatabaseMetaData databaseMetaData, SourceTableNameExtractor extractor) throws SQLException {
        LOGGER.debug("extractDatabaseTableColumns databaseMetaData=..., extractor=...");
        HashMap<String, Integer> databaseTableColumns = new HashMap<String, Integer>();
        try (ResultSet allColumnsResultSet = databaseMetaData.getColumns(extractor.getCatalogName(), extractor.getSchemaName(), extractor.getTableName(), null);){
            while (allColumnsResultSet.next()) {
                String columnName = allColumnsResultSet.getString("COLUMN_NAME");
                int columnType = allColumnsResultSet.getInt("DATA_TYPE");
                LOGGER.info("Database column:{}, type:{}", (Object)columnName, (Object)columnType);
                databaseTableColumns.put(columnName, columnType);
            }
        }
        return databaseTableColumns;
    }

    private void performDatabaseBlobColumnsToOpenSearchTypeMappingsValidation(ReplicationJob replicationJob, Map<String, Integer> databaseTableColumns) throws ValidationException {
        LOGGER.debug("performDatabaseBlobColumnsToOpenSearchTypeMappingsValidation replicationJob=..., databaseTableColumns=...");
        ReplicationTarget target = replicationJob.getTarget();
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            if (oss.existsIndex(target.getIndex())) {
                Map<String, String> typeMapping = oss.getFieldsTypeMapping(target.getIndex());
                for (String databaseTableColumnName : databaseTableColumns.keySet()) {
                    int dbType = databaseTableColumns.get(databaseTableColumnName);
                    if (dbType != 2004) continue;
                    String openSearchType = typeMapping.get(databaseTableColumnName);
                    if (openSearchType == null) {
                        throw new ValidationException((ErrorCode)BpcErrorCode.OPENSEARCH_MAPPING, "OpenSearch mapping of replication job id '${subFieldValue}' missing for database column '${column}'. Should be 'attachment' for BLOB types.", MapUtil.mapOf("subFieldValue", replicationJob.getId(), "column", databaseTableColumnName));
                    }
                    if (openSearchType.equalsIgnoreCase("binary")) continue;
                    throw new ValidationException((ErrorCode)BpcErrorCode.OPENSEARCH_MAPPING, "Wrong OpenSearch mapping for database column '${column}' of replication job id '${subFieldValue}'. Expected 'attachment', is '${openSearchType}'.", MapUtil.mapOf("subFieldValue", replicationJob.getId(), "column", databaseTableColumnName, "openSearchType", openSearchType));
                }
            }
        }
        catch (ValidationException ex) {
            throw ex;
        }
        catch (ServiceNotFoundException ex) {
            throw new ValidationException((ErrorCode)BpcErrorCode.OPENSEARCH_EXCEPTION, "Failed to get the OpenSearch service.");
        }
        catch (Exception ex) {
            throw new ValidationException((ErrorCode)BpcErrorCode.OPENSEARCH_EXCEPTION, "OpenSearch exception while validating replication settings of replication job id '${subFieldValue}'.", MapUtil.mapOf("subFieldValue", replicationJob.getId()), (Throwable)ex);
        }
    }

    private void performReplicationStartDateValidation(ReplicationJob replicationJob) throws ValidationException {
        LOGGER.debug("performReplicationStartDateValidation replicationJob=...");
        try {
            replicationJob.getSettings().getDateFormatter().parse(replicationJob.getSettings().getReplicationStartDate());
        }
        catch (ParseException pex) {
            try {
                DateUtil.getDateForRelativeValue(replicationJob.getSettings().getReplicationStartDate());
            }
            catch (IllegalArgumentException iaex) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "Wrong replication start date '${startDate}' used in replication job id '${subFieldValue}'.", MapUtil.mapOf("subFieldValue", replicationJob.getId(), "startDate", replicationJob.getSettings().getReplicationStartDate()));
            }
        }
    }

    private void performShadowCopySettingsValidation(ReplicationJob replicationJob) throws ValidationException {
        LOGGER.debug("performShadowCopySettingsValidation replicationJob=...");
        String shadowCopyCronPattern = replicationJob.getShadowCopy().getCronPattern();
        if (StringUtil.isNullOrEmpty(shadowCopyCronPattern)) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "No shadow copy cron pattern given in replication job id '${subFieldValue}'.", MapUtil.mapOf("subFieldValue", replicationJob.getId()));
        }
        try {
            CronExpression cronExpression = new CronExpression(shadowCopyCronPattern);
        }
        catch (ParseException ex) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "Invalid shadow copy cron pattern '${pattern}' used in replication job id '${subFieldValue}': ${cronExpressionErrorMessage}.", MapUtil.mapOf("subFieldValue", replicationJob.getId(), "pattern", shadowCopyCronPattern, "cronExpressionErrorOffset", ex.getErrorOffset(), "cronExpressionErrorMessage", ex.getMessage()));
        }
    }

    private void performTailSyncSettingsValidation(ReplicationJob replicationJob) throws ValidationException {
        LOGGER.debug("performTailSyncSettingsValidation replicationJob=...");
        String tailSyncCronPattern = replicationJob.getTailSync().getCronPattern();
        if (StringUtil.isNullOrEmpty(tailSyncCronPattern)) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "No tail sync cron pattern given in replication job id '${subFieldValue}'.", MapUtil.mapOf("subFieldValue", replicationJob.getId()));
        }
        try {
            CronExpression cronExpression = new CronExpression(tailSyncCronPattern);
        }
        catch (ParseException ex) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "Invalid tail sync cron pattern '${pattern}' used in replication job id '${subFieldValue}': ${cronExpressionErrorMessage}.", MapUtil.mapOf("subFieldValue", replicationJob.getId(), "pattern", tailSyncCronPattern, "cronExpressionErrorOffset", ex.getErrorOffset(), "cronExpressionErrorMessage", ex.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isColumnWithIndex(Connection conn, SourceTableNameExtractor extractor, String columnNameToCheck) throws SQLException {
        LOGGER.debug("isColumnWithIndex conn=..., extractor={}, columnNameToCheck={}", (Object)extractor, (Object)columnNameToCheck);
        DatabaseMetaData databaseMetaData = conn.getMetaData();
        try (ResultSet rs = databaseMetaData.getIndexInfo(extractor.getCatalogName(), extractor.getSchemaName(), extractor.getTableName(), false, false);){
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                if (!columnNameToCheck.equalsIgnoreCase(columnName)) continue;
                boolean bl = true;
                return bl;
            }
        }
        if (DatabaseProduct.getIdentifier(conn) != DatabaseProduct.Identifier.ORACLE) return false;
        try (PreparedStatement pstmt = conn.prepareStatement("SELECT COLUMN_EXPRESSION FROM user_ind_expressions WHERE INDEX_NAME=?");
             ResultSet oracleIndexInfoRS = databaseMetaData.getIndexInfo(extractor.getCatalogName(), extractor.getSchemaName(), extractor.getTableName(), false, false);){
            block25: while (oracleIndexInfoRS.next()) {
                String indexName = oracleIndexInfoRS.getString("INDEX_NAME");
                String columnName = oracleIndexInfoRS.getString("COLUMN_NAME");
                if (columnName == null || !columnName.startsWith("SYS_")) continue;
                pstmt.setString(1, indexName);
                ResultSet oracleSearchRS = pstmt.executeQuery();
                try {
                    String colExpr;
                    do {
                        if (!oracleSearchRS.next()) continue block25;
                        colExpr = oracleSearchRS.getString("COLUMN_EXPRESSION");
                        LOGGER.info("{}/{}/{}: Found the column expression: {}", (Object)extractor.getTableName(), (Object)columnName, (Object)indexName, (Object)colExpr);
                    } while (!colExpr.toUpperCase().contains("\"" + columnNameToCheck.toUpperCase() + "\""));
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (oracleSearchRS == null) continue;
                    oracleSearchRS.close();
                }
            }
            return false;
        }
    }
}

