/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.tailsync;

import de.virtimo.bpc.api.ModuleConfiguration;
import java.util.Date;
import java.util.Objects;

public class TailSync {
    public static final String TAILSYNC_ENABLED_FIELD = "replicationTailSyncEnabled";
    public static final String TAILSYNC_CRON_PATTERN_FIELD = "replicationTailSyncCronPattern";
    public static final String TAILSYNC_BLOCK_SIZE_FIELD = "replicationTailSyncBlockSize";
    public static final String TAILSYNC_RELATIVE_START_DATE_FIELD = "replicationTailSyncRelativeStartDate";
    public static final String TAILSYNC_RELATIVE_END_DATE_FIELD = "replicationTailSyncRelativeEndDate";
    public static final String TAILSYNC_BLOCK_DAY_RANGE_FIELD = "replicationTailSyncBlockDayRange";
    public static final String TAILSYNC_RELATIVE_DELETE_OLDER_THAN_DATE = "replicationTailSyncRelativeDeleteOlderThanDate";
    public static final String TAILSYNC_LOGGING_ENABLED_FIELD = "replicationTailSyncLoggingEnabled";
    public static final boolean DEFAULT_TAILSYNC_ENABLED = false;
    public static final String DEFAULT_TAILSYNC_CRON_PATTERN = "0 0 2 * * ?";
    public static final int DEFAULT_TAILSYNC_BLOCK_SIZE = 2500;
    public static final String DEFAULT_TAILSYNC_RELATIVE_START_DATE = "";
    public static final String DEFAULT_TAILSYNC_RELATIVE_END_DATE = "12 hours ago";
    public static final int DEFAULT_TAILSYNC_BLOCK_DAY_RANGE = 10;
    public static final String DEFAULT_TAILSYNC_RELATIVE_DELETE_OLDER_THAN_DATE = null;
    public static final boolean DEFAULT_TAILSYNC_LOGGING_ENABLED = false;
    private final boolean enabled;
    private final String cronPattern;
    private final int blockSize;
    private final int blockDayRange;
    private final String relativeStartDate;
    private final String relativeEndDate;
    private final String relativeDeleteOlderThanDate;
    private final boolean loggingEnabled;
    private transient boolean running;
    private transient long runCount;
    private transient long errorCount;
    private transient Date lastRunStart;
    private transient Date lastRunEnd;
    private transient long newRecords;
    private transient long updatedRecords;
    private transient long deletedRecords;

    public TailSync(ModuleConfiguration jobConfig) {
        this.enabled = jobConfig.getSettingValue(TAILSYNC_ENABLED_FIELD).asBoolean(false);
        this.cronPattern = jobConfig.getSettingValue(TAILSYNC_CRON_PATTERN_FIELD).asString(DEFAULT_TAILSYNC_CRON_PATTERN);
        this.blockSize = jobConfig.getSettingValue(TAILSYNC_BLOCK_SIZE_FIELD).asInt(2500);
        this.blockDayRange = jobConfig.getSettingValue(TAILSYNC_BLOCK_DAY_RANGE_FIELD).asInt(10);
        this.relativeStartDate = jobConfig.getSettingValue(TAILSYNC_RELATIVE_START_DATE_FIELD).asString(DEFAULT_TAILSYNC_RELATIVE_START_DATE);
        this.relativeEndDate = jobConfig.getSettingValue(TAILSYNC_RELATIVE_END_DATE_FIELD).asString(DEFAULT_TAILSYNC_RELATIVE_END_DATE);
        this.relativeDeleteOlderThanDate = jobConfig.getSettingValue(TAILSYNC_RELATIVE_DELETE_OLDER_THAN_DATE).asString(DEFAULT_TAILSYNC_RELATIVE_DELETE_OLDER_THAN_DATE);
        this.loggingEnabled = jobConfig.getSettingValue(TAILSYNC_LOGGING_ENABLED_FIELD).asBoolean(false);
    }

    private TailSync(Builder builder) {
        this.enabled = builder.enabled;
        this.cronPattern = builder.cronPattern;
        this.blockSize = builder.blockSize;
        this.blockDayRange = builder.blockDayRange;
        this.relativeStartDate = builder.relativeStartDate;
        this.relativeEndDate = builder.relativeEndDate;
        this.relativeDeleteOlderThanDate = builder.relativeDeleteOlderThanDate;
        this.loggingEnabled = builder.loggingEnabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public String getCronPattern() {
        return this.cronPattern;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getBlockDayRange() {
        return this.blockDayRange;
    }

    public String getRelativeStartDate() {
        return this.relativeStartDate;
    }

    public String getRelativeEndDate() {
        return this.relativeEndDate;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public Date getLastRunStart() {
        return this.lastRunStart;
    }

    public void setLastRunStart(Date lastRunStart) {
        this.lastRunStart = lastRunStart;
    }

    public Date getLastRunEnd() {
        return this.lastRunEnd;
    }

    public void setLastRunEnd(Date lastRunEnd) {
        this.lastRunEnd = lastRunEnd;
    }

    public long getRunCount() {
        return this.runCount;
    }

    public void increaseRunCount() {
        ++this.runCount;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public void increaseErrorCount() {
        ++this.errorCount;
    }

    public long getNewRecords() {
        return this.newRecords;
    }

    public long getUpdatedRecords() {
        return this.updatedRecords;
    }

    public long getDeletedRecords() {
        return this.deletedRecords;
    }

    public void addTailSyncLastRunRecords(long tailSyncLastRunNewRecords, long tailSyncLastRunUpdatedRecords, long tailSyncLastRunDeletedRecords) {
        this.newRecords += tailSyncLastRunNewRecords;
        this.updatedRecords += tailSyncLastRunUpdatedRecords;
        this.deletedRecords += tailSyncLastRunDeletedRecords;
    }

    public String getRelativeDeleteOlderThanDate() {
        return this.relativeDeleteOlderThanDate;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TailSync)) {
            return false;
        }
        TailSync tailSync = (TailSync)o;
        return this.enabled == tailSync.enabled && this.blockSize == tailSync.blockSize && this.blockDayRange == tailSync.blockDayRange && Objects.equals(this.cronPattern, tailSync.cronPattern) && Objects.equals(this.relativeStartDate, tailSync.relativeStartDate) && Objects.equals(this.relativeEndDate, tailSync.relativeEndDate) && Objects.equals(this.relativeDeleteOlderThanDate, tailSync.relativeDeleteOlderThanDate) && this.loggingEnabled == tailSync.loggingEnabled;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.cronPattern, this.blockSize, this.blockDayRange, this.relativeStartDate, this.relativeEndDate, this.relativeDeleteOlderThanDate, this.loggingEnabled);
    }

    public String toString() {
        return "TailSync{enabled=" + this.enabled + ", cronPattern='" + this.cronPattern + "', blockSize=" + this.blockSize + ", blockDayRange=" + this.blockDayRange + ", relativeStartDate='" + this.relativeStartDate + "', relativeEndDate='" + this.relativeEndDate + "', relativeDeleteOlderThanDate='" + this.relativeDeleteOlderThanDate + "', loggingEnabled=" + this.loggingEnabled + ", running=" + this.running + ", runCount=" + this.runCount + ", errorCount=" + this.errorCount + ", lastRunStart=" + String.valueOf(this.lastRunStart) + ", lastRunEnd=" + String.valueOf(this.lastRunEnd) + ", newRecords=" + this.newRecords + ", updatedRecords=" + this.updatedRecords + ", deletedRecords=" + this.deletedRecords + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean enabled = false;
        private String cronPattern = "0 0 2 * * ?";
        private int blockSize = 2500;
        private int blockDayRange = 10;
        private String relativeStartDate = "";
        private String relativeEndDate = "12 hours ago";
        private String relativeDeleteOlderThanDate = DEFAULT_TAILSYNC_RELATIVE_DELETE_OLDER_THAN_DATE;
        private boolean loggingEnabled = false;

        private Builder() {
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder cronPattern(String cronPattern) {
            this.cronPattern = cronPattern;
            return this;
        }

        public Builder blockSize(int blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public Builder blockDayRange(int blockDayRange) {
            this.blockDayRange = blockDayRange;
            return this;
        }

        public Builder relativeStartDate(String relativeStartDate) {
            this.relativeStartDate = relativeStartDate;
            return this;
        }

        public Builder relativeEndDate(String relativeEndDate) {
            this.relativeEndDate = relativeEndDate;
            return this;
        }

        public Builder relativeDeleteOlderThanDate(String relativeDeleteOlderThanDate) {
            this.relativeDeleteOlderThanDate = relativeDeleteOlderThanDate;
            return this;
        }

        public Builder loggingEnabled(boolean loggingEnabled) {
            this.loggingEnabled = loggingEnabled;
            return this;
        }

        public TailSync build() {
            return new TailSync(this);
        }
    }
}

