/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.tailsync;

import de.virtimo.bpc.core.replicator.DbLowerLimitTimestampEvaluator;
import de.virtimo.bpc.core.replicator.DbQueryBuilder;
import de.virtimo.bpc.core.replicator.OpenSearchRecordID;
import de.virtimo.bpc.core.replicator.ReplicationJobSettings;
import de.virtimo.bpc.core.replicator.ReplicationSource;
import de.virtimo.bpc.core.replicator.tailsync.GetDataResult;
import de.virtimo.bpc.core.replicator.tailsync.RecordData;
import de.virtimo.bpc.util.MapUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class TailSyncDatabaseHandler {
    private static final Logger LOGGER = LogManager.getLogger(TailSyncDatabaseHandler.class);
    private final String replicationJobId;
    private Connection dbConnection = null;
    private PreparedStatement selectByRangePreparedStatement = null;
    private PreparedStatement selectByIdPreparedStatement = null;
    private boolean vamWorkaroundActive = false;
    private String vamOrganizationId = null;

    TailSyncDatabaseHandler(DataSource dataSource, String replicationJobId) throws SQLException {
        this.replicationJobId = replicationJobId;
        this.dbConnection = dataSource.getConnection();
        this.dbConnection.setAutoCommit(false);
    }

    void destroy() {
        LOGGER.info("{}: destroy", (Object)this.replicationJobId);
        if (this.selectByRangePreparedStatement != null) {
            try {
                this.selectByRangePreparedStatement.close();
            }
            catch (SQLException ex) {
                LOGGER.error("{}: Closing 'select by range' prepared statement failed.", (Object)this.replicationJobId, (Object)ex);
            }
        }
        if (this.selectByIdPreparedStatement != null) {
            try {
                this.selectByIdPreparedStatement.close();
            }
            catch (SQLException ex) {
                LOGGER.error("{}: Closing 'select by id' prepared statement failed.", (Object)this.replicationJobId, (Object)ex);
            }
        }
        if (this.dbConnection != null) {
            try {
                this.dbConnection.close();
            }
            catch (SQLException ex) {
                LOGGER.error("{}: Closing database connection failed.", (Object)this.replicationJobId, (Object)ex);
            }
        }
    }

    void initVamWorkaround(String vamOrganizationId) {
        this.vamWorkaroundActive = vamOrganizationId != null;
        this.vamOrganizationId = vamOrganizationId;
    }

    void initSelectByIdPreparedStatement(ReplicationSource replicationSource) throws SQLException {
        this.selectByIdPreparedStatement = this.createSelectByIdPreparedStatement(replicationSource.getCommonTableExpressionQuery(), replicationSource.getTable(), replicationSource.getIdColumns());
    }

    void initSelectByRangePreparedStatements(int blockSize, ReplicationSource replicationSource) throws SQLException {
        this.selectByRangePreparedStatement = this.createSelectByRangePreparedStatement(replicationSource.getCommonTableExpressionQuery(), replicationSource.getTable(), replicationSource.getIdColumns(), replicationSource.getLastUpdateColumn());
        this.selectByRangePreparedStatement.setFetchSize(blockSize);
    }

    private PreparedStatement createSelectByIdPreparedStatement(String dbCommonTableExpressionQuery, String dbTable, String[] dbIdColumnNames) throws SQLException {
        LOGGER.debug("createSelectByIdPreparedStatement dbCommonTableExpressionQuery={}, dbTable={}, dbIdColumnNames={}", (Object)dbCommonTableExpressionQuery, (Object)dbTable, (Object)dbIdColumnNames);
        String preparedStatement = new DbQueryBuilder(this.dbConnection).withCommonTableExpressionQuery(dbTable, dbCommonTableExpressionQuery).withQuery("SELECT * FROM $TABLE WHERE $COLUMN = ?[ AND ]").withPlaceHolders(MapUtil.mapOf("$TABLE", dbTable, "$COLUMN = ?[ AND ]", dbIdColumnNames)).build();
        LOGGER.info("{}: Prepared 'select by id' statement: {}", (Object)this.replicationJobId, (Object)preparedStatement);
        return this.dbConnection.prepareStatement(preparedStatement, 1003, 1007);
    }

    private PreparedStatement createSelectByRangePreparedStatement(String dbCommonTableExpressionQuery, String dbTable, String[] dbIdColumnNames, String dbLastUpdateColumnName) throws SQLException {
        LOGGER.debug("createSelectByRangePreparedStatement dbCommonTableExpressionQuery={}, dbTable={}, dbIdColumnNames={}, dbLastUpdateColumnName={}", (Object)dbCommonTableExpressionQuery, (Object)dbTable, (Object)dbIdColumnNames, (Object)dbLastUpdateColumnName);
        ArrayList<String> columnsToSelect = new ArrayList<String>();
        columnsToSelect.addAll(Arrays.asList(dbIdColumnNames));
        columnsToSelect.add(dbLastUpdateColumnName);
        String preparedStatement = this.vamWorkaroundActive ? new DbQueryBuilder(this.dbConnection).withCommonTableExpressionQuery(dbTable, dbCommonTableExpressionQuery).withQuery("SELECT $COLUMNS_TO_SELECT[] FROM $TABLE WHERE $LASTUPDATE_COLUMN > ? AND $LASTUPDATE_COLUMN <= ? AND (DELETED = '0' AND ORGANIZATIONID = ?) ORDER BY $LASTUPDATE_COLUMN ASC").withPlaceHolders(MapUtil.mapOf("$COLUMNS_TO_SELECT[]", columnsToSelect, "$TABLE", dbTable, "$LASTUPDATE_COLUMN", dbLastUpdateColumnName)).build() : new DbQueryBuilder(this.dbConnection).withCommonTableExpressionQuery(dbTable, dbCommonTableExpressionQuery).withQuery("SELECT $COLUMNS_TO_SELECT[] FROM $TABLE WHERE $LASTUPDATE_COLUMN > ? AND $LASTUPDATE_COLUMN <= ? ORDER BY $LASTUPDATE_COLUMN ASC").withPlaceHolders(MapUtil.mapOf("$COLUMNS_TO_SELECT[]", columnsToSelect, "$TABLE", dbTable, "$LASTUPDATE_COLUMN", dbLastUpdateColumnName)).build();
        LOGGER.info("{}: Prepared 'select by lastupdate date' statement: {}", (Object)this.replicationJobId, (Object)preparedStatement);
        return this.dbConnection.prepareStatement(preparedStatement, 1003, 1007);
    }

    Timestamp evaluateStartTimestamp(ReplicationJobSettings replicationJobSettings, ReplicationSource replicationSource) throws SQLException {
        LOGGER.debug("{}: evaluateStartTimestamp replicationJobSettings={}, replicationSource={}", (Object)this.replicationJobId, (Object)replicationJobSettings, (Object)replicationSource);
        Timestamp startTimestamp = new Timestamp(replicationJobSettings.getReplicationStartDateAsDate().getTime());
        Timestamp lowerLimitTimestamp = DbLowerLimitTimestampEvaluator.getLowerLimitTimestamp(this.dbConnection, replicationSource.getQueryTimeoutInSeconds(), replicationSource.getCommonTableExpressionQuery(), replicationSource.getTable(), replicationSource.getLastUpdateColumn(), replicationSource.getLastUpdateColumnTimeZoneCalendar(), startTimestamp);
        if (lowerLimitTimestamp != null && lowerLimitTimestamp.after(startTimestamp)) {
            LOGGER.info("{}: Fittet start date to oldest record found in range. Old limit: {} new limit: {}", (Object)this.replicationJobId, (Object)startTimestamp, (Object)lowerLimitTimestamp);
            return lowerLimitTimestamp;
        }
        LOGGER.info("{}: No lower limit fitting needed", (Object)this.replicationJobId);
        return startTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GetDataResult getRecordData(String[] dbIdColumnNames, String dbLastUpdateColumnName, Calendar dbLastUpdateColumnCalendar, Timestamp lowerDateLimit, Timestamp upperDateLimit) {
        LOGGER.info("{}: getRecordData dbIdColumnNames=..., dbLastUpdateColumnName={}, dbLastUpdateColumnCalendar={}, lowerDateLimit={}, upperDateLimit={}", (Object)this.replicationJobId, (Object)dbLastUpdateColumnName, (Object)dbLastUpdateColumnCalendar, (Object)lowerDateLimit, (Object)upperDateLimit);
        long startTimestamp = System.currentTimeMillis();
        try {
            HashMap<String, RecordData> result = new HashMap<String, RecordData>();
            if (dbLastUpdateColumnCalendar != null) {
                this.selectByRangePreparedStatement.setTimestamp(1, lowerDateLimit, dbLastUpdateColumnCalendar);
                this.selectByRangePreparedStatement.setTimestamp(2, upperDateLimit, dbLastUpdateColumnCalendar);
            } else {
                this.selectByRangePreparedStatement.setTimestamp(1, lowerDateLimit);
                this.selectByRangePreparedStatement.setTimestamp(2, upperDateLimit);
            }
            if (this.vamWorkaroundActive) {
                this.selectByRangePreparedStatement.setString(3, this.vamOrganizationId);
            }
            try (ResultSet rs = this.selectByRangePreparedStatement.executeQuery();){
                while (rs.next()) {
                    LinkedHashMap<String, Object> columnNamesWithValues = OpenSearchRecordID.getColumnNamesWithValues(rs, dbIdColumnNames);
                    Timestamp lastUpdateTimestamp = dbLastUpdateColumnCalendar != null ? rs.getTimestamp(dbLastUpdateColumnName, dbLastUpdateColumnCalendar) : rs.getTimestamp(dbLastUpdateColumnName);
                    RecordData recordData = new RecordData(columnNamesWithValues, lastUpdateTimestamp);
                    result.put(recordData.getRecordId(), recordData);
                }
            }
            GetDataResult getDataResult = new GetDataResult(result);
            return getDataResult;
        }
        catch (Throwable throwable) {
            GetDataResult getDataResult = new GetDataResult(throwable);
            return getDataResult;
        }
        finally {
            LOGGER.info("{}: getRecordData time: {} ms", (Object)this.replicationJobId, (Object)(System.currentTimeMillis() - startTimestamp));
        }
    }

    ResultSet getDatabaseRecordByID(String[] idColumnNames, RecordData recordData) throws SQLException {
        LinkedHashMap<String, Object> idColumnNamesAndValues = recordData.getIdColumnNamesAndValues();
        for (int i = 0; i < idColumnNames.length; ++i) {
            this.selectByIdPreparedStatement.setObject(1 + i, idColumnNamesAndValues.get(idColumnNames[i]));
        }
        return this.selectByIdPreparedStatement.executeQuery();
    }
}

