/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.tailsync.logger;

import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.tailsync.TailSync;
import java.util.Date;

public record TailsyncLogData(String replicationJobId, String dataSource, String sourceTable, String targetIndex, String deleteEntriesOlderThan, long usedBlockDayRange, long usedBlockSize, String relativeStartDate, String relativeEndDate, Date startDate, Date endDate, long durationInMilliseconds, boolean manualStart, long addedEntries, long updatedEntries, long deletedEntries, String error, String[] warnings) {
    public static TailsyncLogData createFromTailsync(ReplicationJob replicationJob, TailSync tailsync, boolean isManualStart, long tailsyncDurationMillis, long addedEntries, long updatedEntries, long deletedEntries, String error, String[] warnings) {
        return new TailsyncLogData(replicationJob.getId(), replicationJob.getSource().getDataSourceName(), replicationJob.getSource().getTable(), replicationJob.getTarget().getIndex(), tailsync.getRelativeDeleteOlderThanDate(), tailsync.getBlockDayRange(), tailsync.getBlockSize(), tailsync.getRelativeStartDate(), tailsync.getRelativeEndDate(), tailsync.getLastRunStart(), tailsync.getLastRunEnd(), tailsyncDurationMillis, isManualStart, addedEntries, updatedEntries, deletedEntries, error, warnings);
    }

    public static TailsyncLogData createLogForFailedStart(ReplicationJob replicationJob, TailSync tailsync, boolean isManualStart, String error) {
        Date now = new Date();
        return new TailsyncLogData(replicationJob.getId(), replicationJob.getSource().getDataSourceName(), replicationJob.getSource().getTable(), replicationJob.getTarget().getIndex(), tailsync.getRelativeDeleteOlderThanDate(), tailsync.getBlockDayRange(), tailsync.getBlockSize(), tailsync.getRelativeStartDate(), tailsync.getRelativeEndDate(), now, now, 0L, isManualStart, 0L, 0L, 0L, error, new String[0]);
    }
}

