/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.ClientSession;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.auth.idp.IdentityProvider;
import de.virtimo.bpc.api.auth.idp.UserFlowIdentityProvider;
import de.virtimo.bpc.api.exception.IdentityProviderException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.exception.UserSessionNotFoundException;
import de.virtimo.bpc.api.identityManagement.IdentityManagerException;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.auth.PasswordValidatorImpl;
import de.virtimo.bpc.core.auth.UserIdentification;
import de.virtimo.bpc.core.auth.idp.HttpUserSessionRequest;
import de.virtimo.bpc.core.auth.keycloak.KeycloakIdentityProvider;
import de.virtimo.bpc.core.auth.oidc.OidcIdentityProvider;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.license.LicenseService;
import de.virtimo.bpc.core.resource.BpcCookieCreator;
import de.virtimo.bpc.core.resource.CookiesList;
import de.virtimo.bpc.core.resource.response.UserSessionGetDto;
import de.virtimo.bpc.jaxrs.BpcEndpoint;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="authentication")
@Tag(name="Authentication API", description="The Authentication API handles the processes of verifying a user's identity and managing their session within the system.\n")
public class AuthenticationEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(AuthenticationEndpoint.class);
    private static final Logger AUTHENTICATION_LOGGER = LogManager.getLogger((String)"authentication");
    private final BundleContext bundleContext;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;
    private BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private BpcServicesTracker<LicenseService> licenseServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public AuthenticationEndpoint(BundleContext bundleContext) {
        LOGGER.info("AuthenticationEndpoint bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(this.bundleContext, CoreBundleConfiguration.class);
        this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(this.bundleContext, ClientSessionManager.class);
        this.licenseServiceTracker = new BpcServicesTracker<LicenseService>(this.bundleContext, LicenseService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    private CoreModule getCoreModule() throws ServiceNotFoundException, ModuleNotFoundException {
        return AuthenticationEndpoint.getCoreModule(this.moduleManagerTracker);
    }

    private static CoreModule getCoreModule(BpcServicesTracker<ModuleManager> moduleManagerTracker) throws ServiceNotFoundException, ModuleNotFoundException {
        return (CoreModule)moduleManagerTracker.getService().getModuleById("_core");
    }

    @Produces(value={"application/json"})
    @GET
    @BpcEndpoint(skipIpPinningCheck=true)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized")})
    @OperationDescription(summary="Check if the user session is valid.", description="Check if the user session is valid. This function check the presence of an ssoToken. If a token was found, it\nis checked on the identity provider. If no token is found or the check was negative 401 \"UNAUTHORIZED\" will\nbe sent back. If the token was confirmed by the provider 200 OK will be sent.\n")
    @ReturnDescription(value="The user session as JSON.")
    public Response checkSession(@Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOGGER.debug("checkSession");
        try {
            IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
            if (identityProvider == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_NOT_FOUND, "No identity provider found");
            }
            return this.getUserSession(hh, req, identityProvider, null);
        }
        catch (Exception ex) {
            LOGGER.error("Check session failed", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK when no user flow identity provider is in use"), @ApiResponse(responseCode="205", description="OK when a user flow identity provider is in use")})
    @OperationDescription(summary="Destroys the current user session.", description="Destroys the current user session.")
    public Response destroySession(@Context HttpHeaders httpHeaders, @Context HttpServletRequest servletRequest) {
        LOGGER.info("destroySession");
        try {
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            CoreBundleConfiguration coreBundleConfiguration = this.coreBundleConfigurationTracker.getService();
            IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
            UserSession userSession = clientSessionManager.getUserSession(servletRequest);
            String sessionId = userSession == null ? null : userSession.getSessionId();
            UserIdentification userIdentification = new UserIdentification(servletRequest, coreBundleConfiguration.getIpPinningCheckHttpHeaderName());
            if (userSession != null) {
                UserAuditLog.info(userSession, "logout", userIdentification.toString());
            }
            if (identityProvider instanceof UserFlowIdentityProvider) {
                UserFlowIdentityProvider userFlowIdentityProvider = (UserFlowIdentityProvider)identityProvider;
                URI logoutUri = userFlowIdentityProvider.createLogoutURI(userSession, servletRequest);
                LOGGER.debug("logoutUri = {}", (Object)logoutUri);
                if (sessionId != null) {
                    clientSessionManager.removeSession(sessionId, false, identityProvider);
                }
                return Response.status((Response.Status)Response.Status.RESET_CONTENT).cookie(CookiesList.add(this.createDeleteCookie()).asArray()).location(logoutUri).build();
            }
            if (sessionId != null) {
                clientSessionManager.removeSession(sessionId, true, identityProvider);
            }
            return Response.ok().cookie(CookiesList.add(this.createDeleteCookie()).asArray()).build();
        }
        catch (Exception ex) {
            LOGGER.error("Destroying session failed", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(httpHeaders).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/sessions/all")
    @BpcRoleOrRightRequired(role="USER_ADMIN", right="USER_DELETE_SESSIONS", message="Not allowed to delete all sessions")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Destroy all user sessions.", description="Destroy all user sessions.")
    public Response deleteAllSessions(@Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOGGER.info("deleteAllSessions");
        try {
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            if (clientSessionManager.getSessionCount() > 0) {
                clientSessionManager.removeAllSessions(true);
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Deleting all sessions failed", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/sessions/{sessionId}")
    @BpcRoleOrRightRequired(role="USER_ADMIN", right="USER_DELETE_SESSIONS", message="Not allowed to delete sessions")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Destroys a specific user session.", description="Destroys a specific user session.")
    public Response deleteSession(@Parameter(description="the non hijackable ID of the user session to destroy") @PathParam(value="sessionId") String nonHijackableSessionId, @Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOGGER.info("deleteSession sessionId=...");
        try {
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
            String sessionId = clientSessionManager.getSessionIdFromNonHijackableSessionId(nonHijackableSessionId);
            if (sessionId != null && clientSessionManager.existsSession(sessionId)) {
                clientSessionManager.removeSession(sessionId, true, identityProvider);
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Deleting session failed", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @BpcEndpoint(skipIpPinningCheck=true)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Form based login.", description="Form based login. Forwarding credentials to identity provider. If login was ok, the\nssoToken will be placed as cookie in response and the information from\nprovider will be forwarded as JSON.\n")
    @ReturnDescription(value="The user session as JSON.")
    public Response login(MultivaluedMap<String, String> formParams, @Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOGGER.info("login");
        try {
            IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
            if (identityProvider == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_NOT_FOUND, "No identity provider found");
            }
            if (identityProvider instanceof UserFlowIdentityProvider) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_FORM_BASED_LOGIN_NOT_SUPPORTED, "CORE_ERROR_IDENTITY_PROVIDER_FORM_BASED_LOGIN_NOT_SUPPORTED");
            }
            return this.getUserSession(hh, req, identityProvider, formParams);
        }
        catch (Exception ex) {
            LOGGER.error("Login failed", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Form based update of an existing session with the given tenant name.", description="Form based update of an existing session with the given tenant name.")
    @ReturnDescription(value="The user session as JSON.")
    public Response update(@Parameter(description="the name of the tenant") @FormParam(value="tenantname") String tenantname, @Context HttpHeaders httpHeaders, @Context HttpServletRequest servletRequest) {
        LOGGER.info("update");
        try {
            IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
            if (identityProvider == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_NOT_FOUND, "No identity provider found");
            }
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            UserSession userSession = clientSessionManager.getUserSession(servletRequest);
            userSession = identityProvider.updateSession(userSession, tenantname);
            String sessionId = clientSessionManager.getSessionId(servletRequest);
            if (sessionId != null) {
                clientSessionManager.removeSession(sessionId, false, identityProvider);
            }
            if (userSession == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "CORE_ERROR_IDENTITY_PROVIDER_CLIENT_SESSION_MISSING");
            }
            clientSessionManager.addSession(userSession.getSessionId(), userSession);
            return Response.ok((Object)userSession).cookie(CookiesList.add(this.createSessionCookie(userSession)).asArray()).build();
        }
        catch (Exception ex) {
            LOGGER.error("User session update failed", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(httpHeaders).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @PUT
    @Path(value="/language/{lang}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Set the provided language in the user session.", description="Set the provided language in the user session. When Keycloak is used as IdP, the language gets set in the Keycloak user profile (locale).")
    public Response setUserLanguage(@Parameter(description="the language to set") @PathParam(value="lang") String lang, @Context UserSession userSession, @Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOGGER.info("setUserLanguage lang={}", (Object)lang);
        try {
            String currentLocale;
            if (userSession != null && lang != null && !lang.equalsIgnoreCase(currentLocale = (String)userSession.getCustomData().get("locale"))) {
                if (userSession.hasImpersonator()) {
                    return ErrorResponse.forException(new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_FORBIDDEN, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_LANGUAGE_AS_IMPERSONATOR")).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
                }
                userSession.getCustomData().put("locale", lang);
                IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
                if (identityProvider instanceof KeycloakIdentityProvider) {
                    KeycloakIdentityProvider keycloakIdP = (KeycloakIdentityProvider)identityProvider;
                    keycloakIdP.updateUserLanguage(userSession, req, userSession.getLoginName(), lang);
                }
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            if (ex instanceof SystemException) {
                LOGGER.error("Updating user language failed: " + String.valueOf(((SystemException)ex).asMap()), (Throwable)ex);
            } else {
                LOGGER.error("Updating user language failed.", (Throwable)ex);
            }
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/changepassword")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Form based update of the users password.", description="Form based update of the users password. In case the IdP does not support updating user passwords, the user self service is used.\n\nForm params to provide:\n\n- `username` - the name of the user to change the password for\n- `oldPassword` - the old password\n- `newPassword` - the new password\n")
    public Response changePassword(@Context HttpHeaders httpHeaders, @Context HttpServletRequest servletRequest, byte[] body) {
        LOGGER.info("changePassword");
        try {
            IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
            if (identityProvider == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_NOT_FOUND, "No identity provider found");
            }
            if (identityProvider.canUpdateUserPasswords()) {
                Map<String, Object> formParams = StringUtil.formParamsAsMap(new String(body));
                String userName = (String)formParams.get("username");
                String oldPassword = (String)formParams.get("oldPassword");
                String newPassword = (String)formParams.get("newPassword");
                UserSession userSession = this.clientSessionManagerTracker.getService().getUserSession(servletRequest);
                if (userSession == null || !userSession.getLoginName().equalsIgnoreCase(userName)) {
                    throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_PASSWORD_ONLY_USER_ITSELF_CAN");
                }
                if (!this.isValidPassword(newPassword)) {
                    throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_PASSWORD_VALIDATION_FAILED");
                }
                identityProvider.updateUserPassword(userName, oldPassword, newPassword);
                return Response.ok().build();
            }
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CHANGE_PASSWORD_ERROR, "CORE_ERROR_IDENTITY_PROVIDER_CHANGE_PASSWORD_NOT_SUPPORTED");
        }
        catch (Exception ex) {
            LOGGER.error("Change password failed", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(httpHeaders).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private boolean isValidPassword(String password) {
        LOGGER.info("isValidPassword password=...");
        try {
            PasswordValidatorImpl passwordValidator = new PasswordValidatorImpl(this.getCoreModule().getCurrentIdentityProviderConfiguration());
            return passwordValidator.isValid(password);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to check the given password.", (Throwable)ex);
            return false;
        }
    }

    @POST
    @Path(value="/{userName}/impersonate")
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USER_IMPERSONATE", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Failure due to one of the following reasons:\n\n* No username given\n* No user session provided\n* Current identity provider does not support impersonation\n")})
    @OperationDescription(summary="Impersonate a user.", description="Impersonate a user. Works only when Keycloak is used as identity provider.\n\nWhen used with Keycloak one of these Keycloak roles are needed: admin, realm-admin, (manage-users and impersonation)\n")
    @ReturnDescription(value="The user session as JSON.")
    public Response impersonateUser(@Parameter(description="the name of the user to impersonate") @PathParam(value="userName") String userName, @Context UserSession userSession, @Context HttpHeaders hh, @Context HttpServletRequest req) {
        try {
            if (userName == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User name missing");
            }
            if (userSession == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "No user session");
            }
            IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
            if (!(identityProvider instanceof KeycloakIdentityProvider)) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "Impersonation is not supported");
            }
            KeycloakIdentityProvider keycloakIdP = (KeycloakIdentityProvider)identityProvider;
            UserSession impersonatedUserSession = keycloakIdP.impersonateUser(userSession, req, userName);
            impersonatedUserSession.getSensitiveCustomData().put("userIdentificationObject", userSession.getSensitiveCustomData().get("userIdentificationObject"));
            UserAuditLog.info(userSession, "ImpersonateUser", "Impersonation of the user '" + userName + "'.");
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            clientSessionManager.addSession(impersonatedUserSession.getSessionId(), impersonatedUserSession);
            clientSessionManager.transferWebsocketConnections(userSession, impersonatedUserSession);
            clientSessionManager.removeSession(userSession.getSessionId(), true, identityProvider);
            URI redirectURI = this.getBpcFrontendUrl(req);
            LOGGER.info("Post user impersonation redirectURI={}", (Object)redirectURI);
            return Response.ok((Object)impersonatedUserSession).cookie(CookiesList.add(this.createSessionCookie(impersonatedUserSession)).asArray()).location(redirectURI).build();
        }
        catch (Exception ex) {
            LOGGER.error("impersonateUser failed", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @OperationDescription(summary="Get user info by access token.", description="Get user info by access token. Can only be used with an OpenID Connect provider.\n\n.CURL example with 'bearer' as access token type\n[source]\n----\ncurl -X POST \\\n     --header 'X-ApiKey: <YourApiKey>' \\\n     --header 'Content-Type: application/x-www-form-urlencoded' \\\n     --data-urlencode 'accessToken=<ValueOfTheAccessToken>'  \\\n     'http://localhost:8181/cxf/bpc-core/authentication/user/info/bearer/token'\n----\n")
    @ReturnDescription(value="The requested user info as JSON.")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @Path(value="/user/info/{accessTokenType}/token")
    @BpcRoleOrRightRequired(role="USER_ADMIN", right="GET_USER_INFO_BY_TOKEN", message="Not allowed to get user info by token.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Failure due to one of the following reasons:\n\n* Access token type missing or not supported\n* Access token missing\n* Current identity provider does not support token exchange\n")})
    public Response getUserInfo(@Parameter(description="the type of the given access token. Can be `bearer`, `dpop` or `mac`. Keycloak seems to use 'bearer'.") @PathParam(value="accessTokenType") String accessTokenType, @Parameter(description="the access token of the user to get the user info for") @FormParam(value="accessToken") String accessToken, @Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOGGER.info("getUserInfo accessTokenType={}, accessToken=...", (Object)accessTokenType);
        try {
            UserSession userSession;
            if (accessTokenType == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "Token type missing");
            }
            if (!SetUtil.setOf("BEARER", "DPOP", "MAC").contains(accessTokenType.toUpperCase())) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "Invalid token type provided");
            }
            if (accessToken == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "Access token missing");
            }
            IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
            if (!(identityProvider instanceof OidcIdentityProvider)) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "Not supported");
            }
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            List<UserSession> userSessions = clientSessionManager.findUserSessionBySensitiveCustomData("oidc.accessToken", accessToken);
            if (userSessions.size() == 0) {
                LOGGER.info("no existing session found for accessToken; create pseudo UserSession");
                userSession = ((OidcIdentityProvider)identityProvider).getUserInfo(req, accessTokenType, accessToken);
            } else {
                if (userSessions.size() > 1) {
                    LOGGER.warn("found multiple UserSessions for accessToken; use first UserSession and ignore the rest");
                }
                userSession = userSessions.get(0);
            }
            return Response.ok((Object)userSession).build();
        }
        catch (Exception ex) {
            LOGGER.error("getUserInfo failed", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="session/{sessionId}")
    @BpcRoleOrRightRequired(role="USER_ADMIN", right="GET_USER_SESSION", message="Not allowed to get user session.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="No session found")})
    @OperationDescription(summary="Looks up the user session for a given session ID", description="Looks up the user session for a given session ID.\nThe UserSession is returned as JSON.\n")
    @ReturnDescription(value="The user session as JSON.")
    public Response getUserSessionFromNonHijackableSessionId(@Parameter(description="the session id to check the user session for") @PathParam(value="sessionId") String nonHijackableSessionId, @Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOGGER.debug("getUserSessionFromNonHijackableSessionId nonHijackableSessionId={}", (Object)nonHijackableSessionId);
        try {
            UserSession userSession = this.getUserSessionFromNonHijackableSessionId(nonHijackableSessionId);
            UserSessionGetDto userSessionGetDto = new UserSessionGetDto(userSession);
            return Response.ok((Object)userSessionGetDto).build();
        }
        catch (Exception ex) {
            LOGGER.error("Check session failed", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private UserSession getUserSessionFromNonHijackableSessionId(String nonHijackableSessionId) throws ServiceNotFoundException, UserSessionNotFoundException {
        ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
        if (StringUtil.isNullOrEmpty(nonHijackableSessionId)) {
            throw new UserSessionNotFoundException(nonHijackableSessionId);
        }
        String sessionId = clientSessionManager.getSessionIdFromNonHijackableSessionId(nonHijackableSessionId);
        if (StringUtil.isNullOrEmpty(sessionId)) {
            throw new UserSessionNotFoundException(nonHijackableSessionId);
        }
        UserSession userSession = clientSessionManager.getUserSession(sessionId);
        if (userSession == null) {
            throw new UserSessionNotFoundException(nonHijackableSessionId);
        }
        return userSession;
    }

    private Response getUserSession(HttpHeaders hh, HttpServletRequest httpServletRequest, IdentityProvider identityProvider, MultivaluedMap<String, String> formParams) {
        UserIdentification userIdentification;
        LOGGER.debug("getUserSession hh=..., httpServletRequest=..., identityProvider=..., formParams=...");
        try {
            CoreBundleConfiguration coreBundleConfiguration = this.coreBundleConfigurationTracker.getService();
            userIdentification = new UserIdentification(httpServletRequest, coreBundleConfiguration.getIpPinningCheckHttpHeaderName());
        }
        catch (ServiceNotFoundException ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
        HttpUserSessionRequest httpUserSessionRequest = new HttpUserSessionRequest(httpServletRequest, formParams);
        try {
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            UserSession userSession = clientSessionManager.getUserSession(httpServletRequest);
            if (userSession != null) {
                LOGGER.debug("found cached userSession");
                return Response.ok((Object)userSession).cookie(CookiesList.add(this.createSessionCookie(userSession)).asArray()).build();
            }
            LOGGER.debug("no cached userSession found; check IdentityProvider");
            userSession = identityProvider.requestUserSession(httpUserSessionRequest);
            if (userSession == null) {
                throw new SystemException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "CORE_ERROR_IDENTITY_PROVIDER_AUTHENTICATION_FAILED");
            }
            if (!userSession.getSensitiveCustomData().containsKey("userIdentificationObject")) {
                userSession.getSensitiveCustomData().put("userIdentificationObject", userIdentification);
            }
            if (userSession.hasImpersonator()) {
                UserAuditLog.info(userSession.getImpersonatorUsername(), "ImpersonateUser", "Impersonation of the user '" + userSession.getLoginName() + "'.");
            } else {
                UserAuditLog.info(userSession, "login", userIdentification.toString());
            }
            if (clientSessionManager.getSessionCount() >= this.licenseServiceTracker.getService().getConcurrentUserLimit()) {
                if (userSession.hasRole("bpcadmin")) {
                    for (ClientSession session : clientSessionManager.getAllSessions()) {
                        if (!session.getUserSession().hasRole("bpcadmin")) continue;
                        UserAuditLog.warning(userSession, "logout", "Forced CCU limit logout");
                        clientSessionManager.removeSession(session.getUserSession().getSessionId(), true, identityProvider);
                        break;
                    }
                } else {
                    throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_CONCURRENT_USER_LIMIT_REACHED, "AUTHENTICATION_CONCURRENT_USER_LIMIT_REACHED");
                }
            }
            clientSessionManager.addSession(userSession.getSessionId(), userSession);
            CoreModule coreModule = this.moduleManagerTracker.getService().getModuleByClass(CoreModule.class);
            if (!coreModule.isUserAllowedToAccessBPC(userSession)) {
                clientSessionManager.removeSession(userSession.getSessionId(), true, identityProvider);
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_ROLE_CHECK_FAILED, "AUTHENTICATION_MANDATORY_ROLE_TO_ACCESS_BPC_MISSING");
            }
            return Response.ok((Object)userSession).cookie(CookiesList.add(this.createSessionCookie(userSession)).asArray()).build();
        }
        catch (Exception ex) {
            if (ex instanceof SystemException && ((SystemException)ex).isErrorCode(CoreErrorCode.AUTHENTICATION_UNAUTHORIZED)) {
                LOGGER.warn("Check session failed: " + String.valueOf(ex));
            } else {
                LOGGER.error("Check session failed", (Throwable)ex);
            }
            if (ex instanceof IdentityProviderException && httpUserSessionRequest.getFormParam("username") != null) {
                AUTHENTICATION_LOGGER.warn("user authentication failed - {}", (Object)userIdentification.toString());
            }
            if (ex instanceof IdentityProviderException && httpUserSessionRequest.getFormParam("username") != null) {
                UserAuditLog.error(httpUserSessionRequest.getFormParam("username"), "login", userIdentification.toString());
            }
            if (ex instanceof IdentityProviderException && identityProvider instanceof UserFlowIdentityProvider) {
                IdentityProviderException idpException = (IdentityProviderException)ex;
                idpException.setLanguage(ErrorResponseService.getBpcLanguage(hh));
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("application/json").cookie(CookiesList.add(this.createDeleteCookie()).asArray()).entity(idpException.asErrorResponseMap()).build();
            }
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private NewCookie createDeleteCookie() {
        LOGGER.debug("createDeleteCookie");
        String bpcCookieName = this.getBpcCookieName();
        String bpcClientPath = AuthenticationEndpoint.getBpcClientPathFromRelatedSetting(this.moduleManagerTracker);
        BpcCookieCreator bpcCookieCreator = new BpcCookieCreator(bpcCookieName, bpcClientPath);
        return bpcCookieCreator.createDeleteCookie();
    }

    private NewCookie createSessionCookie(UserSession userSession) {
        LOGGER.debug("createSessionCookie userSession=...");
        String bpcCookieName = this.getBpcCookieName();
        String bpcClientPath = AuthenticationEndpoint.getBpcClientPathFromRelatedSetting(this.moduleManagerTracker);
        boolean secureBpcCookie = this.isSecureCookieFlagSetInRelatedSetting();
        BpcCookieCreator bpcCookieCreator = new BpcCookieCreator(bpcCookieName, bpcClientPath);
        return bpcCookieCreator.createSessionCookie(userSession, secureBpcCookie);
    }

    private String getBpcCookieName() {
        LOGGER.debug("getBpcCookieName");
        return AuthenticationEndpoint.getBpcCookieName(this.coreBundleConfigurationTracker);
    }

    public static String getBpcCookieName(BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker) {
        String bpcCookieName;
        LOGGER.debug("getBpcCookieName coreBundleConfigurationTracker=...");
        try {
            CoreBundleConfiguration coreBundleConfiguration = coreBundleConfigurationTracker.getService();
            bpcCookieName = coreBundleConfiguration.getCookieName();
        }
        catch (ServiceNotFoundException e) {
            LOGGER.error("Failed to get coreBundleConfiguration service", (Throwable)e);
            bpcCookieName = "BPC_J_S";
        }
        return bpcCookieName;
    }

    private boolean isSecureCookieFlagSetInRelatedSetting() {
        boolean secure;
        LOGGER.debug("isSecureCookieFlagSetInRelatedSetting");
        try {
            CoreBundleConfiguration coreBundleConfiguration = this.coreBundleConfigurationTracker.getService();
            secure = coreBundleConfiguration.isSecureCookieFlagSet();
            LOGGER.debug("Secure cookie flag: " + secure);
        }
        catch (ServiceNotFoundException e) {
            LOGGER.error("Failed to get coreBundleConfiguration service", (Throwable)e);
            secure = false;
        }
        return secure;
    }

    private URI getBpcFrontendUrl(HttpServletRequest req) throws URISyntaxException {
        LOGGER.debug("getBpcFrontendUrl req={}", (Object)req);
        String bpcBaseUrl = AuthenticationEndpoint.getBpcBaseUrlFromRelatedSetting(this.moduleManagerTracker);
        String bpcClientPath = AuthenticationEndpoint.getBpcClientPathFromRelatedSetting(this.moduleManagerTracker);
        return new URI(StringUtil.glue(bpcBaseUrl, bpcClientPath, '/'));
    }

    private static String getBpcBaseUrlFromRelatedSetting(BpcServicesTracker<ModuleManager> moduleManagerTracker) {
        String bpcBaseUrl;
        LOGGER.debug("getBpcBaseUrlFromRelatedSetting moduleManagerTracker=...");
        try {
            bpcBaseUrl = (String)AuthenticationEndpoint.getCoreModule(moduleManagerTracker).getConfiguration().getSetting("bpcBaseUrl").getValue();
            LOGGER.debug("Found the 'bpcBaseUrl' value: {}", (Object)bpcBaseUrl);
        }
        catch (ModuleNotFoundException | ServiceNotFoundException ex) {
            LOGGER.error("Failed to get the value of the core setting 'bpcBaseUrl'.", (Throwable)ex);
            bpcBaseUrl = "http://localhost:8181";
        }
        return bpcBaseUrl;
    }

    public static String getBpcClientPathFromRelatedSetting(BpcServicesTracker<ModuleManager> moduleManagerTracker) {
        String bpcClientPath;
        LOGGER.debug("getBpcClientPathFromRelatedSetting moduleManagerTracker=...");
        try {
            bpcClientPath = (String)AuthenticationEndpoint.getCoreModule(moduleManagerTracker).getConfiguration().getSetting("clientPath").getValue();
            LOGGER.debug("Found the 'clientPath' value: {}", (Object)bpcClientPath);
        }
        catch (ModuleNotFoundException | ServiceNotFoundException ex) {
            LOGGER.error("Failed to get the value of the core setting 'clientPath'.", (Throwable)ex);
            bpcClientPath = "/";
        }
        return bpcClientPath;
    }
}

