/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.message.Message;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class BpcResponseInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final Logger LOGGER = LogManager.getLogger(BpcResponseInterceptor.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;

    public BpcResponseInterceptor(BundleContext bundleContext) {
        super("marshal");
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(this.bundleContext, CoreBundleConfiguration.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll((Object)this);
    }

    private void addServerUUID(Map<String, List<String>> headers) {
        if (headers != null) {
            try {
                String bpcServerUUID = this.coreBundleConfigurationTracker.getService().getServerUUID();
                headers.put("X-BPC-Server-UUID", List.of(bpcServerUUID));
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to add the BPC server UUID to the response header.", (Throwable)ex);
            }
        }
    }

    public void handleMessage(Message outMessage) {
        if (outMessage != null) {
            TreeMap headers = (TreeMap)outMessage.get((Object)Message.PROTOCOL_HEADERS);
            if (headers == null) {
                headers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                outMessage.put((Object)Message.PROTOCOL_HEADERS, headers);
            }
            this.addServerUUID(headers);
        }
    }
}

