/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BackupManager;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auditlog.SystemAuditLog;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.opensearch.IndexInfo;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.api.service.ExtOpenSearchService;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.opensearch.migration.BpcIndicesMigrator;
import de.virtimo.bpc.core.replicator.ReindexAction;
import de.virtimo.bpc.core.replicator.ReindexActionException;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationModule;
import de.virtimo.bpc.core.service.OpenSearchSettingsCleaner;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import de.virtimo.bpc.logservice.LogServiceModule;
import de.virtimo.bpc.logservice.LogServiceModuleInstance;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.ObjectMapperPool;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="opensearch")
@Tag(name="OpenSearch API", description="These endpoints allow to list, delete and reindex OpenSearch indices as well as to receive index mappings.\n")
public class OpenSearchEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(OpenSearchEndpoint.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private BpcServicesTracker<ExtOpenSearchService> extopenSearchServiceTracker;
    private BpcServicesTracker<BackupManager> backupManagerTracker;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private static final Object REINDEXING_LOCK = new Object();
    private final Map<String, String> currentlyReindexing;

    public OpenSearchEndpoint(BundleContext bundleContext) {
        LOGGER.info("OpenSearchEndpoint bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
        this.currentlyReindexing = new HashMap<String, String>();
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(this.bundleContext, OpenSearchService.class);
        this.extopenSearchServiceTracker = new BpcServicesTracker<ExtOpenSearchService>(this.bundleContext, ExtOpenSearchService.class);
        this.backupManagerTracker = new BpcServicesTracker<BackupManager>(this.bundleContext, BackupManager.class);
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationDisable={SerializationFeature.FAIL_ON_EMPTY_BEANS})
    @BpcRoleOrRightRequired(role="OPENSEARCH_ADMIN", right="OPENSEARCH_LIST_INDICES", message="Not allowed to handle OpenSearch indices")
    @Path(value="/indices")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Get a list of all OpenSearch indices.", description="Get a list of all OpenSearch indices.")
    @ReturnDescription(value="The requested data as JSON")
    public Response listIndices(@Context HttpHeaders hh) {
        LOGGER.info("listIndices");
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            Map<String, IndexInfo> indexInfos = oss.getIndexInfos();
            Object object = REINDEXING_LOCK;
            synchronized (object) {
                for (String reindexSource : this.currentlyReindexing.keySet()) {
                    String reindexTarget = this.currentlyReindexing.get(reindexSource);
                    if (reindexSource != null && indexInfos.containsKey(reindexSource)) {
                        IndexInfo reindexSourceIndexInfo = indexInfos.get(reindexSource);
                        reindexSourceIndexInfo.setReindexRunning(true);
                    }
                    if (reindexTarget == null || !indexInfos.containsKey(reindexTarget)) continue;
                    IndexInfo reindexTargetIndexInfo = indexInfos.get(reindexTarget);
                    reindexTargetIndexInfo.setReindexRunning(true);
                }
            }
            return Response.ok(indexInfos.values()).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @Path(value="/indices/compact")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Get a compact list of OpenSearch indices.", description="Get a compact list of OpenSearch indices. Can be used for example in a combo box.")
    @ReturnDescription(value="The requested data as JSON")
    public Response getCompactIndicesList(@Context HttpHeaders hh) {
        LOGGER.info("getCompactIndicesList");
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            HashMap<String, Set> result = new HashMap<String, Set>();
            Map<String, IndexInfo> indexInfos = oss.getIndexInfos();
            for (String indexName : indexInfos.keySet()) {
                IndexInfo indexInfo = indexInfos.get(indexName);
                if (!indexInfo.isInState("open") || indexName.startsWith(".") || indexInfo.isHidden()) continue;
                if (indexInfo.getAliases().isEmpty()) {
                    result.put(indexName, new HashSet());
                    continue;
                }
                for (String alias2 : indexInfo.getAliases()) {
                    if (result.containsKey(alias2)) {
                        Set alreadySetAlternativeNames = (Set)result.get(alias2);
                        alreadySetAlternativeNames.add(indexName);
                        continue;
                    }
                    HashSet<String> alternativeNames = new HashSet<String>();
                    alternativeNames.add(indexName);
                    result.put(alias2, alternativeNames);
                }
            }
            ArrayList resultList = new ArrayList();
            result.forEach((alias, indices) -> {
                HashMap<String, Object> entry = new HashMap<String, Object>();
                entry.put("alias", alias);
                entry.put("indices", indices);
                resultList.add(entry);
            });
            return Response.ok(resultList).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationDisable={SerializationFeature.FAIL_ON_EMPTY_BEANS})
    @BpcRoleOrRightRequired(role="OPENSEARCH_ADMIN", right="OPENSEARCH_GET_MAPPING", message="Not allowed to handle OpenSearch indices")
    @Path(value="/indices/mapping/{indexName}")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Get the settings and mappings of an OpenSearch index.", description="Get the settings and mappings of an OpenSearch index.")
    @ReturnDescription(value="The requested data as JSON")
    public Response getMapping(@Parameter(description="the name of the index") @PathParam(value="indexName") String indexName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("getMapping indexName={}", (Object)indexName);
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
            result.put("settings", oss.getSettings(indexName));
            result.put("mappings", oss.getMapping(indexName));
            return Response.ok(result).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @JacksonFeatures(serializationDisable={SerializationFeature.FAIL_ON_EMPTY_BEANS})
    @BpcRoleOrRightRequired(role="OPENSEARCH_ADMIN", right="OPENSEARCH_DELETE_INDEX", message="Not allowed to handle OpenSearch indices")
    @Path(value="/indices/operations/{indexName}")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Delete an OpenSearch index.", description="Delete an OpenSearch index.")
    public Response deleteIndex(@Parameter(description="the name of the index to delete") @PathParam(value="indexName") String indexName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("deleteIndex indexName={}", (Object)indexName);
        try {
            ExtOpenSearchService extOpenSearchService = this.extopenSearchServiceTracker.getService();
            try {
                extOpenSearchService.deleteIndex(indexName, userSession);
                return Response.ok((Object)("Index " + indexName + " successfully deleted")).build();
            }
            catch (OpenSearchRelatedException ex) {
                return Response.serverError().status(500).entity((Object)("Index " + indexName + " was not deleted")).build();
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to delete the index '" + indexName + "'.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="OPENSEARCH_ADMIN", right="OPENSEARCH_REINDEX", message="Not allowed to handle OpenSearch indices")
    @Path(value="/indices/reindex/{indexName}")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Get the information what a reindex action would do with the index settings and mappings.", description="Get the information what a reindex action would do with the index settings and mappings.")
    @ReturnDescription(value="The old and new index settings and mappings as JSON")
    public Response getReindexIndexInfo(@Parameter(description="the name of the index") @PathParam(value="indexName") String indexName, @Parameter(description="`true` to copy the index mapping, otherwise `false`") @QueryParam(value="copyIndexMapping") @DefaultValue(value="true") boolean copyIndexMapping, @Parameter(description="`true` to copy the meta data, otherwise `false`") @QueryParam(value="copyMetaData") @DefaultValue(value="true") boolean copyMetaData, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("getReindexIndexInfo indexName={}, copyIndexMapping={}, copyMetaData={}", (Object)indexName, (Object)copyIndexMapping, (Object)copyMetaData);
        Object object = REINDEXING_LOCK;
        synchronized (object) {
            if (this.currentlyReindexing.containsKey(indexName)) {
                return ErrorResponse.forException(new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_ALREADY_STARTED, "Reindex of index '${index}' is already running.", MapUtil.mapOf("index", indexName))).usingTracker(this.errorResponseServiceTracker).languageFrom(hh).build();
            }
        }
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            BackupManager backupManager = this.backupManagerTracker.getService();
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            ReplicationModule replicationModule = moduleManager.getModuleByClass(ReplicationModule.class);
            LogServiceModule logServiceModule = moduleManager.getModuleByClass(LogServiceModule.class);
            Set<String> aliasesForIndexName = oss.getAliasesForIndexName(indexName);
            List<ReplicationJob> relatedReplicationJobs = replicationModule.getReplicationJobsUsingTargetIndexAliases(aliasesForIndexName);
            List<LogServiceModuleInstance> relatedLogServices = logServiceModule.getLogServicesUsingTargetIndexAliases(aliasesForIndexName);
            Map<String, Object> defaultIndexCreationSettings = oss.getDefaultIndexCreationSettings();
            List defaultDynamicTemplates = oss.getDefaultDynamicTemplates();
            ReindexAction reindexAction = new ReindexAction(this.bundleContext, oss, backupManager, indexName, copyIndexMapping, copyMetaData, false, false, defaultIndexCreationSettings, defaultDynamicTemplates);
            reindexAction.setRelatedReplicationJobs(relatedReplicationJobs);
            reindexAction.setRelatedLogServices(relatedLogServices);
            Object result = "";
            result = (String)result + "{";
            result = (String)result + "  \"source\": {";
            result = (String)result + "    \"settings\":" + this.createMapOrderedByKeysAsJsonString(OpenSearchSettingsCleaner.clearSettingsMapFromKnownPrivateSettings(reindexAction.getSourceIndexSettings()));
            result = (String)result + "    ,";
            result = (String)result + "    \"mappings\":" + this.createMapOrderedByKeysAsJsonString(reindexAction.getSourceIndexMappings());
            result = (String)result + "  },";
            result = (String)result + "  \"target\": {";
            result = (String)result + "    \"settings\":" + this.createMapOrderedByKeysAsJsonString(OpenSearchSettingsCleaner.clearSettingsMapFromKnownPrivateSettings(reindexAction.getIndexSettingsOfTemporarilyCreateTargetIndex()));
            result = (String)result + "    ,";
            result = (String)result + "    \"mappings\":" + this.createMapOrderedByKeysAsJsonString(reindexAction.getTargetIndexMappings());
            result = (String)result + "  }";
            result = (String)result + "}";
            return Response.ok((Object)result).build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get the reindex infos of the index '{}'.", (Object)indexName, (Object)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private String createMapOrderedByKeysAsJsonString(Map<String, ?> map) throws JsonProcessingException {
        ObjectMapper om = ObjectMapperPool.createCustomizedObjectMapper();
        om.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        return om.writeValueAsString(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @BpcRoleOrRightRequired(role="OPENSEARCH_ADMIN", right="OPENSEARCH_REINDEX", message="Not allowed to handle OpenSearch indices")
    @Path(value="/indices/reindex/{indexName}")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Perform a reindex action.", description="Perform a reindex action.")
    public Response reindexIndex(@Parameter(description="the name of the index to reindex") @PathParam(value="indexName") String indexName, @Parameter(description="`true` to copy the index mapping, otherwise `false`") @QueryParam(value="copyIndexMapping") @DefaultValue(value="true") boolean copyIndexMapping, @Parameter(description="`true` to copy the meta data, otherwise `false`") @QueryParam(value="copyMetaData") @DefaultValue(value="true") boolean copyMetaData, @Parameter(description="`true` to delete the source index afterwards, `false` to close it instead") @QueryParam(value="deleteSourceIndexAfterwards") @DefaultValue(value="true") boolean deleteSourceIndexAfterwards, @Parameter(description="`true` to create a backup of the source index before reindex") @QueryParam(value="createBackupBeforeReindexing") @DefaultValue(value="false") boolean createBackupBeforeReindexing, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("reindexIndex indexName={}, copyIndexMapping={}, copyMetaData={}, deleteSourceIndexAfterwards={}, createBackupBeforeReindexing={}", (Object)indexName, (Object)copyIndexMapping, (Object)copyMetaData, (Object)deleteSourceIndexAfterwards, (Object)createBackupBeforeReindexing);
        Object object = REINDEXING_LOCK;
        synchronized (object) {
            if (this.currentlyReindexing.containsKey(indexName)) {
                return ErrorResponse.forException(new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_ALREADY_STARTED, "Reindex of index '${index}' is already running.", MapUtil.mapOf("index", indexName))).usingTracker(this.errorResponseServiceTracker).languageFrom(hh).build();
            }
            this.currentlyReindexing.put(indexName, null);
        }
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            BackupManager backupManager = this.backupManagerTracker.getService();
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            ReplicationModule replicationModule = moduleManager.getModuleByClass(ReplicationModule.class);
            LogServiceModule logServiceModule = moduleManager.getModuleByClass(LogServiceModule.class);
            Set<String> aliasesForIndexName = oss.getAliasesForIndexName(indexName);
            BpcIndicesMigrator migrator = new BpcIndicesMigrator(oss);
            if (migrator.isMigratableIndex(aliasesForIndexName) && migrator.mustBeMigrated(aliasesForIndexName)) {
                throw new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_MIGRATION_NECESSARY, "Reindex of index '${index}' is not possible, as a migration is necessary first.", MapUtil.mapOf("index", indexName));
            }
            List<ReplicationJob> relatedReplicationJobs = replicationModule.getReplicationJobsUsingTargetIndexAliases(aliasesForIndexName);
            HashSet<String> relatedReplicationJobIDs = new HashSet<String>();
            for (ReplicationJob relatedReplicationJob : relatedReplicationJobs) {
                relatedReplicationJobIDs.add(relatedReplicationJob.getId());
            }
            List<LogServiceModuleInstance> relatedLogServices = logServiceModule.getLogServicesUsingTargetIndexAliases(aliasesForIndexName);
            if (!relatedReplicationJobIDs.isEmpty()) {
                replicationModule.sendReplicationJobsToPluginForOrchestrationForJobsToStopTemporarily(relatedReplicationJobIDs, true);
                SystemAuditLog.info("ReplicationJobsOrchestration", "Replication jobs orchestration started due to the jobs '" + String.valueOf(relatedReplicationJobIDs) + "' that must be temporarily stopped. Caused by reindex action of index '" + indexName + "'.");
                replicationModule.waitUntilReplicationJobsAreStopped(relatedReplicationJobIDs);
            }
            Map<String, Object> defaultIndexCreationSettings = oss.getDefaultIndexCreationSettings();
            List defaultDynamicTemplates = oss.getDefaultDynamicTemplates();
            ReindexAction reindexAction = new ReindexAction(this.bundleContext, oss, backupManager, indexName, copyIndexMapping, copyMetaData, deleteSourceIndexAfterwards, createBackupBeforeReindexing, defaultIndexCreationSettings, defaultDynamicTemplates);
            reindexAction.setRelatedReplicationJobs(relatedReplicationJobs);
            reindexAction.setRelatedLogServices(relatedLogServices);
            Object object2 = REINDEXING_LOCK;
            synchronized (object2) {
                this.currentlyReindexing.put(indexName, reindexAction.getTargetIndexName());
            }
            try {
                reindexAction.perform();
                UserAuditLog.info(userSession, "OpenSearchIndexReindexed", "OpenSearch index '" + reindexAction.getSourceIndexName() + "' with the alias '" + reindexAction.getAliasName() + "' reindexed to '" + reindexAction.getTargetIndexName() + "'.", (Object)reindexAction.getSourceIndexName(), (Object)reindexAction.getTargetIndexName());
            }
            finally {
                if (!relatedReplicationJobIDs.isEmpty()) {
                    replicationModule.sendReplicationJobsToPluginForOrchestrationForJobsToStopTemporarily(relatedReplicationJobIDs, false);
                    SystemAuditLog.info("ReplicationJobsOrchestration", "Replication jobs orchestration started due to the jobs '" + String.valueOf(relatedReplicationJobIDs) + "' that must be restarted. Caused by reindex action of index '" + indexName + "'.");
                    replicationModule.waitUntilReplicationJobsAreRunning(relatedReplicationJobIDs);
                }
            }
            object2 = Response.ok((Object)("Index " + indexName + " successfully reindexed")).build();
            return object2;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to reindex the index '{}'.", (Object)indexName, (Object)ex);
            Response response = ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
            return response;
        }
        finally {
            Object object3 = REINDEXING_LOCK;
            synchronized (object3) {
                this.currentlyReindexing.remove(indexName);
            }
        }
    }
}

